function [p] = ast_cdf(y,param,sigmas)

alpha = param(1); 
nul = param(2);  
nur = param(3);  
mu = param(4); 
lambda = log(sigmas); 

Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr); 

z = (y-mu)./exp(lambda);

p = 2*alpha*tcdf(min(z./(2*astar),0),nul) + 2*(1-alpha)*(tcdf(max(z./(2*(1-astar)),0),nur)-0.5);

end

