function [nlnL,sigmas,scores,step1f] = DCS_ST_vol_wlev_nll(param,y)
%% Function for the negative loglikelihood of the DCS_ST score driven volatility model with leverage.
%% Skew t distribution is specified in accordance with Zhu and Galbraith (2010, JoE).
%% If an initial parameter is provided for the mode (at the end of the parameter vector), the 
%% mode will be estimated by ML.  Otherwise it is set equal to zero.
%% The time varying scale is constrained using an exponential link function.
%% The score is scaled by the inverse of the information quantity in the dynamic equation for the scale.

omega = param(1);                    %%  parametised in terms of the unconditional level of lambda.
phi = .999/(1+exp(-param(2)));
kappa = exp(param(3));
alpha = .999/(1+exp(-param(4)));
psi = param(5);
nu = 330/(1+exp(-param(6)));
mu = 0;
if length(param) == 7
        mu = param(7);
end
nul = nu;
nur = nu;


T = length(y);

lambda = [omega/(1-phi) ; zeros(T,1)];        %% scale is initialised at the unconditional expectation.
sscore = zeros(T+1,1);                          %% scaled score is initialised at 0.
levterm = 0;

Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);

sgnmy = sign(-y);
ym = (y-mu);
ysq = ym.^2;
pFl = ysq/(nul*4*astar^2);
pFr = ysq/(nur*4*(1-astar)^2);

scaletleft = (nul+3)/(2*nul);
scaletright = (nur+3)/(2*nur);
    
rightind = (sign(ym)+1)/2;

for t=1:T
    
    lambdat = omega + phi*lambda(t) + kappa*sscore(t) + psi*levterm;
    sigmat = exp(lambdat);
    
    if (y(t) <= mu)                                           %%  Determining which side of the density to apply

    F = pFl(t)/(sigmat)^2;
    scoret = (nul+1)*F/(1+F) - 1;
    sscoret = scaletleft*scoret;
    levterm = sgnmy(t)*(sscoret+1);
        
    else
    
    F = pFr(t)/(sigmat)^2;
    scoret = (nur+1)*F/(1+F) - 1;
    sscoret = scaletright*scoret;
    levterm = sgnmy(t)*(sscoret+1);
    end
   
    lambda(t+1,1) = lambdat;
    sscore(t+1,1) = sscoret;
    
    step1f = exp(omega + phi*lambdat + kappa*sscoret + psi*levterm);
end

%%%% llf left
    Fl = pFl./exp(2*lambda(2:T+1));
    llft1 =   log( alpha*(gamma(nul/2+.5)/(gamma(nul/2)*sqrt(pi*nul))) + (1-alpha)*(gamma(nur/2+.5)/(gamma(nur/2)*sqrt(pi*nur))));
    llft2 = -lambda(2:T+1);
    llft3 = -(nul/2+.5)*log(1 + Fl);

    llftleft = llft1 + llft2 + llft3;
 
%%%% llf right
    Fr = pFr./exp(2*lambda(2:T+1));
    llft1 =   log( alpha*(gamma(nul/2+.5)/(gamma(nul/2)*sqrt(pi*nul))) + (1-alpha)*(gamma(nur/2+.5)/(gamma(nur/2)*sqrt(pi*nur))));
%     llft2 = -lambda;
    llft3 = -(nur/2+.5)*log(1 + Fr);

    llftright = llft1 + llft2 + llft3;
    
    
    
    llf = llftleft.*(1-rightind) + llftright.*(rightind);



sigmas = exp(lambda(2:(T+1),1));               %%  (T*1) vector of tv scales for skew-t dist
scores = sscore(2:(T+1),1);                    %%  (T*1) vector of scaled scores

nlnL = -1*sum(llf);

end