function [y]=truncateDraw(lbound, ubound, mu, sigma)
% Draw random variable from truncated normal
% YuFan Huang February 2010
% vectorized by Dick Startz, June 2014
% allow sigma to be vector too, Dick Startz April 2016

[m,n] = size(mu);
u=rand(m,n); 
f=normcdf((lbound-mu)./sqrt(sigma))...
    +u.*(normcdf((ubound-mu)./sqrt(sigma))-normcdf((lbound-mu)./sqrt(sigma)));
zt=norminv(f); 
y=mu+zt.*sqrt(sigma);

end