function testGini
%{
test program for computing Gini coefficient
Dick Startz
January 2019
%}
load testGini
[nCountries, nYears, nDraws] = size(simulatedFutureLevelIncome);
g = nan(nYears, nDraws);
tic;
for iDraw = 1:nDraws
    for iYear = 1:nYears
        g(iYear,iDraw) = ...
            giniCoefficient(squeeze(simulatedFutureLevelIncome(:,iYear,iDraw)),...
            popWeight(:,iYear));
    end
end
figure;
plot(1:nYears,median(g,2),'linewidth',1.5);
hold on;
plot(1:nYears,prctile(g,05,2),':','linewidth',1.5);
plot(1:nYears,prctile(g,95,2),':','linewidth',1.5);
hold off;
elapsedTime = toc;
disp(['Computing ',num2str(nDraws),' draws took ',num2str(elapsedTime),...
    ' seconds']);

end