function pie = steadyStateProbabilities(P)
%{
Given the transition probability matrix P of a Markov process
return the steady state probabilities
This is done by finding the left eigenvector corresponding
to eigenvalue 1.0 and rescaling

Dick Startz
March 2017
%}
[~,D,W] = eig(P);
[~,whichEigen] = min(abs(diag(D)-1));

pie = W(:,whichEigen)/sum(W(:,whichEigen));
end

