function chinaBubbles
%{
make animations of China's growth
horizontal axis is year
vertical axis is relative income
size is fraction of contribution to world per capita GDP

Dick Startz
May 2017
%}

load('simulated3StateFuturesFrom2014Split.mat');

countryNumber = chinaCountryNumber;
firstYearToPlot = 1955;
firstOb = firstObForCountry(countryNumber)...
    + firstYearToPlot - firstYearForCountry(countryNumber);
lastOb = lastObForCountry(countryNumber);

yearsToPlot = firstYearToPlot:2014;
ratio = exp(gap(firstOb:lastOb));

proportionOfGap = popWeightWorldLast(countryNumber)...
    *exp(gap(firstOb:lastOb))/weightedGap(yearsToPlot-1950);
bubbleSize = 4*proportionOfGap*36/max(proportionOfGap);
%make it look nice
myVideo = VideoWriter('chinaBubble1.avi');
myVideo.FrameRate = 15;
open(myVideo);
figure;
axis([1950 2020 0 0.25]);
xlabel('year');
ylabel('Ratio of per capita income to world frontier');
title({['China: ',num2str(firstYearToPlot),'-2014'],...
    '(bubble size proportional to China''s weight in world income)'});
hold on;
plot([1990 1990],[0 0.25],'k');
for i = 1:length(yearsToPlot)
    scatter(yearsToPlot(i),ratio(i),bubbleSize(i),'red');
    scatter(yearsToPlot(i),ratio(i),bubbleSize(i),'red');
    frame = getframe(gcf);
    writeVideo(myVideo,frame);
end
close(myVideo);

% make future movie
medFutureLevelIncome = nan(nCountries,nYears);
medWeightedWorldIncome...
    = median(exp(simulatedFutureLogUSA),2)*popWeightUSALast;
for iCountry = 1:nCountries
    medFutureLevelIncome(iCountry,:) =...
        median(exp(squeeze(simulatedFutureLogIncome(iCountry,:,:))),2);
    medWeightedWorldIncome = medWeightedWorldIncome...
        + medFutureLevelIncome(iCountry,:)'*popWeightWorldLast(iCountry);
end
futureIncome = medFutureLevelIncome(countryNumber,:);

yearsToPlot = 2015:2114;
myVideo = VideoWriter('chinaBubble2.avi');
myVideo.FrameRate = 15;
open(myVideo);
figure;
p1 = plot([yearsToPlot(1),yearsToPlot(end)],[yStarLast/1000,yStarLast/1000],...
    ':k','linewidth',1);
hold on;
p2 = plot([yearsToPlot(1),yearsToPlot(2)],...
    [futureIncome(1)/1000,futureIncome(2)/1000],'red',...
    'linewidth',1.5);
axis([2010 2120 0 250]);
xlabel('year');
ylabel('Per capita income');
title({'China: 2015-2114',...
    'Per capita income in thousands of 2011 US dollars'});
for i = 1:length(yearsToPlot)-1
    plot([yearsToPlot(i),yearsToPlot(i+1)],...
        [futureIncome(i)/1000,futureIncome(i+1)/1000],'red',...
        'linewidth',1.5);
    plot([yearsToPlot(i),yearsToPlot(i+1)],...
        [futureIncome(i)/1000,futureIncome(i+1)/1000],'red',...
        'linewidth',1.5);
    if i == length(yearsToPlot)-1
        legend([p1,p2],'USA 2014','China','location','Northwest');
    end
    frame = getframe(gcf);
    writeVideo(myVideo,frame);
end

close(myVideo);

end

