function checkConvergentStates
%{
Make histograms of convergent state at end of period
and forecast forward

Dick Startz
April 2017
%}
tic;
futureFileName = 'simulated3StateFuturesFrom2014';
load(futureFileName);

finalStateMean = nan(nCountries,1);
for iCountry = 1:nCountries
    finalStateMean(iCountry) = mean(S(lastObForCountry(iCountry),:)==2,2);
end

figure;
histogram(finalStateMean);
title('Distribution of Estimated Mean of Convergent State in 2014');

fractionBelow20 = mean(finalStateMean<.2);
fractionAbove80 = mean(finalStateMean>.8);

disp(['Fraction below 20=',num2str(fractionBelow20)]);
disp(['Fraction above 80=',num2str(fractionAbove80)]);

figure;
scatter(finalGap,finalStateMean);

elapsedTime = toc;
disp(['Executed ',mfilename,' in ',num2str(elapsedTime),' seconds on ',...
    datestr(datetime)]);
end


