function S = carterKohnAR1RestrictedSplit(y,yLag,rho,h,P,split,before)
masybe unneeded
%{
Try Carter-Kohn draws for many states with AR1 structures
This version puts in a special restriction about ending up in the last
state

split defines the beginning of the second sample subperiod in range 1:n
before tells which subperiod to use

return sub vector

Dick Startz
March 2017
revised April 2017
%}
% n = length(y);  % number of data points
if before
    firstPoint = 1;
    lastPoint = split - 1;
else
    firstPoint = split;
    lastPoint = length(y);
end
n = lastPoint - firstPoint + 1;
M = length(rho);  % number of states

pLag = nan(n,M);    %p(S|lagged info)
pCurrent = nan(n,M);       %p(S|current info)
pStar = nan(n,M);   %temp for probability calculation
pSteadyState = steadyStateProbabilities(P);

%forward filter
for t = firstPoint:lastPoint
    % Step 1
    if t>firstPoint
        for state_t = 1:M
            temp = 0;
            for m=1:M
                temp = temp + P(m,state_t)*pCurrent(t-(firstPoint-1)-1,m);
            end
            pLag(t-(firstPoint-1),state_t) = temp;
        end
    else
        for state_t = 1:M
            temp = 0;
            for m=1:M
                temp = temp + P(m,state_t)*pSteadyState(m);
            end
            pLag(t-(firstPoint-1),state_t) = temp;
        end
    end
    
    % Step 2
    for state_t = 1:M
        pStar(t-(firstPoint-1),state_t)...
            = normpdf(y(t),rho(state_t)*yLag(t),1/sqrt(h(state_t)))...
            *pLag(t-(firstPoint-1),state_t);
    end
    % Step 3
    for state_t = 1:M
        pCurrent(t-(firstPoint-1),state_t) =...
            pStar(t-(firstPoint-1),state_t)/sum(pStar(t-(firstPoint-1),:));
    end
end

%backward filter
S = nan(n,1);
S(n) = myRandomState(pCurrent(n,:));
if (y(lastPoint) > 0) && S(n) == 3
    S(n) = 1;
end

prob = nan(M,1);

for t = lastPoint-1:-1:firstPoint
    for state_t = 1:M
        prob(state_t) = ...
            P(state_t,S(t-(firstPoint-1)+1))*pCurrent(t-(firstPoint-1),state_t)...
            /pLag(t-(firstPoint-1)+1,S(t-(firstPoint-1)+1));
    end
    S(t-(firstPoint-1)) = myRandomState(prob);
    if (y(t) > 0) && S(t-(firstPoint-1)) == 3
        S(t-(firstPoint-1)) = 1;
    end
end
end