* First written April 14 2016
* New update for JAE revision Januay 29, 2018
* This program replicates SW 2009 QJE results / handbook results using new Genetic Distance data from Pemberton et al.

clear
set memory 60m
set matsize 400
use bilateral_new
set more off

* Define Variables

replace dist=dist/1000
label variable dist "Geodesic Distance (1000s of km)"
replace fst_distance_dominant=fst_distance_dominant/10000
label variable gendist_fst "Fst Genetic Distance"
replace gendist_fst_1500=gendist_fst_1500/10000
replace fst_distance_weighted=fst_distance_weighted/10000
label variable fst_distance_weighted "Weighted Fst Genetic Distance, Cavalli-Sforza et al."
label variable gendist_fst_1500 "Fst Genetic Distance, 1500 match"
gen gendist_nei=nei_distance_dominant/10000
label variable gendist_nei "Nei Genetic Distance"
gen gendist_nei_weighted=nei_distance_weighted/10000
label variable gendist_nei_weighted "Nei Genetic Distance, weighted"
replace gendist_nei_1500=gendist_nei_1500/10000
label variable gendist_nei_1500 "Nei Genetic Distance, 1500 match"
label variable relgendist_fst_weighted_USA "Relative FST genetic distance to the USA, weighted, Cavalli-Sforza et al."
gen difflat=(abs(latitude_cia_2-latitude_cia_1))/100
label variable difflat "Absolute difference in latitudes"
* Note the correct definition of longitudinal difference below
gen difflong=abs(longitude_cia_1-longitude_cia_2)
replace difflong=360-difflong if difflong>180
replace difflong=difflong/100
label variable difflong "Absolute difference in longitudes"
gen dlinc1960=abs(log(rgdpch1960_1)-log(rgdpch1960_2))
label variable dlinc1960 "Absolute difference in log income (PWT), 1960"
gen dlinc1995=abs(log(wb_gdppc1995_2)-log(wb_gdppc1995_1))
label variable dlinc1995 "Absolute difference in log income (WB), 1995"
label variable comlang_ethno "1 if common language (9% threshold)"
label variable relgendist_fst_USA "Fst genetic distance relative to the USA"
replace cognate_dominant=1-(cognate_dominant/1000)
label variable cognate_dominant "1 - % cognate, dominant languages"
replace cognate_weighted=1-(cognate_weighted/1000)
label variable cognate_weighted "1 - % cognate, weighted"
replace cognate_dom_to_USA_1=1-(cognate_dom_to_USA_1/1000)
replace cognate_weighted_to_USA_1=1-(cognate_weighted_to_USA_1/1000)
replace cognate_dom_to_USA_2=1-(cognate_dom_to_USA_2/1000)
replace cognate_weighted_to_USA_2=1-(cognate_weighted_to_USA_2/1000)

gen eurasia_1=weurope_1+eeurope_1+nafrica_1+seasia_1+soasia_1+scasia_1+mideast_1
gen eurasia_2=weurope_2+eeurope_2+nafrica_2+seasia_2+soasia_2+scasia_2+mideast_2
gen diamond_gap=abs(eurasia_2-eurasia_1)
drop eurasia_1 eurasia_2
label variable diamond_gap "Diamond Gap"
#delimit ;
gen climate_area=(100*(abs(kg_a_af_1-kg_a_af_2)+abs(kg_a_am_1-kg_a_am_2)+abs(kg_a_aw_1-kg_a_aw_2)+abs(kg_a_bs_1-kg_a_bs_2)
+abs(kg_a_bw_1-kg_a_bw_2)+abs(kg_a_cf_1-kg_a_cf_2)+abs(kg_a_cs_1-kg_a_cs_2)+abs(kg_a_cw_1-kg_a_cw_2)
+abs(kg_a_dw_1-kg_a_dw_2)+abs(kg_a_df_1-kg_a_df_2)+abs(kg_a_h_1-kg_a_h_2)+abs(kg_a_e_1-kg_a_e_2)))/12;
gen climate_pop=(100*(abs(kg_p_af_1-kg_p_af_2)+abs(kg_p_am_1-kg_p_am_2)+abs(kg_p_aw_1-kg_p_aw_2)+abs(kg_p_bs_1-kg_p_bs_2)
+abs(kg_p_bw_1-kg_p_bw_2)+abs(kg_p_cf_1-kg_p_cf_2)+abs(kg_p_cs_1-kg_p_cs_2)+abs(kg_p_cw_1-kg_p_cw_2)
+abs(kg_p_dw_1-kg_p_dw_2)+abs(kg_p_df_1-kg_p_df_2)+abs(kg_p_e_1-kg_p_e_2)+abs(kg_p_h_1-kg_p_h_2)))/12;
label variable climate_area "Measure of climatic difference of land areas, by 12 KG zones";
label variable climate_pop "Measure of climatic difference of populations, by 12 KG zones";
gen relig_diff=(abs(buddis00_1-buddis00_2)+abs(cath00_1-cath00_2)+abs(easrel00_1-easrel00_2)+abs(hindu00_1-hindu00_2)
+abs(jews00_1-jews00_2)+abs(muslim00_1-muslim00_2)+abs(nonrel00_1-nonrel00_2)+abs(orth00_1-orth00_2)
+abs(othchrist00_1-othchrist00_2)+abs(othrel00_1-othrel00_2)+abs(prot00_1-prot00_2))/11;
label variable relig_diff "Religious Difference, based on Barrett Data";
#delimit cr
gen dtropics=abs(kgatr_2-kgatr_1)
label variable dtropics "Difference in % land area in KG tropical climates (Am+Af+Aw)"

* Define microgeography variables
gen common_water=common_sea+common_ocean+common_bay+common_channel+common_gulf
replace common_water=1 if common_water>1
label variable common_water "=1 if pair shares at least one sea or ocean"
gen diff_elev=abs((elevation_1/1000)-(elevation_2)/1000)
label variable diff_elev "Absolute value of difference in average elevation"
gen landlock_1=(coastline_km_1==0)
gen landlock_2=(coastline_km_2==0)
gen landlock_dummy=(landlock_1==1 | landlock_2==1)
label variable landlock_dummy "=1 if either country is landlocked"
gen island_1=(land_boundaries_km_1==0)
gen island_2=(land_boundaries_km_2==0)
gen island_dummy=(island_1==1 | island_2==1)
label variable island_dummy "=1 if either country is an island"
replace freight_cost_surface= freight_cost_surface/1000

gen europe_1=weurope_1+eeurope_1
gen europe_2=weurope_2+eeurope_2
gen asia_1=(asiae_1+seasia_1+soasia_1+scasia_1+mideast_1)
replace asia_1=1 if asia_1==2
gen asia_2=(asiae_2+seasia_2+soasia_2+scasia_2+mideast_2)
replace asia_2=1 if asia_2==2
gen africa_1=nafrica_1+ssafrica_1
gen africa_2=nafrica_2+ssafrica_2
gen both_in_asia=(asia_1==1 & asia_2==1)
label variable both_in_asia "Both in Asia Dummy"
gen both_in_africa=(africa_1==1 & africa_2==1)
label variable both_in_africa "Both in Africa Dummy"
gen both_in_europe=(europe_1==1 & europe_2==1)
label variable both_in_europe "Both in Europe Dummy"
gen both_in_namerica=(namerica_1==1 & namerica_2==1)
label variable both_in_namerica "Both in North America Dummy"
gen both_in_samerica=(laamcarib_1==1 & laamcarib_2==1)
label variable both_in_samerica "Both in Latin America/Caribbean dummy"
gen both_in_oceania=(oceania_1==1 & oceania_2==1)
label variable both_in_oceania "Both in Oceania Dummy"
gen same_continent=(both_in_asia==1 | both_in_africa==1 | both_in_europe==1 | both_in_namerica==1 | both_in_samerica==1 | both_in_oceania==1)
label variable same_continent "Same Continent dummy"

gen one_in_asia=(asia_1==1 | asia_2==1)
replace one_in_asia=one_in_asia-both_in_asia
label variable one_in_asia "Dummy if one and only one country is in Asia"
gen one_in_africa=(africa_1==1 | africa_2==1)
replace one_in_africa=one_in_africa-both_in_africa
label variable one_in_africa "Dummy if one and only one country is in Africa"
gen one_in_europe=(europe_1==1 | europe_2==1)
replace one_in_europe=one_in_europe-both_in_europe
label variable one_in_europe "Dummy if one and only one country is in Europe"
gen one_in_namerica=(namerica_1==1 | namerica_2==1)
replace one_in_namerica=one_in_namerica-both_in_namerica
label variable one_in_namerica "Dummy if one and only one country is in North America"
gen one_in_samerica=(laamcarib_1==1 | laamcarib_2==1)
replace one_in_samerica=one_in_samerica-both_in_samerica
label variable one_in_samerica "Dummy if one and only one country is in South America"
gen one_in_oceania=(oceania_1==1 | oceania_2==1)
replace one_in_oceania=one_in_oceania-both_in_oceania
label variable one_in_oceania "Dummy if one and only one country is in Oceania"
gen different_continent=(one_in_asia==1 | one_in_africa==1 | one_in_europe==1 | one_in_namerica==1 | one_in_samerica==1 | one_in_oceania==1)
label variable different_continent "Different Continent dummy"

* Define relative geographic distance to USA
gen reldist_USA=(abs(dist_1_to_USA-dist_2_to_USA))/1000
label variable reldist_USA "Geodesic Distance, relative to USA"
gen reldifflat_USA=(abs(difflat_1_to_USA-difflat_2_to_USA))/100
label variable reldifflat_USA "Latitude difference, relative to USA"
gen reldifflong_USA=(abs(difflong_1_to_USA-difflong_2_to_USA))/100
label variable reldifflong_USA "Longitude difference, relative to USA"
gen relfreight_USA=(abs(freight_cost_surface_1_to_USA-freight_cost_surface_2_to_USA))/1000
label variable relfreight_USA "Freight cost (surface transport), relative to the USA"

* Define cultural measures
gen lingdist_dom_formula=((15-lingprox_dominant)/15)^.5
label variable lingdist_dom_formula "Linguistic Distance Index, dominant languages"
gen lingdist_weighted_formula=((15-lingprox_weighted)/15)^.5
label variable lingdist_weighted_formula "Linguistic Distance Index, weighted"
gen reldist_dominant_formula=((5-relprox_dominant_fearon)/5)^.5
label variable reldist_dominant_formula "Religious Distance Index, dominant religions, Fearon"
gen reldist_weighted_formula=((5-relprox_weighted_fearon)/5)^.5
label variable reldist_weighted_formula "Religious Distance Index, weighted, Fearon"

* Now compute measures of relative cultural distance to the USA
gen lingdist_dom_formula_to_USA_1=((15-lingprox_dom_to_USA_1)/15)^.5
gen lingdist_w_formula_to_USA_1=((15-lingprox_weighted_to_USA_1)/15)^.5
gen reldist_dom_formula_to_USA_1=((5-relprox_dom_fearon_to_USA_1)/5)^.5
gen reldist_w_formula_to_USA_1=((5-relprox_weighted_fearon_to_USA_1)/5)^.5
gen lingdist_dom_formula_to_USA_2=((15-lingprox_dom_to_USA_2)/15)^.5
gen lingdist_w_formula_to_USA_2=((15-lingprox_weighted_to_USA_2)/15)^.5
gen reldist_dom_formula_to_USA_2=((5-relprox_dom_fearon_to_USA_2)/5)^.5
gen reldist_w_formula_to_USA_2=((5-relprox_weighted_fearon_to_USA_2)/5)^.5

gen rel_lingdist_dom_formula_to_USA=abs(lingdist_dom_formula_to_USA_1-lingdist_dom_formula_to_USA_2)
label variable rel_lingdist_dom_formula_to_USA "Linguistic distance index, relative to USA, plurality"
gen rel_lingdist_w_formula_to_USA=abs(lingdist_w_formula_to_USA_1-lingdist_w_formula_to_USA_2)
label variable rel_lingdist_w_formula_to_USA "Linguistic distance index, relative to USA, weighted"
gen rel_reldist_dom_formula_to_USA=abs(reldist_dom_formula_to_USA_1-reldist_dom_formula_to_USA_2)
label variable rel_reldist_dom_formula_to_USA "Religious distance index, relative to USA, plurality"
gen rel_reldist_w_formula_to_USA=abs(reldist_w_formula_to_USA_1-reldist_w_formula_to_USA_2)
label variable rel_reldist_w_formula_to_USA "Religious distance index, relative to USA, weighted"
gen rel_cognate_dom_to_USA=abs(cognate_dom_to_USA_1-cognate_dom_to_USA_2)
label variable rel_cognate_dom_to_USA "1-% cognate, relative to USA, plurality"
gen rel_cognate_weighted_to_USA=abs(cognate_weighted_to_USA_1-cognate_weighted_to_USA_2)
label variable rel_cognate_weighted_to_USA "1-% cognate, relative to USA, weighted"

* Define Maddison Historical Income Data
gen dlinc1500=abs(log(y1500_1)-log(y1500_2))
gen dlinc1700=abs(log(y1700_1)-log(y1700_2))
gen dlinc1820=abs(log(y1820_1)-log(y1820_2))
gen dlinc1870=abs(log(y1870_1)-log(y1870_2))
gen dlinc1913=abs(log(y1913_1)-log(y1913_2))

label variable new_gendist_weighted "Simple FST genetic distance, weighted, Pemberton et al."

* Define institutional difference variables

gen dfh=abs(polrightsFH_rs_1-polrightsFH_rs_2)
label variable dfh "Absolute difference political rights score, Freedom House"
gen dpolity=abs(polity2_1-polity2_2)
label variable dpolity "Absolute difference in Polity2 score, 1995, Polity"
gen dpolity1960=abs(polity2_1960_1-polity2_1960_2)
gen dpolity1970=abs(polity2_1970_1-polity2_1970_2)
gen dpolity1980=abs(polity2_1980_1-polity2_1980_2)
gen dpolity1990=abs(polity2_1990_1-polity2_1990_2)
gen dpolity2000=abs(polity2_2000_1-polity2_2000_2)
gen dpolity2005=abs(polity2_2005_1-polity2_2005_2)
gen dpolity1800=abs(polity2_1800_1-polity2_1800_2)
gen dpolity1830=abs(polity2_1830_1-polity2_1830_2)
gen dpolity1860=abs(polity2_1860_1-polity2_1860_2)
gen dpolity1890=abs(polity2_1890_1-polity2_1890_2)
gen dpolity1920=abs(polity2_1920_1-polity2_1920_2)
gen dpolity1950=abs(polity2_1950_1-polity2_1950_2)

gen dexconst=abs(exconst1995_1-exconst1995_2)
label variable dexconst "Absolute difference in executive constraints 1995, Polity"
gen drepud=abs(repud90n_1-repud90n_2)
label variable drepud "Absolute difference in repudiation of contracts 1990, ICRG"
gen dcorrup=abs(corrup90n_1-corrup90n_2)
label variable dcorrup "Absolute difference in corruption index 1990, ICRG"
gen dburqua=abs(burqua90n_1-burqua90n_2)
label variable dburqua "Absolute difference in bureaucratic quality 1990, ICRG"
gen dexprop=abs(exprop90_1-exprop90_2)
label variable dexprop "Absolute difference in risk of expropriation 1990, ICRG"
gen drullaw=abs(rullaw90_1-rullaw90_2)
label variable drullaw "Absolute difference in rule of law 1990, ICRG"

* Select observations to ensure same sample in all regressions
* Note: delete the following line to maximize the sample size per regression

log using regressions/table1.doc, text replace
preserve
drop if new_gendist_weighted==.
drop if fst_distance_weighted==.
sum new_gendist_plurality fst_distance_dominant new_gendist_weighted fst_distance_weighted new_gendist_1500 gendist_fst_1500
corr new_gendist_plurality fst_distance_dominant new_gendist_weighted fst_distance_weighted new_gendist_1500 gendist_fst_1500
restore
log close 

#delimit ;

* TABLE 4;
* Use new distance measure to run regressions in table 3.2 in Handbook chapter;

* Column 1 - Relative GD (raw);
quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table5.doc, bdec(3) tdec(2) title("Table 5: Income difference regressions (dependent variable: difference in log per capita income, 2005)") 
varlabels  starlevels(10 5 1) landscape note("(t-statistics in parentheses)") nodisplay ctitle("" "Relative GD") 
addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for Relative GD: " effect;

* Column 2 - Absolute GD (raw);
quietly regress dlinc2005 new_gendist_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum new_gendist_weighted if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_gendist_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table5.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Simple GD") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Simple GD: " effect;

* Column 3 - Horserace (raw);

quietly regress dlinc2005 new_relgendist_weighted_usa new_gendist_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa new_gendist_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table5.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Horserace between simple and relative GD") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Horserace between simple and relative GD: " effect;

*  Column 4 - Use 1500 GDs as instruments for current GDs - requires doing 2SLS for correct SEs (raw);
* First stage;
quietly cgmreg new_relgendist_weighted_usa new_relgendist_1500_uk difflat difflong dist contig island_dummy landlock_dummy common_water if (dlinc2005<100000), cluster(wacziarg_1 wacziarg_2);
predict fitted_gd, xb;
replace fitted_gd=. if new_relgendist_weighted_usa>10000;
replace fitted_gd=. if dlinc2005>10000;
quietly cgmreg dlinc2005 fitted_gd difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdrgd=r(sd); scalar effect=100*eff*sdrgd/sdinc2005; local E: di %6.3f effect;
di "Standardized Beta (%) for 2SLS with 1500 GD: " effect;
outreg using regressions/table5.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "2SLS with 1500 GD") 
addrows("Standardized Beta (%)", "`E'") merge;

drop fitted_gd;

* TABLE 6;

* Column 1 - Add Continent Dummies (both same and different continent versions);
quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water 
both_in_asia both_in_africa both_in_europe both_in_namerica both_in_samerica both_in_oceania one_in_asia one_in_africa one_in_europe one_in_namerica one_in_samerica, beta;
sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd); sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); 
matrix coeffs=e(b); scalar fsteff=coeffs[1,1]; scalar effect=100*fsteff*sdwrgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water 
both_in_asia both_in_africa both_in_europe both_in_namerica both_in_samerica both_in_oceania one_in_asia one_in_africa one_in_europe one_in_namerica one_in_samerica, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/table6.doc, bdec(3) tdec(2) title("Table 6 - Income difference regressions, robustness tests") varlabels nodisplay starlevels(10 5 1) landscape 
note("(t-statistics in parentheses)") ctitle("" "Continent dummies") addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for continent dummies: " effect;

* Column 2 - The New World;
preserve;
drop if (oceania_1==1 | oceania_2==1 | namerica_1==1 | laamcarib_1==1 | namerica_2==1 | laamcarib_2==1);
quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/table6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Excl. New World") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Excl. New World: " effect;

restore;

* Column 3 - Exclude Sub-Saharan Africa;
preserve;
drop if (ssafrica_1==1 | ssafrica_2==1);
quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); matrix coeffs=e(b); 
scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/table6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Excl. Sub-Saharan Africa") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Excl. SS Africa: " effect;

restore;

* Column 4 - Climate Difference Control;
quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water climate_area;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water climate_area, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/table6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Climatic Difference") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Climate: " effect;

* Column 5 - Common history and Religious / Linguistic Proximity Controls;

quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water smctry colony comcol curcol rel_reldist_w_formula_to_USA rel_lingdist_w_formula_to_USA;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water smctry colony comcol curcol rel_reldist_w_formula_to_USA rel_lingdist_w_formula_to_USA, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/table6.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Common history controls") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Common History: " effect;
di "The standardized beta on GD in the same sample without the historical controls is 34.80%";
* run regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if rel_lingdist_w_formula_to_USA~=., beta to see this;

* TABLE 7 - Historical regressions;

* Full sample;

quietly regress dlinc1820 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") 
title("Table 7 - Regressions using Historical Data") ctitle("" "Income 1820") addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1870") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1913") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/table7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1960") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
outreg using regressions/table7.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 2005") 
addrows("Standardized Beta (%)", "`E'") merge;

* Common Sample - this is only to get the common sample beta coefficients;

preserve;
drop if dlinc1960>100000;

quietly regress dlinc1820 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_uk if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
restore;

* Replication of Diffusion of Institutions regressions with Pemberton data;
* TABLE 8 - Various measures of institutional quality 1990s;

quietly regress dpolity1990 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dpolity1990 if e(sample); scalar sdpol=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd);
cgmreg dpolity1990 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\Table8.doc, label tstat bdec(3) tdec(2) ctitle("Polity score 1990") addstat("Standardized Beta (%)", effect) 
title("Table 8 - Determinants of Institutional Differences") replace;

quietly regress drepud new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum drepud if e(sample); scalar sdpol=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd);
cgmreg drepud new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\Table8.doc, label tstat bdec(3) tdec(2) ctitle("Repudiation of contracts 1990") addstat("Standardized Beta (%)", effect) append;

quietly regress dexprop new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dexprop if e(sample); scalar sdpol=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd);
cgmreg dexprop new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\Table8.doc, label tstat bdec(3) tdec(2) ctitle("Risk of expropriation 1990") addstat("Standardized Beta (%)", effect) append;

quietly regress drullaw new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water;
sum drullaw if e(sample); scalar sdpol=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd);
cgmreg drullaw new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\Table8.doc, label tstat bdec(3) tdec(2) ctitle("Rule of law 1990") addstat("Standardized Beta (%)", effect) append;

* TABLE 9 - Democracy 1960-2005;
* Set common sample;
quietly regress dpolity1960 dpolity1970 dpolity1980 dpolity1990 dpolity2000 dpolity2005;
sum new_relgendist_weighted_usa if e(sample); scalar sdwrgd=r(sd);
sum dpolity1960 if e(sample); scalar sdpol1960=r(sd); 
sum dpolity1970 if e(sample); scalar sdpol1970=r(sd); 
sum dpolity1980 if e(sample); scalar sdpol1980=r(sd); 
sum dpolity1990 if e(sample); scalar sdpol1990=r(sd); 
sum dpolity2000 if e(sample); scalar sdpol2000=r(sd); 
sum dpolity2005 if e(sample); scalar sdpol2005=r(sd); 

cgmreg dpolity1960 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1960;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("1960") addstat("Standardized Beta (%)", effect) 
title("Table 9 - Determinants of Differences in Democracy") replace;

cgmreg dpolity1970 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1970;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("1970") addstat("Standardized Beta (%)", effect) append;

cgmreg dpolity1980 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1980;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("1980") addstat("Standardized Beta (%)", effect) append;

cgmreg dpolity1990 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1990;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("1990") addstat("Standardized Beta (%)", effect) append;

cgmreg dpolity2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol2000;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("2000") addstat("Standardized Beta (%)", effect) append;

cgmreg dpolity2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol2005;
outreg2 using regressions\Table9.doc, label tstat bdec(3) tdec(2) ctitle("2005") addstat("Standardized Beta (%)", effect) append;

* TABLE 10 - Replication of technology regressions from Handbook paper - include 2000 regressions in main paper and 1500 regressions in appendix;

regress agr_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1);
predict fit if e(sample); gen err=agr_tech_diff_2000-fit; egen mean=mean(agr_tech_diff_2000) if e(sample); gen devsq=(agr_tech_diff_2000-mean)^2;
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum agr_tech_diff_2000 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd;
cgmreg agr_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg2 using regressions\Table10.doc, label tstat bdec(3) tdec(2) ctitle("Agricultural Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ)
title("Table 10 - CEG Measures for 2000") replace;

regress comm_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=comm_tech_diff_2000-fit; egen mean=mean(comm_tech_diff_2000) if e(sample); gen devsq=(comm_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum comm_tech_diff_2000 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg comm_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\Table10.doc, label tstat bdec(3) tdec(2) ctitle("Communications Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress trans_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=trans_tech_diff_2000-fit; egen mean=mean(trans_tech_diff_2000) if e(sample); gen devsq=(trans_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum trans_tech_diff_2000 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg trans_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\Table10.doc, label tstat bdec(3) tdec(2) ctitle("Transportation Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress ind_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=ind_tech_diff_2000-fit; egen mean=mean(ind_tech_diff_2000) if e(sample); gen devsq=(ind_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum ind_tech_diff_2000 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg ind_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\Table10.doc, label tstat bdec(3) tdec(2) ctitle("Industrial Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress avg_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=avg_tech_diff_2000-fit; egen mean=mean(avg_tech_diff_2000) if e(sample); gen devsq=(avg_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum avg_tech_diff_2000 if e(sample); scalar sd=r(sd); sum new_relgendist_weighted_usa if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg avg_tech_diff_2000 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\Table10.doc, label tstat bdec(3) tdec(2) ctitle("Overall Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;


**************************************************************************
* Tables for Appendix - use Cavalli-Sforza data for the same regressions;
* Use same numbering as tables in the text, but add "A" in front - for comparability;

* TABLE A5;

* Column 1 - Relative GD (raw);
quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA5.doc, bdec(3) tdec(2) title("Table A5: Income difference regressions (dependent variable: difference in log per capita income, 2005)") 
varlabels  starlevels(10 5 1) landscape note("(t-statistics in parentheses)") nodisplay ctitle("" "Relative GD") 
addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for Relative GD: " effect;

* Column 2 - Absolute GD (raw);
quietly regress dlinc2005 fst_distance_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum fst_distance_weighted if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 fst_distance_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA5.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Simple GD") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Simple GD: " effect;

* Column 3 - Horserace (raw);

quietly regress dlinc2005 relgendist_fst_weighted_USA fst_distance_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
sum dlinc2005 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA fst_distance_weighted difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA5.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Horserace between simple and relative GD") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Horserace between simple and relative GD: " effect;

*  Column 4 - Use 1500 GDs as instruments for current GDs - requires doing 2SLS for correct SEs (raw);
* First stage;
quietly cgmreg relgendist_fst_weighted_USA relgendist_fst_1500_UK difflat difflong dist contig island_dummy landlock_dummy common_water if (dlinc2005<100000), cluster(wacziarg_1 wacziarg_2);
predict fitted_gd, xb;
replace fitted_gd=. if new_relgendist_weighted_usa>10000;
replace fitted_gd=. if dlinc2005>10000;
quietly cgmreg dlinc2005 fitted_gd difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_USA if e(sample);
scalar sdrgd=r(sd); scalar effect=100*eff*sdrgd/sdinc2005; local E: di %6.3f effect;
di "Standardized Beta (%) for 2SLS with 1500 GD: " effect;
outreg using regressions/tableA5.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "2SLS with 1500 GD") 
addrows("Standardized Beta (%)", "`E'") merge;

* TABLE A6;

* Column 1 - Add Continent Dummies (both same and different continent versions);
quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water 
both_in_asia both_in_africa both_in_europe both_in_namerica both_in_samerica both_in_oceania one_in_asia one_in_africa one_in_europe one_in_namerica one_in_samerica, beta;
sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd); sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); 
matrix coeffs=e(b); scalar fsteff=coeffs[1,1]; scalar effect=100*fsteff*sdwrgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water 
both_in_asia both_in_africa both_in_europe both_in_namerica both_in_samerica both_in_oceania one_in_asia one_in_africa one_in_europe one_in_namerica one_in_samerica, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/tableA6.doc, bdec(3) tdec(2) title("Table A6 - Income difference regressions, robustness tests") varlabels nodisplay starlevels(10 5 1) landscape 
note("(t-statistics in parentheses)") ctitle("" "Continent dummies") addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for continent dummies: " effect;

* Column 2 - The New World;
preserve;
drop if (oceania_1==1 | oceania_2==1 | namerica_1==1 | laamcarib_1==1 | namerica_2==1 | laamcarib_2==1);
quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/tableA6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Excl. New World") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Excl. New World: " effect;

restore;

* Column 3 - Exclude Sub-Saharan Africa;
preserve;
drop if (ssafrica_1==1 | ssafrica_2==1);
quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); matrix coeffs=e(b); 
scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/tableA6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Excl. Sub-Saharan Africa") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Excl. SS Africa: " effect;

restore;

* Column 4 - Climate Difference Control;
quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water climate_area;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water climate_area, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/tableA6.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Climatic Difference") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Climate: " effect;

* Column 5 - Common history and Religious / Linguistic Proximity Controls;

quietly regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water smctry colony comcol curcol rel_reldist_w_formula_to_USA rel_lingdist_w_formula_to_USA;
sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water smctry colony comcol curcol rel_reldist_w_formula_to_USA rel_lingdist_w_formula_to_USA, cluster(wacziarg_1 wacziarg_2);

outreg using regressions/tableA6.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Common history controls") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Common History: " effect;
di "The standardized beta on GD in the same sample without the historical controls is 28.43%";
* run regress dlinc2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if rel_lingdist_w_formula_to_USA~=., beta to see this;

* TABLE A7 - Historical regressions;

* Full sample;

quietly regress dlinc1820 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") 
title("Table A6 - Regressions using Historical Data") ctitle("" "Income 1820") addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1870") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1913") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA7.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1960") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
outreg using regressions/tableA7.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 2005") 
addrows("Standardized Beta (%)", "`E'") merge;

* Common Sample - this is only to get the common sample beta coefficients;

preserve;
drop if dlinc1960>100000;

quietly regress dlinc1820 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum relgendist_fst_weighted_UK if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 relgendist_fst_weighted_UK difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
restore;

* TABLE A8 - Various measures of institutional quality 1990s;

quietly regress dpolity1990 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dpolity1990 if e(sample); scalar sdpol=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd);
cgmreg dpolity1990 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\TableA8.doc, label tstat bdec(3) tdec(2) ctitle("Polity score 1990") addstat("Standardized Beta (%)", effect) 
title("Table A8 - Determinants of Institutional Differences") replace;

quietly regress drepud relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum drepud if e(sample); scalar sdpol=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd);
cgmreg drepud relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\TableA8.doc, label tstat bdec(3) tdec(2) ctitle("Repudiation of contracts 1990") addstat("Standardized Beta (%)", effect) append;

quietly regress dexprop relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum dexprop if e(sample); scalar sdpol=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd);
cgmreg dexprop relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\TableA8.doc, label tstat bdec(3) tdec(2) ctitle("Risk of expropriation 1990") addstat("Standardized Beta (%)", effect) append;

quietly regress drullaw relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water;
sum drullaw if e(sample); scalar sdpol=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd);
cgmreg drullaw relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol;
outreg2 using regressions\TableA8.doc, label tstat bdec(3) tdec(2) ctitle("Rule of law 1990") addstat("Standardized Beta (%)", effect) append;

* TABLE A9 - Democracy 1960-2005;

* Set common sample;
quietly regress dpolity1960 dpolity1970 dpolity1980 dpolity1990 dpolity2000 dpolity2005;
sum relgendist_fst_weighted_USA if e(sample); scalar sdwrgd=r(sd);
sum dpolity1960 if e(sample); scalar sdpol1960=r(sd); 
sum dpolity1970 if e(sample); scalar sdpol1970=r(sd); 
sum dpolity1980 if e(sample); scalar sdpol1980=r(sd); 
sum dpolity1990 if e(sample); scalar sdpol1990=r(sd); 
sum dpolity2000 if e(sample); scalar sdpol2000=r(sd); 
sum dpolity2005 if e(sample); scalar sdpol2005=r(sd); 

cgmreg dpolity1960 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1960;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("1960") addstat("Standardized Beta (%)", effect) 
title("Table A9 - Determinants of Differences in Democracy") replace;
di "Standardized Beta (%)" effect;

cgmreg dpolity1970 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1970;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("1970") addstat("Standardized Beta (%)", effect) append;
di "Standardized Beta (%)" effect;

cgmreg dpolity1980 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1980;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("1980") addstat("Standardized Beta (%)", effect) append;
di "Standardized Beta (%)" effect;

cgmreg dpolity1990 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol1990;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("1990") addstat("Standardized Beta (%)", effect) append;
di "Standardized Beta (%)" effect;

cgmreg dpolity2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol2000;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("2000") addstat("Standardized Beta (%)", effect) append;
di "Standardized Beta (%)" effect;

cgmreg dpolity2005 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water if e(sample), cluster(wacziarg_1 wacziarg_2);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdwrgd/sdpol2005;
outreg2 using regressions\TableA9.doc, label tstat bdec(3) tdec(2) ctitle("2005") addstat("Standardized Beta (%)", effect) append;
di "Standardized Beta (%)" effect;

* TABLE A10 - Same as Table 10 but with Cavalli-Sforza data;

regress agr_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1);
predict fit if e(sample); gen err=agr_tech_diff_2000-fit; egen mean=mean(agr_tech_diff_2000) if e(sample); gen devsq=(agr_tech_diff_2000-mean)^2;
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum agr_tech_diff_2000 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd);
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd;
cgmreg agr_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg2 using regressions\TableA10.doc, label tstat bdec(3) tdec(2) ctitle("Agricultural Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) 
title("Table A10 - CEG Measures for 2000, Cavalli-Sforza data") replace;

regress comm_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=comm_tech_diff_2000-fit; egen mean=mean(comm_tech_diff_2000) if e(sample); gen devsq=(comm_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum comm_tech_diff_2000 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg comm_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\TableA10.doc, label tstat bdec(3) tdec(2) ctitle("Communications Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress trans_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=trans_tech_diff_2000-fit; egen mean=mean(trans_tech_diff_2000) if e(sample); gen devsq=(trans_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum trans_tech_diff_2000 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg trans_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\TableA10.doc, label tstat bdec(3) tdec(2) ctitle("Transportation Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress ind_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=ind_tech_diff_2000-fit; egen mean=mean(ind_tech_diff_2000) if e(sample); gen devsq=(ind_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum ind_tech_diff_2000 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg ind_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\TableA10.doc, label tstat bdec(3) tdec(2) ctitle("Industrial Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

regress avg_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1); 
predict fit if e(sample); gen err=avg_tech_diff_2000-fit; egen mean=mean(avg_tech_diff_2000) if e(sample); gen devsq=(avg_tech_diff_2000-mean)^2; 
gen SST=sum(devsq); scalar SSqT=SST[_N]; gen errsq=err^2; gen SSE=sum(errsq); scalar SSqE=SSE[_N]; scalar RSQ=1-SSqE/SSqT; drop err fit mean devsq SST SSE errsq;
sum avg_tech_diff_2000 if e(sample); scalar sd=r(sd); sum relgendist_fst_weighted_USA if e(sample); scalar sdgd=r(sd); 
matrix coeffs=e(b); scalar eff=coeffs[1,1]; scalar effect=100*eff*sdgd/sd; 
cgmreg avg_tech_diff_2000 relgendist_fst_weighted_USA difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2); 
outreg2 using regressions\TableA10.doc, label tstat bdec(3) tdec(2) ctitle("Overall Technology") addstat("Standardized Beta (%)", effect, "R-Squared", RSQ) append;

* TABLE A1 - Historical income regressions with the US instead of the UK as frontier;

* Full sample;

quietly regress dlinc1820 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA1.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") 
title("Table A1 - Regressions using Historical Data") ctitle("" "Income 1820") addrows("Standardized Beta (%)", "`E'") replace;
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA1.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1870") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA1.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1913") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
outreg using regressions/tableA1.doc, bdec(3) tdec(2) varlabels nodisplay starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 1960") 
addrows("Standardized Beta (%)", "`E'") merge;
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
outreg using regressions/tableA1.doc, bdec(3) tdec(2) varlabels starlevels(10 5 1) landscape note("(t-statistics in parentheses)") ctitle("" "Income 2005") 
addrows("Standardized Beta (%)", "`E'") merge;

* Common Sample - this is only to get the common sample beta coefficients;

preserve;
drop if dlinc1960>100000;

quietly regress dlinc1820 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1820 if e(sample); scalar sdinc1820=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1820; local E: di %6.3f effect;
quietly cgmreg dlinc1820 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1820: " effect;

quietly regress dlinc1870 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1870 if e(sample); scalar sdinc1870=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1870; local E: di %6.3f effect;
quietly cgmreg dlinc1870 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1870: " effect;

quietly regress dlinc1913 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1913 if e(sample); scalar sdinc1913=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1913; local E: di %6.3f effect;
quietly cgmreg dlinc1913 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1913: " effect;

quietly regress dlinc1960 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc1960 if e(sample); scalar sdinc1960=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc1960; local E: di %6.3f effect;
quietly cgmreg dlinc1960 new_relgendist_weighted_uk difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 1960: " effect;

quietly regress dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, beta;
matrix coeffs=e(b); scalar coeff=coeffs[1,1]; sum dlinc2005 if e(sample); scalar sdinc2005=r(sd); sum new_relgendist_weighted_usa if e(sample);
scalar sdgd=r(sd); scalar effect=100*coeff*sdgd/sdinc2005; local E: di %6.3f effect;
quietly cgmreg dlinc2005 new_relgendist_weighted_usa difflat difflong dist contig island_dummy landlock_dummy common_water if dlinc1820<1000000, cluster(wacziarg_1 wacziarg_2);
di "Standardized Beta (%) for Income 2005: " effect;
restore;
