libname work2  "O:\desktop_pc_office\projects\jmpaperrevisiondata";
run;
%macro tstats2;

data psidist;
        length paper $20 psihat 8 phihat 8 nr 8 na2 8;
  		label paper='paper';
		stop;
	run;
%do i = 1 %to 100;
        /*%Let sample = %eval(300);*/

        proc surveyselect data=work2.full2 method = SRS rep=1 sampsize=100 out=bootstrap2 noprint;
        id _all_;
        run;

proc model data=bootstrap2;
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+a2*(na2**2)+a3*(na2**3)+b*dailyprice);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+t2*(nr**2)+g*m_peri);

retail2=log(Retail_sales)**2;
retailpera=Retail_sales/Land_area;
retail3=log(retail_sales)**3;



fit reader advertiser / gmm outest=regres1 out=est1 /*outresid*/;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita Homeownership_rate  Housing_units wage_in_printing  retail2 retailpera retail3)  
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone per_square_mile  Homeownership_rate  High_school_or_higher);

outvars paper;

run;


data coef;
set regres1;
dd=1;
run;

data demand6;
set est1;
drop _TYPE_;
dd=1; 
run;

data simulation; 
merge coef demand6; 
by dd;
run;

data simulation2;
set simulation;
phihat=a0+(a1*na2)+a2*(na2**2)+a3*(na2**3);
psihat=t0+(t1*nr)+t2*(nr**2);
keep phihat psihat paper nr na2; 
run;

proc append base=psidist data=simulation2;
        run;

/*DM 'CLEAR lOG';*/
%end;
%mend tstats2;

%tstats2;




proc sort data=psidist;
by paper;
run;

proc means data=psidist noprint;
var phihat psihat;
output out=psidistconfl 
P5=phi5 psi5;
by paper; 
run;

proc means data=psidist noprint;
var phihat psihat;
output out=psidistconfu 
P95=phi95 psi95;
by paper; 
run;

data psiconf;
merge psidistconfu psidistconfl;
by paper;
run;


proc model data=work2.full2; /*Third order polynomial for reader demand*/
parms a0 a1 a2 a3 b t0 t1 t2 g;
eq.reader=log((1-nr)/nr)-(a0+a1*na2+a2*(na2**2)+a3*(na2**3)+b*dailyprice);
eq.advertiser=log((1-na2)/na2)-(t0+t1*nr+t2*(nr**2)+g*m_peri);

retail2=log(Retail_sales)**2;
retailpera=Retail_sales/Land_area;
retail3=log(retail_sales)**3;



fit reader advertiser / gmm outest=regres1 out=est1 /*outresid*/;

instruments (reader, c Retail_sales Land_area per_square_mile wpaper  Female  White_alone Retail_sales_per_capita Homeownership_rate  Housing_units wage_in_printing  retail2 retailpera retail3)  
(advertiser, c wage_in_printing below_poverty Land_area wprinting Female under_18  Retail_sales_per_capita White_alone Asian_alone per_square_mile  Homeownership_rate  High_school_or_higher);

phihat=a0+(a1*na2)+a2*(na2**2)+a3*(na2**3);
psihat=t0+(t1*nr)+t2*(nr**2);
outvars paper psihat phihat;
run;
quit;

proc sort data=est1;
by paper;
run;

data Est2;
set est1;
keep paper psihat phihat nr na2 ;
run;

data psiconfmatlab;
merge psiconf Est2;
by paper;
run;
