/* Lelq.G
** -------------------------------------------------------
** Program for Local quadratic first derivative estimation
** Lyapunov exponent and Half-lives
** with standard error
** (see Fan and Gijbels (1996))
** d = 1
**
** 10/24/01
** -------------------------------------------------------
*/
new;
output file = Lelq.out reset;

#include base.src;
#include kernels.src;
_ker_fun = &qs; /* selection of kernel for long-run variance */
_aband = 0;
_filter = 0;

cls;

load x[97,6] = pppdata1.txt;
x = x[.,6]; /* UK data */

h = 0.2107118413  ;  /* selected bandwidth for regression HERE   */

T = rows(x);

x0 = trimr(x,1,0); /* dependent variable   x(t)   */
x1 = trimr(x,0,1); /* independent variable x(t-1) */

data = x1~x0 ; /* 1st column x(t-1) ; 2nd column x(t)   */
T = rows(data) ;

x0c     = detrend(x0,0);
x1c     = detrend(x1,0);
alpha   = x0c/x1c ;
res     = x0c - (x1c*alpha);
var     = ((res'res)/(T-2))*inv(x1c'x1c) ;
arse    = sqrt(diag(var));

std = sqrt((T-1)/T).*stdc(data[.,1]);
hf=1.06*std/(T^(1/5)) ;

epsln = 1e-15; /* double precision factor */
adj = 0.8403;
format /rd 10,10;
/**********************************************/
/*        Estimation                          */
/**********************************************/
ehat = zeros(T,1);
dumt = zeros(T,1);
m0 = zeros(T,1);
m1 = zeros(T,1);
m2 = zeros(T,1);
f0 = zeros(T,1);
f1 = zeros(T,1);

i = 1 ;
do until i > T ;

u = (data[i,1]*ones(T,1) - data[.,1])/h ;

w = fi(u) ; /* weight for GLS */
sqrtw = sqrt(fi(u)) ; /* weight for GLS */

X_x = data[.,1]-(data[i,1]*ones(T,1)) ;

y = data[.,2];

xx2 = ones(T,1)~X_x~(X_x.^2) ;
xmat = xx2;

xx2w = xx2;
xx2w[.,1] = xx2[.,1].*sqrtw ;
xx2w[.,2] = xx2[.,2].*sqrtw ;
xx2w[.,3] = xx2[.,3].*sqrtw ;
yw = data[.,2].*sqrtw;

/*  Local quadratic estimator */
if det(xx2w'xx2w) > epsln ;
 a= inv(xx2w'xx2w)*xx2w'yw ;
 m0[i,1] = a[1,.] ;
 m1[i,1] = a[2,.] ;
 m2[i,1] = 2*a[3,.] ;
 ehat[i,1] = y[i,1] - m0[i,1]; /* residual */
else;
 "Singular !!!";end;
endif;

uf = (data[i,1]*ones(T,1) - data[.,1])/hf ;
/* (A) Density estimator */
 f0[i,1] = sumc(fi(uf))/(T*hf) ;
/* (B) Density derivative estimator */
 f1[i,1] = sumc(dfi(uf))/(T*hf*hf) ;

i = i + 1;
endo;
format /rd 5,2;
outdat = data~m0~m1~m2~f0~f1;
@outdat;@

/* mean (bias) adjusted residual */
ehat = ehat - meanc(ehat).*ones(T,1);

ldx2 = ln(m1^2) ;
lambda = sumc(ldx2)/(2*T) ;

/* Standard Error estimate */

dd= m2./(m1.^2)-f1./(m1.*f0) ;
eta1 = dd.*ehat ;
eta2 = ln(abs(m1)) - lambda.*ones(T,1) ;

/* (1) Subsample SE  */
eta = eta2;
l2 = autoband(eta) + 1; /* AUTO */
phi = lrvar(eta,l2-1);
se2 = sqrt(phi/T) ;

/* (2) Full sample SE with Trimming  */
eta = eta1 + eta2 ;

abseta = abs(eta);
tmp = abseta~eta~seqa(1,1,T);
tmp = sortc(tmp,1);
maxeta = tmp[floor(0.99*T),1];
eta = eta.*(abseta.<maxeta);

l1 = autoband(eta) + 1; /* AUTO */
phi = lrvar(eta,l1-1);
se1 = sqrt(phi/T) ;

@print eta1~eta2~eta;@

print;
format /rd 5,0;
"Sample Size = ";;T;
format /rd 5,5;
print;
" *** Linear Measure *** ";
print;
"Linear AR parameter = ";;alpha;;"(";;arse;;")";
uar_95 = alpha + 1.96*arse;
lar_95 = alpha - 1.96*arse;
"CI [";;lar_95;;",";;uar_95;;"]";
print;
hlar = ln(1/2)/ln(alpha);
hlaru_95 = ln(1/2)/ln(uar_95);
hlarl_95 = ln(1/2)/ln(lar_95);
"Half-Life = ";;hlar;
"CI [";;hlarl_95;;",";;hlaru_95;;"]";

rateu_95 = ln(alpha) + 1.96*arse/alpha;
ratel_95 = ln(alpha) - 1.96*arse/alpha;
raru_95 = ln(1/2)/rateu_95;
rarl_95 = ln(1/2)/ratel_95;
"rate CI [";;rarl_95;;",";;raru_95;;"]";
daru_95 = hlar - 1.96*arse*ln(1/2)/alpha/(ln(alpha))^2;
darl_95 = hlar + 1.96*arse*ln(1/2)/alpha/(ln(alpha))^2;
"delta CI [";;darl_95;;",";;daru_95;;"]";
print;
print;
" *** Nonlinear Measure *** ";
print;
"Lyapnov exponent = ";;lambda;;"(";;se1;;")";;"(";;se2;;")";
"Automatic bandwidth = ";;l1;;" and ";;l2;
u1_95 = lambda + 1.96*se1;
l1_95 = lambda - 1.96*se1;
"CI1 [";;l1_95;;",";;u1_95;;"]";
u2_95 = lambda + 1.96*se2;
l2_95 = lambda - 1.96*se2;
"CI2 [";;l2_95;;",";;u2_95;;"]";
print;
hl = ln(1/2)/lambda;
hlu1_95 = ln(1/2)/u1_95;
hll1_95 = ln(1/2)/l1_95;
"Half-Life = ";;hl;
"CI1 [";;hll1_95;;",";;hlu1_95;;"]";

du1_95 = hl - 1.96*se1*ln(1/2)/(lambda^2);
dl1_95 = hl + 1.96*se1*ln(1/2)/(lambda^2);
"delta CI1 [";;dl1_95;;",";;du1_95;;"]";

@
hlu2_95 = -ln(2)/u2_95;
hll2_95 = -ln(2)/l2_95;
"CI2 [";;hll2_95;;",";;hlu2_95;;"]";
@


library pgraph ;
graphset ;
fonts("microb") ;
_pagesiz = {6.5, 4.5} ;
_pdate = 0;
_plwidth=5;
_plctrl = {0, 0, 0} ;

ldm = m1 ;
xm = x1~ldm;
@xm = x1~ldm~f0;@
xm = sortc(xm,1);
title("Figure\ Derivatives");
xlabel("Empirical Distribution")
;
xy(xm[.,1],xm[.,2]) ;


ldm = ln(m1^2)/2 ;
xm = x1~ldm;
xm = sortc(xm,1);
title("Figure\ Rate of Convergence");
xlabel("Empirical Distribution")
;
xy(xm[.,1],xm[.,2]) ;
output file = lq_q6.txt reset;
result = xm[.,1]~xm[.,2];
result;
end;

/**********************************************/
/*             Choice of kernel               */
/**********************************************/
/* Gaussian kernel */
fn fi(z) = exp(-(z.^2)/2)./sqrt(2*pi) ;
fn dfi(z) = -z.*exp(-(z.^2)/2)./sqrt(2*pi) ;
/*
** (i) Epanechnikov kernel
** fn fi(z) = (abs(z).<1)*(3/4).*(ones(T,1)-(z.^2)) ;
**
** (ii) Quartic kernel
** fn fi(z) = (abs(z).<1)*(15/16).*((ones(T,1)-(z.^2)).^2) ;
**
** (iii) Gaussian kernel
** fn fi(z) = exp(-(z.^2)/2)./sqrt(2*pi) ;
*/
proc autoband(e) ;
     local eb, ef, ae, ee, se, ad, a1, a2, nobs,v;
     eb = trimr(lagn(e,1),1,0) ;
         ef = trimr(e,1,0);
         ae = sumc(eb.*ef)./sumc(eb.^2);
         ee = ef - eb.*(ae');
         se = meanc(ee.^2);
         ad = sumc((se./((1-ae).^2)).^2);
         a1 = 4*sumc((ae.*se./(((1-ae).^3).*(1+ae))).^2)/ad;
         a2 = 4*sumc((ae.*se./((1-ae).^4)).^2)/ad;
         nobs = rows(e) ;
         if VARGET("_ker_fun") == &qs ;
             v = 1.3221*((a2*nobs)^.2)-1;
         elseif VARGET("_ker_fun") == &parzen;
             v = 2.6614*((a2*nobs)^.2)-1;
         elseif VARGET("_ker_fun") == &fejer ;
             v = 1.1447*((a1*nobs)^.333)-1;
         elseif VARGET("_ker_fun") == &tukhan ;
             v = 1.7462*((a2*nobs)^.2)-1;
         endif ;

retp(v);
endp ;
/*********(END OF PROGRAM)*********************/
