# delimit;

clear;
clear matrix;
clear mata;

set mem 1000m;
set matsize 5000;

cd "c:\Nastja\Research\Self-Employment\NLSY79\";
*cd "c:\Nastja\Research\Self-Employment\NLSY79\";

capture log close;
*log using "logs\white_women", replace;

use data\NLSY79_white_women_JAE.dta;

*****************************************************************************
* BIVARIATE PROBIT MODEL WITH SAMPLE SELECTION
* NOTE: IN THE PROGRAM BELOW THE 1-ST EQUATION IS THE SELECTION EQUATION, 3-RD EQUATION IS THE MAIN EQUATION;

capture program drop myll;

program define myll;

	args lnf x1 x2 x3 c21 c31 c32;
	tempvar sp2 sp3 k1 k2 k3;
   quietly{;
	gen double `k1' = 2*$ML_y1 - 1;
	gen double `k2' = 2*$ML_y2 - 1;
	gen double `k3' = 2*$ML_y3 - 1;
	tempname cf21 cf22 cf31 cf32 cf33 C1 C2;
	sum `c21', meanonly;
	scalar `cf21' = r(mean);
	sum `c31', meanonly;
	scalar `cf31' = r(mean);
	sum `c32', meanonly;
	scalar `cf32' = r(mean);
	scalar `cf22' = sqrt(1 - `cf21'^2);
	scalar `cf33' = sqrt(1 - `cf31'^2 - `cf32'^2);
	mat `C1' = (1, 0, 0 \ `cf21', `cf22', 0 \ `cf31', `cf32', `cf33');
	mat `C2' = (1, 0 \ `cf21', `cf22');
	egen `sp3' = mvnp(`x1' `x2' `x3') if $ML_y1==1, chol(`C1') dr($dr) prefix(z) signs(`k1' `k2' `k3') adoonly;
	egen `sp2' = mvnp(`x1' `x2') if $ML_y1==0, chol(`C2') dr($dr) prefix(z) signs(`k1' `k2') adoonly;
	replace `lnf' = ln(`sp3') if $ML_y1==1;
	replace `lnf' = ln(`sp2') if $ML_y1==0;
   };
end;

***************************************************************************************************************
* PROBIT MODEL WITH SAMPLE SELECTION
* NOTE: IN PROGRAM myheckprob SELECTION EQUATION IS FIRST;

capture program drop myheckprob;
program define myheckprob;

	args lnf x1 x2 c21;
	tempvar sp2 sp3 k1 k2;
   quietly{;
	gen double `k1' = 2*$ML_y1 - 1;
	gen double `k2' = 2*$ML_y2 - 1;
	tempname cf21 cf22 C1;
	sum `c21', meanonly;
	scalar `cf21' = r(mean);
	scalar `cf22' = sqrt(1 - `cf21'^2);
	mat `C1' = (1, 0 \ `cf21', `cf22');
	egen `sp3' = mvnp(`x1' `x2') if $ML_y1==1, chol(`C1') dr($dr) prefix(w) signs(`k1' `k2') adoonly;
	gen `sp2' = 1-normal(`x1') if $ML_y1==0;
	replace `lnf' = ln(`sp3') if $ML_y1==1;
	replace `lnf' = ln(`sp2') if $ML_y1==0;
   };
end;

*******************************************************
* STANDARDIZE rotter_score, sesteem_score1 AND afqt_1
* COMPUTE SAMPLE MEANS FOR sp_inc1000 AND m_sp_inc1000;

tab year, gen(td);

sum rotter_score;
replace rotter_score=(rotter_score-r(mean))/r(sd);

sum sesteem_score1;
replace sesteem_score1=(sesteem_score1-r(mean))/r(sd);

sum age;
scalar mean_age=r(mean);

sum afqt_1;
replace afqt_1=(afqt_1-r(mean))/r(sd);

sum unemp_rate;
scalar mean_unemp_rate=r(mean);

sum sp_inc1000;
scalar mean_sp_inc1000=r(mean);

sum m_sp_inc1000;
scalar mean_m_sp_inc1000=r(mean);

sum self_empl working educ age married d_ch_0 d_ch_1_5_alt d_ch_1_5 d_ch_6_17 rotter_score sesteem_score1 urban afqt_1
 sp_inc1000 samesex policever unemp_rate m_*;

gen nz_sp_inc1000=sp_inc1000 if married==1;

sum self_empl working age edu_0_11 edu_12 edu_13_15 edu_16plus married d_ch_1_5 d_ch_6_17 nz_sp_inc1000 urban
	northeast northcen south west unemp_rate afqt_1 rotter_score sesteem_score1 samesex policever;

sum age edu_0_11 edu_12 edu_13_15 edu_16plus married d_ch_1_5 d_ch_6_17 nz_sp_inc1000 urban
	northeast northcen south west unemp_rate afqt_1 rotter_score sesteem_score1 samesex
	policever if self_empl==0;

sum age edu_0_11 edu_12 edu_13_15 edu_16plus married d_ch_1_5 d_ch_6_17 nz_sp_inc1000 urban
	northeast northcen south west unemp_rate afqt_1 rotter_score sesteem_score1 samesex
	policever if self_empl==1;

sum age edu_0_11 edu_12 edu_13_15 edu_16plus married d_ch_1_5 d_ch_6_17 nz_sp_inc1000 urban
	northeast northcen south west unemp_rate afqt_1 rotter_score sesteem_score1 samesex
	policever if working==0;

********************************************************************************************;
global educ edu_0_11 edu_13_15 edu_16plus; *** edu_12 IS THE REFERENCE GROUP;

global age age agesq;

********************************************************************************************;
* REGRESSIONS FOR WOMEN AGES 22 AND OLDER WHO ARE NOT ENROLLED IN SCHOOL (enrolled=0);

display "`c(current_time)' `c(current_date)'";

probit self_empl td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban
		rotter_score sesteem_score1 policever south unemp_rate m_*, cluster(id);

test age agesq;
test edu_0_11 edu_13_15 edu_16plus;

* ESTIMATING PARTIAL EFFECTS AFTER probit;

margins, expression(normal(xb(self_empl)+(1-edu_0_11)*_b[edu_0_11]-edu_13_15*_b[edu_13_15]-edu_16plus*_b[edu_16plus])
		-normal(xb(self_empl)-edu_0_11*_b[edu_0_11]-edu_13_15*_b[edu_13_15]-edu_16plus*_b[edu_16plus]));
margins, expression(normal(xb(self_empl)+(1-edu_13_15)*_b[edu_13_15]-edu_0_11*_b[edu_0_11]-edu_16plus*_b[edu_16plus])
		-normal(xb(self_empl)-edu_0_11*_b[edu_0_11]-edu_13_15*_b[edu_13_15]-edu_16plus*_b[edu_16plus]));
margins, expression(normal(xb(self_empl)+(1-edu_16plus)*_b[edu_16plus]-edu_0_11*_b[edu_0_11]-edu_13_15*_b[edu_13_15])
		-normal(xb(self_empl)-edu_0_11*_b[edu_0_11]-edu_13_15*_b[edu_13_15]-edu_16plus*_b[edu_16plus]));

margins, expression(normal(xb(self_empl)+(1+mean_age-age)*_b[age]+((1+mean_age)^2 - agesq)*_b[agesq])
		   -normal(xb(self_empl)+(mean_age-age)*_b[age]+(mean_age^2 - agesq)*_b[agesq]));

margins, expression(normal(xb(self_empl)+(1-married)*_b[married])-normal(xb(self_empl)-married*_b[married]));
margins, expression(normal(xb(self_empl)+(1-d_ch_1_5)*_b[d_ch_1_5])-normal(xb(self_empl)-d_ch_1_5*_b[d_ch_1_5]));
margins, expression(normal(xb(self_empl)+(1-d_ch_6_17)*_b[d_ch_6_17])-normal(xb(self_empl)-d_ch_6_17*_b[d_ch_6_17]));

margins, expression(normal(xb(self_empl)+(1+mean_sp_inc1000-sp_inc1000)*_b[sp_inc1000])
		   -normal(xb(self_empl)+(mean_sp_inc1000-sp_inc1000)*_b[sp_inc1000]));

margins, expression(normal(xb(self_empl)+(1-urban)*_b[urban])-normal(xb(self_empl)-urban*_b[urban]));
margins, expression(normal(xb(self_empl)+(1-rotter_score)*_b[rotter_score])
		     -normal(xb(self_empl)-rotter_score*_b[rotter_score]));
margins, expression(normal(xb(self_empl)+(1-sesteem_score1)*_b[sesteem_score1])
		-normal(xb(self_empl)-sesteem_score1*_b[sesteem_score1]));
margins, expression(normal(xb(self_empl)+(1-policever)*_b[policever])-normal(xb(self_empl)-policever*_b[policever]));

margins, expression(normal(xb(self_empl)+_b[south]-south*_b[south])-normal(xb(self_empl)-south*_b[south]));

margins, expression(normal(xb(self_empl)+(1+mean_unemp_rate-unemp_rate)*_b[unemp_rate])
		   -normal(xb(self_empl)+(mean_unemp_rate-unemp_rate)*_b[unemp_rate]));
margins, expression(normal(xb(self_empl)+(1-m_married)*_b[m_married])-normal(xb(self_empl)-m_married*_b[m_married]));
margins, expression(normal(xb(self_empl)+(1+mean_m_sp_inc1000-m_sp_inc1000)*_b[m_sp_inc1000])
		   -normal(xb(self_empl)+(mean_m_sp_inc1000-m_sp_inc1000)*_b[m_sp_inc1000]));

*NOTE: STANDARD ERRORS FOR heckprob ARE INVALID, SO PROGRAM USING ml COMMAND;

heckprob self_empl td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban
	rotter_score sesteem_score1 policever south unemp_rate m_*, select (working = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17
	sp_inc1000 urban rotter_score sesteem_score1 policever south unemp_rate afqt_1 m_*);

	mat b=e(b);
	mat b3 = b[1,1..36];
	mat coleq b3 = self_empl;
	mat b1 = b[1,37..73];
	mat coleq b1 = working;
	mat b0 = b1, b3;

mdraws, neq(2) dr(100) prefix(w) burn(10) replace;
global dr = r(n_draws);

ml model lf myheckprob (working: working = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17
	sp_inc1000 urban rotter_score sesteem_score1 policever south unemp_rate afqt_1 m_*)
	(self_empl: self_empl=td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban
	rotter_score sesteem_score1 policever south unemp_rate m_*) /c21, missing vce(cluster id);
ml init b0;
ml maximize;

* COMPUTING PARTIAL EFFECTS FOR SELF-EMPLOYED AFTER myheckprob;

margins, expression(normal(xb(self_empl)+(1-edu_0_11)*[self_empl]_b[edu_0_11]-edu_13_15*[self_empl]_b[edu_13_15]-edu_16plus*[self_empl]_b[edu_16plus])
		-normal(xb(self_empl)-edu_0_11*[self_empl]_b[edu_0_11]-edu_13_15*[self_empl]_b[edu_13_15]-edu_16plus*[self_empl]_b[edu_16plus]));
margins, expression(normal(xb(self_empl)+(1-edu_13_15)*[self_empl]_b[edu_13_15]-edu_0_11*[self_empl]_b[edu_0_11]-edu_16plus*[self_empl]_b[edu_16plus])
		-normal(xb(self_empl)-edu_0_11*[self_empl]_b[edu_0_11]-edu_13_15*[self_empl]_b[edu_13_15]-edu_16plus*[self_empl]_b[edu_16plus]));
margins, expression(normal(xb(self_empl)+(1-edu_16plus)*[self_empl]_b[edu_16plus]-edu_0_11*[self_empl]_b[edu_0_11]-edu_13_15*[self_empl]_b[edu_13_15])
		-normal(xb(self_empl)-edu_0_11*[self_empl]_b[edu_0_11]-edu_13_15*[self_empl]_b[edu_13_15]-edu_16plus*[self_empl]_b[edu_16plus]));

margins, expression(normal(xb(self_empl)+(1+mean_age-age)*[self_empl]_b[age]+((1+mean_age)^2 - agesq)*[self_empl]_b[agesq])
		   -normal(xb(self_empl)+(mean_age-age)*[self_empl]_b[age]+(mean_age^2 - agesq)*[self_empl]_b[agesq]));

margins, expression(normal(xb(self_empl)+(1-married)*[self_empl]_b[married])-normal(xb(self_empl)-married*[self_empl]_b[married]));
margins, expression(normal(xb(self_empl)+(1-d_ch_1_5)*[self_empl]_b[d_ch_1_5])-normal(xb(self_empl)-d_ch_1_5*[self_empl]_b[d_ch_1_5]));
margins, expression(normal(xb(self_empl)+(1-d_ch_6_17)*[self_empl]_b[d_ch_6_17])-normal(xb(self_empl)-d_ch_6_17*[self_empl]_b[d_ch_6_17]));

margins, expression(normal(xb(self_empl)+(1+mean_sp_inc1000-sp_inc1000)*[self_empl]_b[sp_inc1000])
		   -normal(xb(self_empl)+(mean_sp_inc1000-sp_inc1000)*[self_empl]_b[sp_inc1000]));

margins, expression(normal(xb(self_empl)+(1-urban)*[self_empl]_b[urban])-normal(xb(self_empl)-urban*[self_empl]_b[urban]));
margins, expression(normal(xb(self_empl)+(1-rotter_score)*[self_empl]_b[rotter_score])
		     -normal(xb(self_empl)-rotter_score*[self_empl]_b[rotter_score]));
margins, expression(normal(xb(self_empl)+(1-sesteem_score1)*[self_empl]_b[sesteem_score1])
		-normal(xb(self_empl)-sesteem_score1*[self_empl]_b[sesteem_score1]));
margins, expression(normal(xb(self_empl)+(1-policever)*[self_empl]_b[policever])-normal(xb(self_empl)-policever*[self_empl]_b[policever]));

margins, expression(normal(xb(self_empl)+[self_empl]_b[south]-south*[self_empl]_b[south])-normal(xb(self_empl)-south*[self_empl]_b[south]));

margins, expression(normal(xb(self_empl)+(1+mean_unemp_rate-unemp_rate)*[self_empl]_b[unemp_rate])
		   -normal(xb(self_empl)+(mean_unemp_rate-unemp_rate)*[self_empl]_b[unemp_rate]));

margins, expression(normal(xb(self_empl)+(1-m_married)*[self_empl]_b[m_married])-normal(xb(self_empl)-m_married*[self_empl]_b[m_married]));
margins, expression(normal(xb(self_empl)+(1+mean_m_sp_inc1000-m_sp_inc1000)*[self_empl]_b[m_sp_inc1000])
		   -normal(xb(self_empl)+(mean_m_sp_inc1000-m_sp_inc1000)*[self_empl]_b[m_sp_inc1000]));

* COMPUTING PARTIAL EFFECTS FOR WORKING AFTER myheckprob;

margins, expression(normal(xb(working)+(1-edu_0_11)*[working]_b[edu_0_11]-edu_13_15*[working]_b[edu_13_15]-edu_16plus*[working]_b[edu_16plus])
		-normal(xb(working)-edu_0_11*[working]_b[edu_0_11]-edu_13_15*[working]_b[edu_13_15]-edu_16plus*[working]_b[edu_16plus]));
margins, expression(normal(xb(working)+(1-edu_13_15)*[working]_b[edu_13_15]-edu_0_11*[working]_b[edu_0_11]-edu_16plus*[working]_b[edu_16plus])
		-normal(xb(working)-edu_0_11*[working]_b[edu_0_11]-edu_13_15*[working]_b[edu_13_15]-edu_16plus*[working]_b[edu_16plus]));
margins, expression(normal(xb(working)+(1-edu_16plus)*[working]_b[edu_16plus]-edu_0_11*[working]_b[edu_0_11]-edu_13_15*[working]_b[edu_13_15])
		-normal(xb(working)-edu_0_11*[working]_b[edu_0_11]-edu_13_15*[working]_b[edu_13_15]-edu_16plus*[working]_b[edu_16plus]));

margins, expression(normal(xb(working)+(1+mean_age-age)*[working]_b[age]+((1+mean_age)^2 - agesq)*[working]_b[agesq])
		   -normal(xb(working)+(mean_age-age)*[working]_b[age]+(mean_age^2 - agesq)*[working]_b[agesq]));

margins, expression(normal(xb(working)+(1-married)*[working]_b[married])-normal(xb(working)-married*[working]_b[married]));
margins, expression(normal(xb(working)+(1-d_ch_1_5)*[working]_b[d_ch_1_5])-normal(xb(working)-d_ch_1_5*[working]_b[d_ch_1_5]));
margins, expression(normal(xb(working)+(1-d_ch_6_17)*[working]_b[d_ch_6_17])-normal(xb(working)-d_ch_6_17*[working]_b[d_ch_6_17]));

margins, expression(normal(xb(working)+(1+mean_sp_inc1000-sp_inc1000)*[working]_b[sp_inc1000])
		   -normal(xb(working)+(mean_sp_inc1000-sp_inc1000)*[working]_b[sp_inc1000]));

margins, expression(normal(xb(working)+(1-urban)*[working]_b[urban])-normal(xb(working)-urban*[working]_b[urban]));

margins, expression(normal(xb(working)+(1-rotter_score)*[working]_b[rotter_score])
		     -normal(xb(working)-rotter_score*[working]_b[rotter_score]));
margins, expression(normal(xb(working)+(1-sesteem_score1)*[working]_b[sesteem_score1])
		-normal(xb(working)-sesteem_score1*[working]_b[sesteem_score1]));
margins, expression(normal(xb(working)+(1-policever)*[working]_b[policever])-normal(xb(working)-policever*[working]_b[policever]));

margins, expression(normal(xb(working)+[working]_b[south]-south*[working]_b[south])-normal(xb(working)-south*[working]_b[south]));

margins, expression(normal(xb(working)+(1+mean_unemp_rate-unemp_rate)*[working]_b[unemp_rate])
		   -normal(xb(working)+(mean_unemp_rate-unemp_rate)*[working]_b[unemp_rate]));

margins, expression(normal(xb(working)+(1-m_married)*[working]_b[m_married])-normal(xb(working)-m_married*[working]_b[m_married]));
margins, expression(normal(xb(working)+(1+mean_m_sp_inc1000-m_sp_inc1000)*[working]_b[m_sp_inc1000])
		   -normal(xb(working)+(mean_m_sp_inc1000-m_sp_inc1000)*[working]_b[m_sp_inc1000]));

margins, expression(normal(xb(working)+(1-afqt_1)*[working]_b[afqt_1])-normal(xb(working)-afqt_1*[working]_b[afqt_1]));

* GENERATING INITIAL VALUES;

	biprobit (self_empl = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban
		rotter_score sesteem_score1 policever south unemp_rate m_*) (d_ch_1_5 = td1-td18 $educ $age married sp_inc1000 urban
 		rotter_score sesteem_score1 policever south unemp_rate samesex m_*), cluster(id);
	mat b = e(b);
	mat b3 = b[1,1..36];
	mat coleq b3 = self_empl;

* COMPUTING PARTIAL EFFECTS FOR self_empl AFTER biprobit;

gen smkids=d_ch_1_5;

* edu_0_11;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_0_11]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* edu_13_15;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_13_15]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* edu_16plus;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* age;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ (1+mean_age)*[self_empl]_b[age] + (1+mean_age)^2*[self_empl]_b[agesq]
		+ married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ mean_age*[self_empl]_b[age] + mean_age^2*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* married;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + [self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* d_ch_1_5;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* d_ch_6_17;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ [self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* sp_inc1000;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+(1+mean_sp_inc1000)*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ mean_sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* urban;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* rotter_score;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ [self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* sesteem_score1;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ [self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* policever;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ [self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* south;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ [self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* unemp_rate;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + (1+mean_unemp_rate)*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + mean_unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* m_married;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + [self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* m_sp_inc1000;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + (1+mean_m_sp_inc1000)*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + mean_m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* COMPUTING PARTIAL EFFECTS FOR ch_1_5 AFTER biprobit;

margins, expression(normal(xb(d_ch_1_5)+(1-edu_0_11)*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));
margins, expression(normal(xb(d_ch_1_5)+(1-edu_13_15)*[d_ch_1_5]_b[edu_13_15]-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_16plus*[d_ch_1_5]_b[edu_16plus])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));
margins, expression(normal(xb(d_ch_1_5)+(1-edu_16plus)*[d_ch_1_5]_b[edu_16plus]-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_age-age)*[d_ch_1_5]_b[age]+((1+mean_age)^2 - agesq)*[d_ch_1_5]_b[agesq])
		   -normal(xb(d_ch_1_5)+(mean_age-age)*[d_ch_1_5]_b[age]+(mean_age^2 - agesq)*[d_ch_1_5]_b[agesq]));

margins, expression(normal(xb(d_ch_1_5)+(1-married)*[d_ch_1_5]_b[married])-normal(xb(d_ch_1_5)-married*[d_ch_1_5]_b[married]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_sp_inc1000-sp_inc1000)*[d_ch_1_5]_b[sp_inc1000])
		   -normal(xb(d_ch_1_5)+(mean_sp_inc1000-sp_inc1000)*[d_ch_1_5]_b[sp_inc1000]));

margins, expression(normal(xb(d_ch_1_5)+(1-urban)*[d_ch_1_5]_b[urban])-normal(xb(d_ch_1_5)-urban*[d_ch_1_5]_b[urban]));
margins, expression(normal(xb(d_ch_1_5)+(1-rotter_score)*[d_ch_1_5]_b[rotter_score])
		     -normal(xb(d_ch_1_5)-rotter_score*[d_ch_1_5]_b[rotter_score]));
margins, expression(normal(xb(d_ch_1_5)+(1-sesteem_score1)*[d_ch_1_5]_b[sesteem_score1])
		-normal(xb(d_ch_1_5)-sesteem_score1*[d_ch_1_5]_b[sesteem_score1]));
margins, expression(normal(xb(d_ch_1_5)+(1-policever)*[d_ch_1_5]_b[policever])-normal(xb(d_ch_1_5)-policever*[d_ch_1_5]_b[policever]));

margins, expression(normal(xb(d_ch_1_5)+[d_ch_1_5]_b[south]-south*[d_ch_1_5]_b[south])-normal(xb(d_ch_1_5)-south*[d_ch_1_5]_b[south]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_unemp_rate-unemp_rate)*[d_ch_1_5]_b[unemp_rate])
		   -normal(xb(d_ch_1_5)+(mean_unemp_rate-unemp_rate)*[d_ch_1_5]_b[unemp_rate]));

margins, expression(normal(xb(d_ch_1_5)+(1-m_married)*[d_ch_1_5]_b[m_married])-normal(xb(d_ch_1_5)-m_married*[d_ch_1_5]_b[m_married]));
margins, expression(normal(xb(d_ch_1_5)+(1+mean_m_sp_inc1000-m_sp_inc1000)*[d_ch_1_5]_b[m_sp_inc1000])
		   -normal(xb(d_ch_1_5)+(mean_m_sp_inc1000-m_sp_inc1000)*[d_ch_1_5]_b[m_sp_inc1000]));

margins, expression(normal(xb(d_ch_1_5)+(1-samesex)*[d_ch_1_5]_b[samesex])-normal(xb(d_ch_1_5)-samesex*[d_ch_1_5]_b[samesex]));


	biprobit (working = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban
		 rotter_score sesteem_score1 policever south unemp_rate afqt_1 m_*) (d_ch_1_5 = td1-td18 $educ $age married sp_inc1000 urban
 		 rotter_score sesteem_score1 policever south unemp_rate samesex m_*), cluster(id);
	mat b = e(b);
	mat b1 = b[1,1..37];
	mat coleq b1 = working;

	probit d_ch_1_5 td1-td18 $educ $age married sp_inc1000 urban rotter_score sesteem_score1 policever
		south unemp_rate samesex m_*, cluster(id);
	mat b2 = e(b);
	mat coleq b2 = d_ch_1_5;

	mat b0 = b1, b2, b3;

mdraws, neq(3) dr(100) prefix(z) burn(10) replace;

global dr = r(n_draws);

ml model lf myll (working: working = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban rotter_score
		sesteem_score1 policever south unemp_rate afqt_1 m_*) (d_ch_1_5: d_ch_1_5 = td1-td18 $educ $age married
		sp_inc1000 urban rotter_score sesteem_score1 policever south unemp_rate samesex m_*)
		(self_empl: self_empl = td1-td18 $educ $age married d_ch_1_5 d_ch_6_17 sp_inc1000 urban rotter_score
		sesteem_score1 policever south unemp_rate m_*)
		 /c21 /c31 /c32, missing vce(cluster id);

ml init b0;

ml maximize;

nlcom (r21: [c21]_b[_cons]) (r31: [c31]_b[_cons])
 (r32: [c21]_b[_cons]*[c31]_b[_cons]+ sqrt(1- [c21]_b[_cons]^2)*[c32]_b[_cons]);

test [self_empl]unemp_rate [self_empl]south;
test [working]unemp_rate [working]south;
test [d_ch_1_5]unemp_rate [d_ch_1_5]south;

display "`c(current_time)' `c(current_date)'";

mat b=e(b);

* COMPUTING APEs AND THEIR STD ERRORS FOR SELF-EMPLOYED AFTER myll;

* edu_0_11;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_0_11]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* edu_13_15;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_13_15]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* edu_16plus;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ [self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* age;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ (1+mean_age)*[self_empl]_b[age] + (1+mean_age)^2*[self_empl]_b[agesq]
		+ married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ mean_age*[self_empl]_b[age] + mean_age^2*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* married;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + [self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* d_ch_1_5;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* d_ch_6_17;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ [self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* mean_sp_inc1000;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+(1+mean_sp_inc1000)*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ mean_sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* urban;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* rotter_score;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ [self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* sesteem_score1;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ [self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* policever;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ [self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* south;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ [self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* unemp_rate;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + (1+mean_unemp_rate)*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + mean_unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));
* m_married;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + [self_empl]_b[m_married] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));

* m_sp_inc1000;
margins, expression(normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + (1+mean_m_sp_inc1000)*[self_empl]_b[m_sp_inc1000])
		-normal([self_empl]_b[_cons]+td1*[self_empl]_b[td1] + td2*[self_empl]_b[td2] + td3*[self_empl]_b[td3] + td4*[self_empl]_b[td4]
		+ td5*[self_empl]_b[td5]+td6*[self_empl]_b[td6]+td7*[self_empl]_b[td7]+td8*[self_empl]_b[td8]+td9*[self_empl]_b[td9]
		+ td10*[self_empl]_b[td10]+td11*[self_empl]_b[td11]+td12*[self_empl]_b[td12]+td13*[self_empl]_b[td13]+td14*[self_empl]_b[td14]
		+ td15*[self_empl]_b[td15]+td16*[self_empl]_b[td16]+td17*[self_empl]_b[td17]+td18*[self_empl]_b[td18]
		+ edu_0_11*[self_empl]_b[edu_0_11] + edu_13_15*[self_empl]_b[edu_13_15] + edu_16plus*[self_empl]_b[edu_16plus]
		+ age*[self_empl]_b[age] + agesq*[self_empl]_b[agesq] + married*[self_empl]_b[married]+smkids*[self_empl]_b[d_ch_1_5]
		+ d_ch_6_17*[self_empl]_b[d_ch_6_17]+ sp_inc1000*[self_empl]_b[sp_inc1000]+urban*[self_empl]_b[urban]
		+ south*[self_empl]_b[south] + unemp_rate*[self_empl]_b[unemp_rate]
		+ rotter_score*[self_empl]_b[rotter_score]+ sesteem_score1*[self_empl]_b[sesteem_score1]
		+ policever*[self_empl]_b[policever] + m_married*[self_empl]_b[m_married] + mean_m_sp_inc1000*[self_empl]_b[m_sp_inc1000]));


* COMPUTING APEs AND THEIR STD ERRORS FOR WORKING AFTER myll;

* edu_0_11;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ [working]_b[edu_0_11]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));
* edu_13_15;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ [working]_b[edu_13_15]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));
* edu_16plus;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ [working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* age;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ (1+mean_age)*[working]_b[age] + (1+mean_age)^2*[working]_b[agesq]
		+ married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ mean_age*[working]_b[age] + mean_age^2*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* married;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + [working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* d_ch_1_5;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* d_ch_6_17;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ [working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* sp_inc1000;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+(1+mean_sp_inc1000)*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ mean_sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* urban;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* rotter_score;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + [working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* sesteem_score1;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ [working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* policever;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ [working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));
* south;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ [working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));
* unemp_rate;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + (1+mean_unemp_rate)*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + mean_unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* m_married;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + [working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* m_sp_inc1000;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + (1+mean_m_sp_inc1000)*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ afqt_1*[working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + mean_m_sp_inc1000*[working]_b[m_sp_inc1000]));

* afqt_1;
margins, expression(normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ [working]_b[afqt_1] + rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000])
		-normal([working]_b[_cons]+td1*[working]_b[td1] + td2*[working]_b[td2] + td3*[working]_b[td3] + td4*[working]_b[td4]
		+ td5*[working]_b[td5]+td6*[working]_b[td6]+td7*[working]_b[td7]+td8*[working]_b[td8]+td9*[working]_b[td9]
		+ td10*[working]_b[td10]+td11*[working]_b[td11]+td12*[working]_b[td12]+td13*[working]_b[td13]+td14*[working]_b[td14]
		+ td15*[working]_b[td15]+td16*[working]_b[td16]+td17*[working]_b[td17]+td18*[working]_b[td18]
		+ edu_0_11*[working]_b[edu_0_11] + edu_13_15*[working]_b[edu_13_15] + edu_16plus*[working]_b[edu_16plus]
		+ age*[working]_b[age] + agesq*[working]_b[agesq] + married*[working]_b[married]+smkids*[working]_b[d_ch_1_5]
		+ d_ch_6_17*[working]_b[d_ch_6_17]+ sp_inc1000*[working]_b[sp_inc1000]+urban*[working]_b[urban]
		+ south*[working]_b[south] + unemp_rate*[working]_b[unemp_rate]
		+ rotter_score*[working]_b[rotter_score]+ sesteem_score1*[working]_b[sesteem_score1]
		+ policever*[working]_b[policever] + m_married*[working]_b[m_married] + m_sp_inc1000*[working]_b[m_sp_inc1000]));

* COMPUTING APEs AND THEIR STD ERRORS FOR d_ch_1_5 AFTER myll;

margins, expression(normal(xb(d_ch_1_5)+(1-edu_0_11)*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));
margins, expression(normal(xb(d_ch_1_5)+(1-edu_13_15)*[d_ch_1_5]_b[edu_13_15]-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_16plus*[d_ch_1_5]_b[edu_16plus])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));
margins, expression(normal(xb(d_ch_1_5)+(1-edu_16plus)*[d_ch_1_5]_b[edu_16plus]-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15])
		-normal(xb(d_ch_1_5)-edu_0_11*[d_ch_1_5]_b[edu_0_11]-edu_13_15*[d_ch_1_5]_b[edu_13_15]-edu_16plus*[d_ch_1_5]_b[edu_16plus]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_age-age)*[d_ch_1_5]_b[age]+((1+mean_age)^2 - agesq)*[d_ch_1_5]_b[agesq])
		   -normal(xb(d_ch_1_5)+(mean_age-age)*[d_ch_1_5]_b[age]+(mean_age^2 - agesq)*[d_ch_1_5]_b[agesq]));

margins, expression(normal(xb(d_ch_1_5)+(1-married)*[d_ch_1_5]_b[married])-normal(xb(d_ch_1_5)-married*[d_ch_1_5]_b[married]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_sp_inc1000-sp_inc1000)*[d_ch_1_5]_b[sp_inc1000])
		   -normal(xb(d_ch_1_5)+(mean_sp_inc1000-sp_inc1000)*[d_ch_1_5]_b[sp_inc1000]));

margins, expression(normal(xb(d_ch_1_5)+(1-urban)*[d_ch_1_5]_b[urban])-normal(xb(d_ch_1_5)-urban*[d_ch_1_5]_b[urban]));
margins, expression(normal(xb(d_ch_1_5)+(1-rotter_score)*[d_ch_1_5]_b[rotter_score])
		     -normal(xb(d_ch_1_5)-rotter_score*[d_ch_1_5]_b[rotter_score]));
margins, expression(normal(xb(d_ch_1_5)+(1-sesteem_score1)*[d_ch_1_5]_b[sesteem_score1])
		-normal(xb(d_ch_1_5)-sesteem_score1*[d_ch_1_5]_b[sesteem_score1]));
margins, expression(normal(xb(d_ch_1_5)+(1-policever)*[d_ch_1_5]_b[policever])-normal(xb(d_ch_1_5)-policever*[d_ch_1_5]_b[policever]));

margins, expression(normal(xb(d_ch_1_5)+[d_ch_1_5]_b[south]-south*[d_ch_1_5]_b[south])-normal(xb(d_ch_1_5)-south*[d_ch_1_5]_b[south]));

margins, expression(normal(xb(d_ch_1_5)+(1+mean_unemp_rate-unemp_rate)*[d_ch_1_5]_b[unemp_rate])
		   -normal(xb(d_ch_1_5)+(mean_unemp_rate-unemp_rate)*[d_ch_1_5]_b[unemp_rate]));
margins, expression(normal(xb(d_ch_1_5)+(1-m_married)*[d_ch_1_5]_b[m_married])-normal(xb(d_ch_1_5)-m_married*[d_ch_1_5]_b[m_married]));
margins, expression(normal(xb(d_ch_1_5)+(1+mean_m_sp_inc1000-m_sp_inc1000)*[d_ch_1_5]_b[m_sp_inc1000])
		   -normal(xb(d_ch_1_5)+(mean_m_sp_inc1000-m_sp_inc1000)*[d_ch_1_5]_b[m_sp_inc1000]));

margins, expression(normal(xb(d_ch_1_5)+(1-samesex)*[d_ch_1_5]_b[samesex])-normal(xb(d_ch_1_5)-samesex*[d_ch_1_5]_b[samesex]));

log close;
