* PURPOSE: RUN PARAMETRIC ESTIMATION DISCUSSED IN BINARY_SELECTION PAPER
* LIMIT SAMPLE TO WHITE WOMEN

# delimit;

clear;
clear matrix;
clear mata;

set mem 1000m;
set matsize 5000;

cd "c:\Nastja\Research\BinarySelection\NLSY79\";

capture log close;
log using logs\param_regs.log, replace;

set seed 0910151150;

use "NLSY79_91_94.dta", clear;

******************************
* LIMIT SAMPLE TO WHITE WOMEN;

tab SEX RACE;
keep if SEX==2 & RACE==3;

tab year, sum(working);

sum age educ afqt married;

qui sum afqt_1;
replace afqt_1=(afqt_1-r(mean))/r(sd);

************************************************
* NOTE: qreg DID NOT PRODUCE REASONABLE RESULTS;

tobit hrswrk52 td* age educ married afqt_1 mmarried, ll(0);
predict xb, xb;
gen v2hat=hrswrk52-xb if hrswrk52>0;

probit pension td* age educ afqt_1, cluster(id);
scalar b1=_b[age];
scalar b2=_b[educ];
scalar b3=_b[afqt_1];
scalar b2r_p_noC_noV_tr=b2/b1;
scalar b3r_p_noC_noV_tr=b3/b1;

probit pension td* age educ afqt_1 mmarried, cluster(id);
scalar b1=_b[age];
scalar b2=_b[educ];
scalar b3=_b[afqt_1];
scalar b4=_b[mmarried];
scalar b2r_p_C_noV_tr=b2/b1;
scalar b3r_p_C_noV_tr=b3/b1;
scalar b4r_p_C_noV_tr=b4/b1;

probit pension td* age educ afqt_1 mmarried v2hat, cluster(id);
scalar b1=_b[age];
scalar b2=_b[educ];
scalar b3=_b[afqt_1];
scalar b4=_b[mmarried];
scalar b2r_p_tr=b2/b1;
scalar b3r_p_tr=b3/b1;
scalar b4r_p_tr=b4/b1;

scalar di b2r_p_noC_noV_tr;
scalar di b3r_p_noC_noV_tr;

scalar di b2r_p_C_noV_tr;
scalar di b3r_p_C_noV_tr;
scalar di b4r_p_C_noV_tr;

scalar di b2r_p_tr;
scalar di b3r_p_tr;
scalar di b4r_p_tr;

*************************************************************************
* BOOTSTRAP;

drop xb v2hat;

capture postclose bst01;

postfile bst01 b2r_p_noC_noV_tr b3r_p_noC_noV_tr b2r_p_C_noV_tr b3r_p_C_noV_tr b4r_p_C_noV_tr b2r_p_tr b3r_p_tr b4r_p_tr
b1_noCV b2_noCV b3_noCV b1_noV b2_noV b3_noV b4_noV b1_p b2_p b3_p b4_p
b2r_p_noC_noV b3r_p_noC_noV b2r_p_C_noV b3r_p_C_noV b4r_p_C_noV b2r_p b3r_p b4r_p using data\bstrap_param.dta, replace;

scalar reps=500;

local r=1;

quietly {;

while `r'<=reps {;
noisily di "replication " `r';

preserve;
bsample, cluster(id);

tobit hrswrk52 td* age educ married afqt_1 mmarried, ll(0);
predict xb, xb;
gen v2hat=hrswrk52-xb if hrswrk52>0;

probit pension td* age educ afqt_1, cluster(id);

scalar b1_noCV=_b[age];
scalar b2_noCV=_b[educ];
scalar b3_noCV=_b[afqt_1];

scalar b2r_p_noC_noV=b2_noCV/b1_noCV;
scalar b3r_p_noC_noV=b3_noCV/b1_noCV;

probit pension td* age educ afqt_1 mmarried, cluster(id);

scalar b1_noV=_b[age];
scalar b2_noV=_b[educ];
scalar b3_noV=_b[afqt_1];
scalar b4_noV=_b[mmarried];

scalar b2r_p_C_noV=b2_noV/b1_noV;
scalar b3r_p_C_noV=b3_noV/b1_noV;
scalar b4r_p_C_noV=b4_noV/b1_noV;

probit pension td* age educ afqt_1 mmarried v2hat, cluster(id);

scalar b1_p=_b[age];
scalar b2_p=_b[educ];
scalar b3_p=_b[afqt_1];
scalar b4_p=_b[mmarried];

scalar b2r_p=b2_p/b1_p;
scalar b3r_p=b3_p/b1_p;
scalar b4r_p=b4_p/b1_p;

post bst01 (b2r_p_noC_noV_tr) (b3r_p_noC_noV_tr) (b2r_p_C_noV_tr) (b3r_p_C_noV_tr) (b4r_p_C_noV_tr) (b2r_p_tr) (b3r_p_tr) (b4r_p_tr)
(b1_noCV) (b2_noCV) (b3_noCV) (b1_noV) (b2_noV) (b3_noV) (b4_noV) (b1_p) (b2_p) (b3_p) (b4_p)
(b2r_p_noC_noV) (b3r_p_noC_noV) (b2r_p_C_noV) (b3r_p_C_noV) (b4r_p_C_noV) (b2r_p) (b3r_p) (b4r_p);

restore;

  local r=`r'+1;
  };

};

postclose bst01;

log close;
