* PURPOSE: RUN FLEXIBLE PARAMETRIC ESTIMATION DISCUSSED IN BINARY_SELECTION PAPER
* LIMIT SAMPLE TO WHITE WOMEN

# delimit;

clear;
clear matrix;
clear mata;

set mem 1000m;
set matsize 5000;

cd "c:\Nastja\Research\BinarySelection\NLSY79\";

capture log close;
log using logs\flex_param_regs.log, replace;

set seed 0910151150;

use "data\NLSY79_91_94.dta", clear;

******************************
* LIMIT SAMPLE TO WHITE WOMEN;

tab SEX RACE;
keep if SEX==2 & RACE==3;

tab year, sum(working);

sum age educ afqt married;

qui sum afqt_1;
replace afqt_1=(afqt_1-r(mean))/r(sd);

************************************************
* NOTE: qreg DID NOT PRODUCE REASONABLE RESULTS;

tobit hrswrk52 td* age educ married afqt_1 mmarried, ll(0);
predict xb, xb;
gen v2hat=hrswrk52-xb if hrswrk52>0;

probit pension td* age educ afqt_1 mmarried v2hat, cluster(id);

gen v2hat2 = v2hat^2;
gen mmarr2 = mmarried^2;
gen v2hatmmarr = mmarried*v2hat;
gen v2hat3 = v2hat^3;
gen mmarr3 = mmarried^3;
gen v2hatmmarr2 = mmarr2*v2hat;
gen v2hat2mmarr = mmarried*v2hat2;

probit pension td* age educ afqt_1 mmarried v2hat v2hat2 mmarr2 v2hatmmarr, cluster(id);
test v2hat v2hat2 v2hatmmarr;

scalar b1_fp=_b[age];
scalar b2_fp=_b[educ];
scalar b3_fp=_b[afqt_1];
scalar b4_fp=_b[mmarried];
scalar b2r_fp=b2_fp/b1_fp;
scalar b3r_fp=b3_fp/b1_fp;
scalar b4r_fp=b4_fp/b1_fp;
scalar bv2_fp=_b[v2hat];

di b1_fp;
di b2_fp;
di b3_fp;
di b4_fp;
di b2r_fp;
di b3r_fp;
di b4r_fp;

probit pension td* age educ afqt_1 mmarried v2hat v2hat2 mmarr2 v2hatmmarr v2hat3 mmarr3 v2hatmmarr2 v2hat2mmarr, cluster(id);
test v2hat3 mmarr3 v2hatmmarr2 v2hat2mmarr;

/*

* THIS VERSION PRODUCES RESULTS SIMILAR TO PROBIT WITH QUADRATICS IN v2hat, mmarried, AND THEIR INTERACTION;
* TAKES MORE TIME TO CONVERGE;

capture program drop myflexp;
program myflexp;
	args lnf beta zbar v c1 c2 c3;
	tempvar zbar2 v2 zbarv;
	quietly gen double `zbar2'=`zbar'*`zbar';
	quietly gen double `v2'=`v'*`v';
	quietly gen double `zbarv'=`zbar'*`v';
	quietly replace `lnf'=ln(normal(`beta'+`zbar'+`v'+`c1'*`zbar2'+`c2'*`v2'+`c3'*`zbarv')) if $ML_y1==1;
	quietly replace `lnf'=ln(normal(-(`beta'+`zbar'+`v'+`c1'*`zbar2'+`c2'*`v2'+`c3'*`zbarv'))) if $ML_y1==0;
end;

ml model lf myflexp (pension = td* age educ afqt_1) (mmarried, nocons) (v2hat, nocons) /C1 /C2 /C3, vce(cluster id);
ml maximize;

test [eq3]v2hat [C2]_cons;
*/

*************************************************************************
* BOOTSTRAP;

drop xb v2hat v2hat2 mmarr2 v2hatmmarr;

capture postclose bst01;

postfile bst01 b1_fp b2_fp b3_fp b4_fp b2r_fp b3r_fp b4r_fp bv2_fp using data\bstrap_flex_param_revision02.dta, replace;

scalar reps=200;

local r=1;

quietly {;

while `r'<=reps {;
noisily di "replication " `r';
noisily display "`c(current_time)' `c(current_date)'";

preserve;
bsample, cluster(id);

tobit hrswrk52 td* age educ married afqt_1 mmarried, ll(0);
predict xb, xb;
gen v2hat=hrswrk52-xb if hrswrk52>0;

gen v2hat2 = v2hat^2;
gen mmarr2 = mmarried^2;
gen v2hatmmarr = mmarried*v2hat;

probit pension td* age educ afqt_1 mmarried v2hat v2hat2 mmarr2 v2hatmmarr, cluster(id);

scalar b1_fp=_b[age];
scalar b2_fp=_b[educ];
scalar b3_fp=_b[afqt_1];
scalar b4_fp=_b[mmarried];
scalar b2r_fp=b2_fp/b1_fp;
scalar b3r_fp=b3_fp/b1_fp;
scalar b4r_fp=b4_fp/b1_fp;
scalar bv2_fp=_b[v2hat];

post bst01 (b1_fp) (b2_fp) (b3_fp) (b4_fp) (b2r_fp) (b3r_fp) (b4r_fp) (bv2_fp);

restore;

  local r=`r'+1;
  };

};

postclose bst01;

use data\bstrap_flex_param.dta, clear;

sum b*;

log close;
