rm(list=ls())

library(foreign) #read.csv, inport data
library(lfe) #for lm with fixed effect (felm)
library(stargazer) #export results
library(data.table) #importing from the web using fread

#set working directory to folder location
setwd("")

#**********************#
#    Data - Bank level
#**********************#
#1. Baseline (loan level) 
mydata = read.csv("data/mydata_loan.csv") 
mydata  = do.call(data.frame,lapply(mydata , function(x) replace(x, is.infinite(x),NA)))
mydata  = do.call(data.frame,lapply(mydata , function(x) replace(x, is.nan(x),NA)))

#2. Excluding credit card banks (loan level) 
mydata_ecredit = mydata
banks = c(30810,112855,486752,489913,1830035,2253891,2582023,1417557)
mydata_ecredit$credit_bank = ifelse(mydata_ecredit$bankid %in% banks,1,0)
mydata_ecredit$credit_bank = ifelse(mydata_ecredit$year>=2004 & mydata_ecredit$bankid==688079,1,mydata_ecredit$credit_bank)

mydata_ecredit$credit_bank_2008 = ifelse(mydata_ecredit$year %in% c(2007,2008) & mydata_ecredit$credit_bank==1,1,0)

mydata_ecredit_2008 = mydata_ecredit[which(mydata_ecredit$credit_bank_2008==0),]
mydata_ecredit = mydata_ecredit[which(mydata_ecredit$credit_bank==0),]


#**********************#
# Data - county level
#**********************#
#1. Baseline  
mydata_c = read.csv("data/mydata_county.csv") 
mydata_c  = do.call(data.frame,lapply(mydata_c , function(x) replace(x, is.infinite(x),NA)))
mydata_c  = do.call(data.frame,lapply(mydata_c , function(x) replace(x, is.nan(x),NA)))

#2. Excluding credit card banks (loan level) 
mydata_c_ecredit = read.csv("data/mydata_county_ecredit.csv") 
mydata_c_ecredit  = do.call(data.frame,lapply(mydata_c_ecredit , function(x) replace(x, is.infinite(x),NA)))
mydata_c_ecredit  = do.call(data.frame,lapply(mydata_c_ecredit , function(x) replace(x, is.nan(x),NA)))

#3. Excluding Banks with less than 1 bil in 2010 us dollar assets (loan level) 
mydata_c_1bil = read.csv("data/mydata_county_1bil.csv") 
mydata_c_1bil  = do.call(data.frame,lapply(mydata_c_1bil , function(x) replace(x, is.infinite(x),NA)))
mydata_c_1bil  = do.call(data.frame,lapply(mydata_c_1bil , function(x) replace(x, is.nan(x),NA)))


#**********************#
#    Main Results
#**********************#

#--------------------------------------
#  Table 1: Table VI Baseline results
#--------------------------------------
#Sample
mydata1 = mydata #Full sample

#Monetary policy
mydata1$mp = mydata1$d1_fftar_yearend

#Bank competition
mydata1$Comp = mydata1$herfdepcty

table6_1 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp 
                 | bankid + year + fips + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | bankid + year + fips + fipszero | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "Narrow Replication of DSS Table VI (Bank-County Results)",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          #omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("Bank-HHI$","$\\Delta FF X Bank-HHI$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Wide/table1.text",
          omit.stat = c("adj.rsq","ser"))


#------------------------------------
#  Table 2: Table VII baseline results
#------------------------------------
table7_data = mydata_c

table7_1 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_2 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_3 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_4 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_5 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_6 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

stargazer(table7_1, table7_2,table7_3, table7_4,table7_5, table7_6,
          type = "text",
          title= "Narrow Replication of DSS Table VII (County-Level Results)",
          dep.var.caption  = "", model.numbers= T,
          dep.var.labels.include = FALSE,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y", "Y", "Y", "Y"),
                           c("County f.e.", "Y", "Y", "Y", "Y", "Y", "Y")),
          covariate.labels = c("$\\Delta FF X County-HHI$","County-HHI","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Wide/table2.text",
          column.labels   = c("log(new lending)", "\\Delta Employment","\\Delta Wage Bill"),
          column.separate = c(2, 2, 2),
          omit.stat = c("adj.rsq","ser"))


#---------------------------------------------------------------------
#  Table 3: Table VI Dropping credit card banks
#--------------------------------------------------------------------
#sample
mydata1 = mydata_ecredit 

#Choose monetary policy 
mydata1$mp = mydata1$d1_fftar_yearend

#Bank competition
mydata1$Comp = mydata1$herfdepcty


table6_1 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp 
                 | bankid + year + fips + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | bankid + year + fips + fipszero | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "DSS Table VI. Dropping Credit Card Banks",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          #omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("Bank-HHI$","$\\Delta FF X Bank-HHI$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Wide/table3.text",
          omit.stat = c("adj.rsq","ser"))

#------------------------------------
#  Table 4: Table VII Dropping credit card banks
#------------------------------------
#sample
table7_data = mydata_c_ecredit


table7_1 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_2 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_3 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_4 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_5 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_6 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

stargazer(table7_1, table7_2,table7_3, table7_4,table7_5, table7_6,
          type = "text",
          title= "DSS Table VII. Dropping Credit Card Banks",
          dep.var.caption  = "", model.numbers= T,
          dep.var.labels.include = FALSE,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y", "Y", "Y", "Y"),
                           c("County f.e.", "Y", "Y", "Y", "Y", "Y", "Y")),
          covariate.labels = c("$\\Delta FF X County-HHI$","County-HHI","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Wide/table4.text",
          column.labels   = c("log(new lending)", "\\Delta Employment","\\Delta Wage Bill"),
          column.separate = c(2, 2, 2),
          omit.stat = c("adj.rsq","ser"))

#-----------------
#  Table 5: Lerner index
#-----------------

#Choose sample
mydata1 = mydata

#Choose monetary policy 
mydata1$mp = mydata1$d1_fftar_yearend

#Bank Competition
mydata1$Comp = mydata1$Lerner.l1


table6_1 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1[which(mydata1$year<=2007),] ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1[which(mydata1$year<=2007),] ,na.action = na.omit)


stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "Dss Table VI with Lerner Index",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          #omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("Lerner","$\\Delta FF X Lerner$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          column.labels   = c("Full Sample)", "Pre-ZLB"),
          column.separate = c(2, 2),
          out = "results/Wide/table5.text",
          omit.stat = c("adj.rsq","ser"))



#-------------------------------
# Table 6: DSS Table VII. Sample Sensitivity with County Controls
#-------------------------------
#Choose sample
table7_data = mydata_c


table7_2004 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2004),] ,na.action = na.omit)

table7_2005 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2005),] ,na.action = na.omit)

table7_2006 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2006),] ,na.action = na.omit)

table7_2007 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2007),] ,na.action = na.omit)

table7_2008 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2008),] ,na.action = na.omit)

stargazer(table7_2004, table7_2005, table7_2006, table7_2007,table7_2008,
          type = "text",
          title= "DSS Table VII. Sample Sensitivity with County Controls (row 1)",
          model.numbers= T,
          column.labels = c("2004", "2005","2006","2007","2008"),
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County-time f.e.", "Y", "Y", "Y","Y","Y")),
          omit = c("Dl_hpi","Dl_pop","Dl_inc"),
          covariate.labels = c("$\\Delta FF X County-HHI$","County-HHI"),
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Wide/table6_a.text",
          omit.stat = c("adj.rsq","ser"))

table7_2009 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2009),] ,na.action = na.omit)

table7_2010<- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                   + Dl_hpi +Dl_pop+Dl_inc
                   | fips + year + fipszero  | 0 | fips ,
                   data = table7_data[which(table7_data$year<=2010),] ,na.action = na.omit)

table7_2011 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2011),] ,na.action = na.omit)

table7_2012 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2012),] ,na.action = na.omit)

table7_2013 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                    + Dl_hpi +Dl_pop+Dl_inc
                    | fips + year + fipszero  | 0 | fips ,
                    data = table7_data[which(table7_data$year<=2013),] ,na.action = na.omit)

stargazer(table7_2009, table7_2010, table7_2011, table7_2012,table7_2013,
          type = "text",
          title= "DSS Table VII. Sample Sensitivity with County Controls (row 2)",
          model.numbers= T,
          column.labels = c("2009", "2010","2011","2012","2013"),
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "Y","Y","Y"),
                           c("County-time f.e.", "Y", "Y", "Y","Y","Y")),
          omit = c("Dl_hpi","Dl_pop","Dl_inc"),
          covariate.labels = c("$\\Delta FF X County-HHI$","County-HHI"),
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out =  "results/Wide/table6_b.text",
          omit.stat = c("adj.rsq","ser"))



#=========================================================================
#         Appendix - Section B.3 - Additional tables for wide replication
#==========================================================================

#---------------------------------------------------------------------
#  Table B.10: Table VI Dropping credit card banks only in 2008
#--------------------------------------------------------------------
#sample
mydata1 = mydata_ecredit_2008 

#Choose monetary policy 
mydata1$mp = mydata1$d1_fftar_yearend

#Bank competition
mydata1$Comp = mydata1$herfdepcty


table6_1 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp 
                 | bankid + year + fips + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | bankid + year + fips + fipszero | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "DSS Table VI. Dropping Credit Card Banks",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          #omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("Bank-HHI$","$\\Delta FF X Bank-HHI$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          #out = "results/Appendix/tableB10:.text",
          omit.stat = c("adj.rsq","ser"))

#-------------------------------------------
# Table B.11: Table Lerner index Dropping credit card banks
#-------------------------------------------

#Choose sample
mydata1 = mydata_ecredit

#Choose monetary policy 
mydata1$mp = mydata1$d1_fftar_yearend

#Bank Competition
mydata1$Comp = mydata1$Lerner.l1


table6_1 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1 ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ mp:Comp + Comp 
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = mydata1[which(mydata1$year<=2007),] ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ mp:Comp + mp:avgherfdepcty + Comp  
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = mydata1[which(mydata1$year<=2007),] ,na.action = na.omit)


stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "DSS Table VI. With Lerner Index. Dropping Credit Card Banks",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          #omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("Lerner","$\\Delta FF X Lerner$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          column.labels   = c("Full Sample)", "Pre-ZLB"),
          column.separate = c(2, 2),
          out = "results/Appendix/tableB11.text",
          omit.stat = c("adj.rsq","ser"))

