rm(list=ls())

setwd("")

library(utils) #for save.csv
library(data.table) #importing from the web using fread
library(foreign) #read.dta, inport data
library(tidyr) #unite and separate paste0
library(lfe) #for lm with fixed effect (felm)
library(readstata13) #read dta files writen in STATa13
library(stargazer) 
library(zoo) #as.yearqtr
library(psych) #describe
library(tictoc)

#=========================================================================
#         Appendix - Section B.1 - Narrow replication with DSS data
#==========================================================================

#***************************
#**  TABLE 1, PANEL A  */
#**************************
table3_data = read.dta13("data/DSS_Data/sample_flows.dta") 
table3_data = table3_data[which(table3_data$year<=2013),]  

table3_data = table3_data[order(table3_data$fips),]

avgherfdepcty = read.dta13("data/DSS_Data/avgherfdepcty.dta")
table3_data <- merge(table3_data,avgherfdepcty,by = c("fips"),all=F)

table3_data = table3_data[order(table3_data$fips),]

fips_char = read.dta13("data/DSS_Data/fips_char.dta")
table3_data <- merge(table3_data,fips_char,by = c("fips"),all=F)

table1_a = table3_data[which(table3_data$year==2000),]
table1_a = table1_a[complete.cases(table1_a$pop_2000_over65,table1_a$pop_2000_ba,
                                   table1_a$medinc_1999,table1_a$avgherfdepcty),]
table1_a = table1_a[!duplicated(table1_a$fips),]

table1_a= subset(table1_a,select = c(medinc_1999,pop_2000_over65,pop_2000_ba,avgherfdepcty))
table1_a_low = table1_a[which(table1_a$avgherfdepcty<median(table1_a$avgherfdepcty)),]
table1_a_high = table1_a[which(table1_a$avgherfdepcty>=median(table1_a$avgherfdepcty)),]

panel_a=cbind.data.frame(as.data.frame(describe(table1_a,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                 check=F))[,c(2,3,4)],
as.data.frame(describe(table1_a_low,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                          check=F))[,c(2,3,4)],
as.data.frame(describe(table1_a_high,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                          check=F))[,c(2,3,4)])

rownames(panel_a) = c("Median Income","Over 65","College degree","Branch-HHI")

stargazer(panel_a, 
          type = "text",
          title = "DSS Descriptive Statistics (Table I panel a)",
          summary = F,
          covariate.labels=c("","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev."),
          column.labels   = c("All", "Low HHI","High HHI"),
          column.separate = c(3,3,3),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Narrow1/DSS table 1 panel a.text",
          digits = 2)

#***************************
#**  PREPARE FLOW REGS  *
#**************************

table3_data$d1_fftar_avgherfdepcty=table3_data$d1_fftar*table3_data$avgherfdepcty
table3_data$d1_fftar_age=table3_data$d1_fftar*(table3_data$pop_2000_over65/100)
table3_data$d1_fftar_income=table3_data$d1_fftar*table3_data$lnmedic1999
table3_data$d1_fftar_edu_hs=table3_data$d1_fftar*(table3_data$pop_2000_highschool/100)
table3_data$d1_fftar_edu_ba=table3_data$d1_fftar*(table3_data$pop_2000_ba/100)

table3_data$zerolower = ifelse(table3_data$year>=2010,1,0)

table3_data$fipszero =as.numeric(paste0(table3_data$fips,table3_data$zerolower))

table3_data = table3_data[complete.cases(table3_data$d1_lndep,table3_data$d1_fftar_avgherfdepcty),]


#************************
#**  TABLE 1, PANEL B 
#*************************
table3_data$depsumbr_mil = table3_data$depsumbr/1000
table1_b= subset(table3_data,select = c(depsumbr_mil,d1_lndep,d1_fftar,avgherfdepcty))
table1_b_low = table1_b[which(table1_b$avgherfdepcty<median(table1_b$avgherfdepcty)),]
table1_b_high = table1_b[which(table1_b$avgherfdepcty>=median(table1_b$avgherfdepcty)),]

panel_b=cbind.data.frame(as.data.frame(describe(table1_b,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_b_low,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_b_high,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)])

rownames(panel_b) = c("Deposits","Deposits growth","Change FF","Branch-HHI")

stargazer(panel_b, 
          type = "text",
          title = "DSS Descriptive Statistics (Table I panel b)",summary = F
          ,covariate.labels=c("","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev."),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Narrow1/DSS table 1 panel b.text",
          digits = 2)

#**********************
#**      TABLE 3     **
#**********************
tic()
table3_4 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |styear+fips+fipszero+uninumbr| 0 | fips,
                 data = table3_data ,na.action = na.omit)


table3_5 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |year+fips+fipszero+uninumbr| 0 | fips,
                 data = table3_data ,na.action = na.omit)

table3_6 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |year+fips+fipszero| 0 | fips,
                 data = table3_data ,na.action = na.omit)

table3_data_a = table3_data[which(table3_data$tot_fips_year>1),]

table3_1 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |bankyear+styear+uninumbr+fips+fipszero| 0 | fips,
                 data = table3_data_a ,na.action = na.omit)

table3_2 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |bankyear+fips+fipszero+uninumbr| 0 | fips,
                 data = table3_data_a ,na.action = na.omit)

table3_3 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty
                 |year+fips+fipszero| 0 | fips,
                 data = table3_data_a ,na.action = na.omit)
toc()

stargazer(table3_1,table3_2,table3_3,table3_4,table3_5,table3_6,
          type = "text",
          title= "DSS TABLE III", model.numbers= T,
          add.lines = list(c("Bank x year f.e.", "Y", "Y", "N","N", "N","N"),
                           c("State x year f.e.", "Y", "N", "N","Y", "N","N"),
                           c("Branch f.e.", "Y", "Y", "N","Y", "Y","N"),
                           c("County f.e.", "Y", "Y", "Y","Y", "Y","Y"),
                           c("Year f.e.", "Y", "Y", "Y","Y", "Y","Y")),
          dep.var.labels.include = FALSE,
          dep.var.caption = c("$\\Delta log Deposits$"),
          column.labels   = c("$\\geq$ 2 Counties", "All"),
          column.separate = c(3, 3),
          covariate.labels = c("$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS table 3.text",
          omit.stat = c("adj.rsq","ser"))


#*************************
#** TABLE 5, PANEL B    ** 
#*************************
table5_data = read.dta13("data/DSS_Data/sample_flows.dta") 

table5_data = table5_data[which(table5_data$year<=2013),]

table5_data = table5_data[order(table5_data$fips),]

avgherfdepcty = read.dta13("data/DSS_Data/avgherfdepcty.dta")
table5_data <- merge(table5_data,avgherfdepcty,by = c("fips"),all=F)

table5_data = table5_data[order(table5_data$fips),]

fips_char = read.dta13("data/DSS_Data/fips_char.dta")
table5_data <- merge(table5_data,fips_char,by = c("fips"),all=F)

table5_data$d1_fftar_avgherfdepcty=table5_data$d1_fftar*table5_data$avgherfdepcty
table5_data$d1_fftar_age=table5_data$d1_fftar*(table5_data$pop_2000_over65/100)
table5_data$d1_fftar_income=table5_data$d1_fftar*table5_data$lnmedic1999
table5_data$d1_fftar_edu_hs=table5_data$d1_fftar*(table5_data$pop_2000_highschool/100)
table5_data$d1_fftar_edu_ba=table5_data$d1_fftar*(table5_data$pop_2000_ba/100)

table5_data$zerolower = ifelse(table5_data$year>=2010,1,0)

table5_data$fipszero =as.numeric(paste0(table5_data$fips,table5_data$zerolower))

data_table5 = table5_data[complete.cases(table5_data$d1_lndep,table5_data$d1_fftar_avgherfdepcty,
                                   table5_data$d1_fftar_age, table5_data$d1_fftar_income,
                                   table5_data$d1_fftar_edu_ba),]  

styear_count <- aggregate(x = data_table5$styear, by = list(unique.values = data_table5$styear), FUN = length)
styear_count1 = styear_count[which(styear_count$x >= 2),]
data_table5 = data_table5[which(data_table5$styear %in% styear_count1$unique.values),]

fips_count <- aggregate(x = data_table5$fips, by = list(unique.values = data_table5$fips), FUN = length)
fips_count1 = fips_count[which(fips_count$x >= 2),]
data_table5 = data_table5[which(data_table5$fips %in% fips_count1$unique.values),]

fipszero_count <- aggregate(x = data_table5$fipszero, by = list(unique.values = data_table5$fipszero), FUN = length)
fipszero_count1 = fipszero_count[which(fipszero_count$x >= 2),]
data_table5 = data_table5[which(data_table5$fipszero %in% fipszero_count1$unique.values),]

uninumbr_count <- aggregate(x = data_table5$uninumbr, by = list(unique.values = data_table5$uninumbr), FUN = length)
uninumbr_count1 = uninumbr_count[which(uninumbr_count$x >= 2),]
data_table5 = data_table5[which(data_table5$uninumbr %in% uninumbr_count1$unique.values),]

tic()
table5_1 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty +d1_fftar_age
                 |styear+fips+fipszero+uninumbr| 0 | fips,
                 data = data_table5 ,na.action = na.omit)

table5_2 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty +d1_fftar_income
                 |styear+fips+fipszero+uninumbr| 0 | fips,
                 data = data_table5 ,na.action = na.omit)

table5_3 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty +d1_fftar_edu_ba
                 |styear+fips+fipszero+uninumbr| 0 | fips,
                 data = data_table5 ,na.action = na.omit)

table5_4 <- felm(d1_lndep ~ d1_fftar_avgherfdepcty +d1_fftar_age+d1_fftar_income+d1_fftar_edu_ba
                 |styear+fips+fipszero+uninumbr| 0 | fips,
                 data = data_table5 ,na.action = na.omit)
toc()

stargazer(table5_1,table5_2,table5_3,table5_4,
          type = "text",
          title= "DSS TABLE V Panel B",
          model.numbers= T,
          add.lines = list(c("All f.e.", "Y", "Y", "Y","Y")),
          #omit = c("herfdepcty"),
          dep.var.labels.include = FALSE,
          dep.var.caption = c("$\\Delta log Deposits$"),
          covariate.labels = c("$\\Delta FF X Branch-HHI$",
                               "$\\Delta FF X Age$",
                               "$\\Delta FF X Income$",
                               "$\\Delta FF X College$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS table5 panel B.text",
          omit.stat = c("adj.rsq","ser"))

#*************************
#*** Table 1, Panel E  ***
#*************************
table6_data = read.csv("data/mydata_loan.csv")

table6_data$assets_2010_bil=table6_data$assets_2010/1000000
table1_e= subset(table6_data,select = c(tot_amt_2010,log_tot_amt,assets_2010_bil,herfdepcty))
table1_e$tot_amt_2010 = table1_e$tot_amt_2010/1000 
table1_e_low = table1_e[which(table1_e$herfdepcty<median(table1_e$herfdepcty)),]
table1_e_high = table1_e[which(table1_e$herfdepcty>=median(table1_e$herfdepcty)),]

panel_e=cbind.data.frame(as.data.frame(describe(table1_e,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_e_low,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_e_high,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)])

rownames(panel_e) = c("New lending (mill)","New lending (log)","Assets","Bank-HHI")

stargazer(panel_e, 
          type = "text",
          title = "DSS Descriptive Statistics (Table I panel e)",summary = F
          ,covariate.labels=c("","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev."),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Narrow1/DSS table 1 panel e.text",
          digits = 2)

#***********************
#**      Table 6      **
#***********************
table6_data$hhi = table6_data$herfdepcty 

table6_1 <- felm(log_tot_amt ~ d1_ffm_herfdepcty + hhi #+ avgherfdepcty
                 | fipsyear +  fipsbank + bankid + year + fipszero  | 0 | bankid + fips ,
                 data = table6_data ,na.action = na.omit)

table6_2 <- felm(log_tot_amt ~ d1_ffm_herfdepcty + d1_ffm_avgherfdepcty + hhi #+ avgherfdepcty 
                 | fipsbank + bankid + year + fipszero + fips  | 0 | bankid + fips ,
                 data = table6_data ,na.action = na.omit)

table6_3 <- felm(log_tot_amt ~ d1_ffm_herfdepcty + d1_ffm_avgherfdepcty + hhi 
                 | bankid + year + fips + fipszero  | 0 | bankid + fips ,
                 data = table6_data ,na.action = na.omit)

table6_4 <- felm(log_tot_amt ~ d1_ffm_herfdepcty + hhi 
                 | bankid + year + fips + fipszero | 0 | bankid + fips ,
                 data = table6_data ,na.action = na.omit)


stargazer(table6_1, table6_2, table6_3, table6_4,
          type = "text",
          title= "DSS TABLE VI",
          model.numbers= T,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y","Y"),
                           c("Bank f.e.", "Y", "Y", "Y","Y"),
                           c("County f.e.", "Y", "Y", "Y","Y"),
                           c("County-bank f.e.", "Y", "Y", "N","N"),
                           c("County-time f.e.", "Y", "N", "N","N")),
          omit = "hhi",
          dep.var.labels.include = FALSE,
          dep.var.caption = c("log (new lending)"),
          covariate.labels = c("$\\Delta FF X Bank-HHI$","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS table 6.text",
          omit.stat = c("adj.rsq","ser"))

#**********************
#       Table 7      **
#**********************

table7_data = read.csv("data/mydata_county.csv")

table7_1 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_2 <- felm(log_tot_amt ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_3 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_4 <- felm(d1_lnemp ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_5 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

table7_6 <- felm(d1_lntotwage ~ d1_ffm_herfdepcty_amt + herfdepcty_amt + d1_ffm_avgherfdepcty 
                 | fips + year + fipszero  | 0 | fips ,
                 data = table7_data ,na.action = na.omit)

stargazer(table7_1, table7_2,table7_3, table7_4,table7_5, table7_6,
          type = "text",
          title= "DSS Table VII",
          dep.var.caption  = "", model.numbers= T,
          dep.var.labels.include = FALSE,
          add.lines = list(c("Time f.e.", "Y", "Y", "Y", "Y", "Y", "Y"),
                           c("County f.e.", "Y", "Y", "Y", "Y", "Y", "Y")),
          covariate.labels = c("$\\Delta FF X County-HHI$","County-HHI","$\\Delta FF X Branch-HHI$"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS table 7.text",
          column.labels   = c("log(new lending)", "\\Delta Employment","\\Delta Wage Bill"),
          column.separate = c(2, 2, 2),
          omit.stat = c("adj.rsq","ser"))

#*************
#** Table 8 **
#*************
table8 = read.dta13("data/DSS_Data/sample_call_final.dta") 

table8 = table8[order(table8$cert),]
table8 = table8[order(table8$quar),]

cert_branches = read.dta13("data/DSS_Data/sample_flows.dta") 
cert_branches = cert_branches[which(cert_branches$year<=2013),]
cert_branches<-setDT(cert_branches)[, .(branches = length(unique(depsumbr))), by = c("cert","year")]
cert_branches=setDT(cert_branches)[, .(branches=mean(branches)), by = c("cert")]
cert_branches = cert_branches[order(cert_branches$cert),]
table8 <- merge(table8,cert_branches,by = c("cert"),all=F)

table8 = table8[order(table8$cert,table8$quar),]

table8 = data.table(table8)
table8[,l1.assets := shift(assets), by = c("cert")]

table8$change_assets = (table8$assets-table8$l1.assets)/table8$l1.assets
table8 = table8[complete.cases(table8$change_assets),]
table8$mergercontrol2 = ifelse(table8$change_assets>1,1,0)

table8 = table8[which(table8$change_assets != 1),]

table8$zerolower = ifelse(table8$year>=2009,1,0)

table8$certzero =as.numeric(paste0(table8$cert,table8$zerolower))

table8 = table8[which(table8$year>=1994 & table8$year<=2013),]


table8 = table8[complete.cases(table8$d1_totdep,table8$d1_transdep,table8$d1_assets,table8$d1_timedepg100k,table8$d1_wholesale,
                               table8$d1_timedep,table8$d1_spread_tot,table8$d1_savdep,table8$d1_cash,table8$d1_securities,
                               table8$d1_reloans,table8$d1_ciloansother,table8$d1_persloans,table8$d1_otherassets,table8$d1_loans,
                               table8$d1_totliab,table8$d1_nondep,l1_herfdepcty),]


table8_1 <- felm(d1_totdep ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)
table8_2 <- felm(d1_spread_tot ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)
table8_3 <- felm(d1_savdep ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)
table8_4 <- felm(d1_timedep ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)
table8_5 <- felm(d1_wholesale ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)
table8_6 <- felm(d1_totliab ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                 |cert+quar+certzero| 0 | cert,
                 data = table8 ,na.action = na.omit)

stargazer(table8_1,table8_2,table8_3,table8_4,table8_5,table8_6,
          type = "text",
          title= "DSS Table VIII (panel a)",
          dep.var.caption  = "", model.numbers= T,
          dep.var.labels.include = FALSE,
          add.lines = list(c("Bank f.e.", "Y", "Y", "Y","Y", "Y","Y"),
                           c("Quarter f.e.", "Y", "Y", "Y","Y", "Y","Y")),
          #omit = c("herfdepcty"),
          covariate.labels = c("$\\Delta FF X Bank-HHI$","Bank-HHI"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS Table 8a.text",
          column.labels   = c("\\Delta Total deposits", "\\Delta Deposit spread","\\Delta Savings deposits",
                              "\\Delta Time deposits", "\\Delta Wholesale funding","\\Delta Total liabilities"),
          omit.stat = c("adj.rsq","ser"))

table8_1b <- felm(d1_assets ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)
table8_2b <- felm(d1_cash ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)
table8_3b <- felm(d1_securities ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)
table8_4b <- felm(d1_loans ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)
table8_5b <- felm(d1_reloans ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)
table8_6b <- felm(d1_ciloansother ~ d1_ff_l1_herfdepcty+l1_herfdepcty
                  |cert+quar+certzero| 0 | cert,
                  data = table8 ,na.action = na.omit)

stargazer(table8_1b,table8_2b,table8_3b,table8_4b,table8_5b,table8_6b,
          type = "text",
          title= "DSS Table VIII (panel b)",
          dep.var.caption  = "", model.numbers= T,
          dep.var.labels.include = FALSE,
          add.lines = list(c("Bank f.e.", "Y", "Y", "Y","Y", "Y","Y"),
                           c("Quarter f.e.", "Y", "Y", "Y","Y", "Y","Y")),
          #omit = c("herfdepcty"),
          covariate.labels = c("$\\Delta FF X Bank-HHI$","Bank-HHI"),
          df = FALSE, notes.align = "l", digits = 3,no.space=TRUE,
          out = "results/Narrow1/DSS Table 8b.text",
          column.labels   = c("\\Delta Total deposits", "\\Delta Deposit spread","\\Delta Savings deposits",
                              "\\Delta Time deposits", "\\Delta Wholesale funding","\\Delta Total liabilities"),
          omit.stat = c("adj.rsq","ser"))

#********************************************
#** Summary statistics  -- Table 1, Panel D *
#********************************************
table8$assets_mil=table8$assets/1000
table8$totdep_l=(table8$totdep/table8$totliab)*100
table1_d= subset(table8,select = c(assets_mil,totdep_l,branches,l1_herfdepcty))
table1_d_low = table1_d[which(table1_d$l1_herfdepcty<median(table1_d$l1_herfdepcty)),]
table1_d_high = table1_d[which(table1_d$l1_herfdepcty>=median(table1_d$l1_herfdepcty)),]

panel_d=cbind.data.frame(as.data.frame(describe(table1_d,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_d_low,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)],
                         as.data.frame(describe(table1_d_high,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(2,3,4)])

rownames(panel_d) = c("Assets (mill)","Deposits/Liab.","Branches","Bank-HHI")

stargazer(panel_d, 
          type = "text",
          title = "DSS Descriptive Statistics (Table I panel d)",summary = F
          ,covariate.labels=c("","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev.","Obs.","Mean","Std. dev."),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Narrow1/DSS table 1 panel d.text",
          digits = 2)



