rm(list=ls())

library(foreign) #read.csv, inport data
library(lfe) #for lm with fixed effect (felm)
library(stargazer) #export results
library(data.table) #importing from the web using fread
library(ggplot2) #Plot 
library(ggpubr) #for ggarrange
library(reshape2)

#set working directory to folder location
setwd("")


#**********************#
#    Data - Bank level
#**********************#
#1. Baseline (loan level) 
mydata = read.csv("data/mydata_loan.csv") 
mydata  = do.call(data.frame,lapply(mydata , function(x) replace(x, is.infinite(x),NA)))
mydata  = do.call(data.frame,lapply(mydata , function(x) replace(x, is.nan(x),NA)))


banks = c(30810,112855,486752,489913,1830035,2253891,2582023,1417557)
mydata$credit_bank = ifelse(mydata$bankid %in% banks,1,0)
mydata$credit_bank = ifelse(mydata$year>=2004 & mydata$bankid==688079,1,mydata$credit_bank)


#----------------
#   Figure 1
#----------------
agg_both = setDT(mydata)[,.(log_tot_amt = log(sum(tot_amt)),
                            d1_ffm_herfdepcty = weighted.mean(d1_ffm_herfdepcty,tot_amt)),by=c("year","credit_bank")]
agg_both$Bank = ifelse(agg_both$credit_bank==1,"Credit Card ","Retail")
agg_both2 = agg_both[which(agg_both$year  %in% c(2008)),]

g1 = ggplot(agg_both, aes(x=d1_ffm_herfdepcty, y=log_tot_amt, colour = Bank)) + # 
  geom_point(aes(shape=Bank), size=2.5)+
  geom_point(data=agg_both2, aes(x=d1_ffm_herfdepcty, y=log_tot_amt, colour = Bank),colour="black",pch=7,size=4)+
  theme_bw(base_size = 12)+
  geom_smooth(method=lm, se=FALSE)+
  theme(legend.position = "none")+
  labs(
    title = "Full sample (1997-2013)",
    x = "Change FF X Bank-HHI", y = "log(total new lending)")+
  scale_color_manual(values=c("Blue","Red"))

agg_both1 = agg_both[which(agg_both$year!=2008),]
g2 = ggplot(agg_both1, aes(x=d1_ffm_herfdepcty, y=log_tot_amt, colour = Bank)) + # 
  geom_point(aes(shape=Bank), size=2.5)+
  theme_bw(base_size = 12)+
  geom_smooth(method=lm, se=FALSE)+
  #geom_smooth()+
  theme(legend.position = "none")+
  labs(
    title = "Excluding 2008",
    x = "Change FF X Bank-HHI", y = "log(total new lending)")+
  scale_color_manual(values=c("Blue","Red"))

ggarrange(g1,g2, ncol=2, nrow=1, common.legend = T,
          labels = c("A.","B."),legend = "bottom")

ggsave(file="results/Figures/Figure1.png",
       width = 18, height = 9, units = "cm")

#---------------
#   Figure B.1
#---------------
agg_n = setDT(mydata)[,.(loans = .N),by=c("year","credit_bank")]
agg_n_wide = dcast(agg_n,year~credit_bank,value.var = "loans")
colnames(agg_n_wide) = c("year","Retail","Credit")
agg_n_wide$share = (agg_n_wide$Credit/(agg_n_wide$Retail+agg_n_wide$Credit))

agg_n$`Bank type` = ifelse(agg_n$credit_bank==1,"Credit Card","Retail")
g1 = ggplot(agg_n, aes(x=year, y=loans, colour = `Bank type`)) + 
  geom_line(size=1.2,aes(linetype =`Bank type`))+
  theme_bw(base_size = 12)+
  labs(
    x = "", y = "Number of bank-county obs.")+
  scale_color_manual(values=c("Blue","Red"))+
  annotate("rect", fill = "gray0", alpha = 0.1, 
           xmin = 2008, xmax = 2009 + 6/12,
           ymin = -Inf, ymax = Inf)+
  scale_x_continuous(breaks = seq(1996, 2013, by = 2))

agg_loans = setDT(mydata)[,.(tot_amt = sum(tot_amt)),by=c("year","credit_bank")]
agg_loans$tot_amt = agg_loans$tot_amt/1000000 
agg_loans$credit_bank = as.character(agg_loans$credit_bank)
agg_loans$`Bank type` = ifelse(agg_loans$credit_bank=="1","Credit Card","Retail")
g2 = ggplot(agg_loans, aes(x=year, y=tot_amt, colour = `Bank type`)) + 
  geom_line(size=1.2,aes(linetype =`Bank type`))+
  theme_bw(base_size = 12)+
  labs(x = "", y = "Total New lending (Billion)")+
  scale_color_manual(values=c("Blue","Red"))+
  annotate("rect", fill = "gray0", alpha = 0.1, 
           xmin = 2008, xmax = 2009 + 6/12,
           ymin = -Inf, ymax = Inf)+
  scale_x_continuous(breaks = seq(1996, 2013, by = 2))

ggarrange(g1,g2, ncol=2, nrow=1, 
          common.legend = T,labels = c("A.","B."),legend = "bottom")

ggsave(file="results/Figures/FigureB1.png",
       width = 18, height = 9, units = "cm")

#--------------------------------------------------------------------
#    Table B.9: Credit Card vs. Retail Banks Descriptive Statistics
#--------------------------------------------------------------------
#Number of Branches
table = read.dta13("data/DSS_Data/sample_call_final.dta") 
cert_branches = read.dta13("data/DSS_Data/sample_flows.dta") 
cert_branches = cert_branches[which(cert_branches$year<=2013),]
cert_branches<-setDT(cert_branches)[, .(branches = length(unique(depsumbr))), by = c("cert","year")]
table <- merge(table,cert_branches,by = c("cert","year"),all=F)

table$assets_mil=table$assets/1000
table$totdep_l=(table$totdep/table$totliab)*100
table1= subset(table,select = c(bankid,year,assets_mil,totdep_l,branches,herfdepcty))

banks = c(30810,112855,486752,489913,1830035,2253891,2582023,1417557)
table1$credit_bank = ifelse(table1$bankid %in% banks,1,0)
table1$credit_bank = ifelse(table1$year>=2004 & table1$bankid==688079,1,table1$credit_bank)

table2 = table1[which(table1$bankid %in% mydata$bankid & table1$year>=1997 & table1$year<=2013),]
length(unique(table2$bankid))
table2_a = table2[which(table2$credit_bank==0),]
length(unique(table2_a$bankid))
table2_b = table2[which(table2$credit_bank==1),]

table3_a= subset(table2_a,select = c(assets_mil,totdep_l,branches,herfdepcty))
table3_b= subset(table2_b,select = c(assets_mil,totdep_l,branches,herfdepcty))

table4=cbind.data.frame(as.data.frame(describe(table3_a,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(3,4,5)],
                         as.data.frame(describe(table3_b,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(3,4,5)])

rownames(table4) = c("Assets (mill)","Deposits/Liab.","Branches","Bank-HHI")

stargazer(table4, 
          #type = "text",
          title = "Descriptive Statistics - credit card vs. retail banks",summary = F
          ,covariate.labels=c("","Mean","Std. dev.","Median","Mean","Std. dev.","Median"),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Appendix/tableB9.text",
          digits = 2)





table3_b= subset(table2_b,select = c(assets_mil,totdep_l,branches,herfdepcty))

table4=cbind.data.frame(as.data.frame(describe(table3_a,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(3,4,5)],
                         as.data.frame(describe(table3_b,skew = TRUE,na.rm = TRUE, interp = FALSE, ranges = TRUE,trim=0,
                                                check=F))[,c(3,4,5)])

rownames(table4) = c("Assets (mill)","Deposits/Liab.","Branches","Bank-HHI")

stargazer(table4, 
          #type = "text",
          title = "Descriptive Statistics - credit card vs. retail banks",summary = F
          ,covariate.labels=c("","Mean","Std. dev.","Median","Mean","Std. dev.","Median"),
          flip = FALSE,no.space=TRUE,rownames = T,
          notes.align = "l",
          out = "results/Appendix/Descriptive.text",
          digits = 2)




