********************************************************************************
*                               MasterAHS.do                                   *
********************************************************************************

version 15.1

* install extra commands needed to run the code (produce tables and graphs)
cap ssc install estout
cap ssc install plotplainblind

clear all
set more off
*set scheme plottig  /* for presentation */
set scheme plotplain /* for paper */
set seed 101257     
  /* for exact replication of parts that use random number generators, regardless of run */
  /* seed is part of the DOI for Ngai and Tenreyro's 2014 article */
  /* somehow, this does not make the imputed datasets perfectly reproducible, unfortunately */
  /* in particular, after imputing values the seed is not always in the same position */

/* Set parent directory:
parent directory should contain the following directories:
> programs
> results
> data
  > AmericanHousingSurveyData
    > RawData
*/

/* 

The following data files should be in the RawData folder:

AHS 1999 National PUF v1.1 Flat CSV.zip
AHS 2001 National PUF v1.1 Flat CSV.zip
AHS 2003 National PUF v1.1 Flat CSV.zip
AHS 2005 National PUF v1.1 Flat CSV.zip
AHS 2007 National PUF v1.1a Flat CSV.zip
AHS 2009 National PUF v1.1 Flat CSV.zip
AHS 2011 National PUF v2.0 Flat CSV.zip
AHS 2002 Metropolitan PUF v1.1 Flat CSV.zip
AHS 2004 Metropolitan PUF v1.1 Flat CSV.zip
AHS 2007 Metropolitan PUF v1.1 Flat CSV.zip
AHS 2009 Metropolitan PUF v1.1 Flat CSV.zip
AHS 2011 Metropolitan PUF v2.0 Flat CSV.zip

*/
	
cap cd "G:/My Drive/research/HotColdReplication/"

global parent = c(pwd)
global programs = "$parent/programs/"

* number of imputations:
global M = 10


cap log close
log using "results/MasterAHS.txt", text replace
 
cd "Data/AmericanHousingSurveyData/"

********************************************************************************

local start = c(current_time)

* uncomment to read the data from raw source into stata format
* include "$programs/ReadAHSData"

local first = c(current_time)

cd "$parent/results"

include "$programs/AnalyzeAHSDataMultipleImputation"  // main analysis file

local second = c(current_time)


di "`start'"
di "`first'"
di "`second'"
di c(current_time)

log close
