*******************************************************************************
* C. Impute DURATION from EMPIRICAL Distribution:
/*
Assume that movm, move, pmovyr are correct ...
... impute pmovm by drawing at random from empirical distribution ...
... of durations, among durations that would ensure the original move ...
... is in the stated year (pmovyr)
*/

use `ForImputations', clear
drop in 1/L  // drops all observations, but keeps variables
save `gather_all_groups'

foreach g of numlist `group_levels' {
  use `ForImputations', clear
  keep if group_duration == `g'
  quietly sum m_d
  local min = r(mean)
  quietly sum M_d
  local max = r(mean)
  local n_g = _N
  
  save `tempgroup', replace
  
  use `durations', clear
  keep if inrange(duration_imp , `min', `max')
  cap bsample `n_g'        
  // ... sample from empirical distribution of durations that are feasible
  merge 1:1 _n using `tempgroup', nogen
  
  append using `gather_all_groups'
  save `gather_all_groups', replace

}
 
use `gather_all_groups', clear



replace duration = duration_imp if ( pmovm == 1 & imputation_random > `imp_fraction' & m > 0 ) 
replace pmovm = month(dofm(ym(move,movm) - duration ))
replace summer = inrange(pmovm ,4,9)

* end of imputation step (C)
*******************************************************************************