*******************************************************************************
* B. Impute PMOVM from UNIFORM Distribution:
/*
Assume that movm, move, pmovyr are correct ...
... impute pmovm from uniform distribution ...
... and reimpute where imputed pmovm places prior move after current move 
*/

use `ForImputations', clear

replace pmovm = ceil(runiform(0,12))  if pmovm == 1 & m > 0 & imputation_random > `imp_fraction'
count if ym(pmovyr,pmovm) > ym(move,movm)

* reimpute if newly imputed month is too late (which would mean that prior move happens after current move)
foreach maxmonth of numlist 11/1 {
  replace pmovm = ceil(runiform(0,`maxmonth')) if ym(pmovyr,pmovm) > ym(move,movm) & m > 0 & imputation_random > `imp_fraction'
  count if ym(pmovyr,pmovm) > ym(move,movm)
}

* end of imputation step (B)
*******************************************************************************