*******************************************************************************
* A. Impute PMOVM from EMPIRICAL Distribution:
/*
Assume that movm, move, pmovyr are correct ...
... impute pmovm ...
... and reimpute where imputed pmovm places prior move after current move 
*/

tempfile imputationA

use `ForImputations', clear

gen id = ceil(runiform(0,`Npmovm')) if imputation_random > `imp_fraction'
merge m:1 id using `pmovm', nogen
replace pmovm = pmovm_imp if pmovm == 1 & m > 0 & imputation_random > `imp_fraction'
count if ym(pmovyr,pmovm) > ym(move,movm)
local reversed = r(N)
* `reversed' counts observations whose imputed prior move is after the current move

while `reversed' > 0 {
    drop pmovm_imp
    save `imputationA', replace
	
	/*
	shorten up the file from which to draw imputed month
	 ... some imputations give a month that is too high (too late in the year)
	 ... and this causes the imputed prior move to happen after the current move
	 ... we progressively shorten the pmovm file, removing the available
	 ... months to impute from, starting with December and working down
	*/
	
	use `pmovm' , clear
	drop id
	quietly summarize pmovm_imp
	drop if pmovm_imp == r(max)
	gen id = _n
	local Npmovm = _N
	save `pmovm', replace
	
	use `imputationA' , clear
	
	* new draw from pmovm distribution:
	replace id = ceil(runiform(0,`Npmovm')) if (ym(pmovyr,pmovm) > ym(move,movm))
	merge m:1 id using `pmovm', nogen
    replace pmovm = pmovm_imp if (ym(pmovyr,pmovm) > ym(move,movm)) & (m > 0) & (imputation_random > `imp_fraction')
    count if ym(pmovyr,pmovm) > ym(move,movm)
    local reversed = r(N)
	di `reversed'
}

drop id pmovm_imp 
drop if mi(newid)

* end of imputation step (A)
*******************************************************************************