

use "$parent/data/original.dta" , clear

* controls to replicate column (5) from Ngai-Tenreyro 
local col5controls_bs "zinc per zadult i.region i.METRO3 "

local builtcontrols_bs = "zinc per zadult i.region built "


keep if inrange(duration,0,.)

cap drop bd* blc* br*

foreach v in bduration bran blcost {
	cap gen `v' = .
	cap gen `v'bs = .
	cap gen `v'2 = .
	cap gen `v'2bs = .
}

foreach y of numlist 1999 2001 2002 2003 2004 2005 2007 2009 2011 {
	quietly poisson duration summer `col5controls' if intyr == `y' [pw=weight], r
	
	quietly bootstrap _b[summer], size(5000) force : poisson duration summer `col5controls_bs' if intyr == `y' [pw=weight], r
	replace bduration = e(b)[1,1] if intyr == `y'
	replace bdurationbs = e(b_bs)[1,1] if intyr == `y'
	
	quietly poisson duration2 summer `col5controls' if intyr == `y' [pw=weight], r
	
	quietly bootstrap _b[summer], size(5000) force : poisson duration2 summer `col5controls_bs' if intyr == `y' [pw=weight], r
	replace bduration2 = e(b)[1,1] if intyr == `y'
	replace bduration2bs = e(b_bs)[1,1] if intyr == `y'
}

foreach y of numlist 1999 2001 2002 2003 2004 2005 2007 2009 2011 {

	quietly bootstrap _b[nsummer], size(1500) force : poisson ran nsummer `builtcontrols_bs' if intyr == `y' & tenure ==1  [pw=weight], r
	replace bran = e(b)[1,1] if intyr == `y'
	replace branbs = e(b_bs)[1,1] if intyr == `y'

	quietly bootstrap _b[nsummer], size(800) force : reg lcost nsummer `builtcontrols' if intyr == `y' & tenure ==1  [pw=weight], r
	replace blcost = e(b)[1,1] if intyr == `y'
	replace blcostbs = e(b_bs)[1,1] if intyr == `y'

}

collapse b* , by(intyr)

label var bduration "Months"
label var bdurationbs "Months (bootstrap, n=5000, reps=50)"
label var bduration2 "Years"
label var bduration2bs "Years ( bootstrap, n=5000, reps=50)"

label var bran "Replacements and Additions"
label var branbs "Replacements and Additions (bootstrap, n=1500, reps=50)"

label var blcost "Cost of Replacements and Additions"
label var blcostbs "Cost of Replacements and Additions (bootstrap, n=800, reps=50)"

tw connected bduration2 bduration2bs bduration bdurationbs intyr , lcolor(red red black black) lpattern(solid dash_dot solid dash_dot) msymbol(i i i i)  xti("Survey Year") legend(pos(12) ring(0) order(3 4 1 2)) yline(0) xlab(1999(2)2011)
graph export "$parent/results/bootstrap.pdf" , as(pdf) replace


tw scatter bduration2bs bduration2 , mcolor(black) text(0.045 0.05 "Years", color(black)) || scatter bdurationbs bduration, mcolor(red) text(0.0 -0.005 "Months", color(red)) legend(off) || function x , range(-.02 .06) lstyle(solid) xti(Original Estimate) yti(Bootstrapped Estimate)
graph export "$parent/results/bootscatter.pdf" , as(pdf) replace

tw connected bran branbs  intyr , lcolor(black ) lpattern(solid dash_dot ) msymbol(i i)  xti("Survey Year") legend(pos(12) ring(0) order(1 2)) yline(0) xlab(1999(2)2011)
graph export "$parent/results/bootstrapran.pdf" , as(pdf) replace

tw connected blcost blcostbs  intyr , lcolor(black ) lpattern(solid dash_dot ) msymbol(i i)  xti("Survey Year") legend(pos(5) ring(0) order(1 2)) yline(0) xlab(1999(2)2011)
graph export "$parent/results/bootstraplcost.pdf" , as(pdf) replace

sum
