******************************************************************************
* ANALYSIS, REGARDLESS OF WHICH IMPUTATION APPROACH

cap drop movedate pmovedate duration durationy summer

cap gen impflag = (pmovm==1 & m==0)

gen movedate = ym(move,movm)
gen pmovedate = ym(pmovyr,pmovm)
gen duration = movedate - pmovedate
 
gen durationy = move-pmovyr

gen summer = inrange(pmovm ,4, 9) if !mi(pmovm)
label var summer "Summer"

graph box duration, over(pmovm) noout

if "`imputation'"=="A" {
local titletext = "Prior Move Month Imputed from Empirical Distribution"
}
if "`imputation'"=="B" {
local titletext = "Prior Move Month Imputed from Uniform Distribution"
}
if "`imputation'"=="C" {
local titletext = "Duration Imputed from Empirical Distribution"
}


preserve
collapse (mean) duration durationy , by(pmovm m)
tw scatter duration pmovm if m == 0, mcolor(blue) msymbol(square_hollow)  msize(large) ysc(log) ///
  || scatter durationy pmovm if m == 0, mcolor(red)  msymbol(circle_hollow) msize(large) yaxis(2)  ysc(log)  ///
  || scatter duration pmovm if m > 0 , mcolor(blue) msymbol(smsquare) msize(small)  ///
  || scatter durationy pmovm if m >0 ,  mcolor(red) msymbol(smcircle) msize(small) yaxis(2) ///
  yti("Duration (months)", color(blue)) ///
  yti("Duration (years)", axis(2) color(red)) ///
  ti(`titletext') ///
  legend(off) ysc(axis(1) lcolor(blue)) ysc(axis(2) lcolor(red)) ///
  ylab( , labcolor(blue) tlcolor(blue)) ///
  ylab( , axis(2) labcolor(red) tlcolor(red)) ///
  xlab( $months ) xti("Prior Move Month") saving(imputed`imputation', replace) 
graph export pmovmscatter_imputed`imputation'.pdf, as(pdf) replace

restore

******************************************************************************
*  DURATION OF OCCUPANCY
******************************************************************************

* basic regression

save `imputed' , replace

********************************************************************************

replace pmovm = . if impflag==1   /* listwise deletion */
replace duration = . if impflag==1 
replace summer = . if impflag == 1

save `mi', replace

* Declaration of mi dataset
mi import flong , m(m) id(newid) imputed(duration pmovm summer )

save "$parent/data/miAHSForAnalysis.dta", replace

eststo sumstats`imputation' : mi estimate , post saving(sumstatsmi, replace) : mean duration durationy [pw=weight]

* use column (5) controls

eststo durationmmi`imputation' : mi estimate, post saving(durationmmi, replace) : poisson duration summer `col5controls' i.intyr [pw=weight] 
estadd local method = "`imputation'"
eststo durationymi`imputation' : mi estimate , post saving(durationymi, replace) : poisson durationy summer `col5controls' i.intyr [pw=weight]  
estadd local method = "`imputation'"


