******************************************************************************
*                 AnalyzeAHSDataMultipleImputation.do                        *
******************************************************************************

set more off
clear all
estimates clear
	
local shorten = 1
* use local shorten = 0 to run all regressions	
* use local shorten = 1 in order to skip some regressions later in the file
	
local controls = "zinc per zadult i.region i.intyr"

global months = `" 1 "Jan" 2 "Feb" 3 "Mar" 4 "Apr" 5 "May" 6 "Jun" 7 "Jul" 8 "Aug" 9 "Sep" 10 "Oct" 11 "Nov" 12 "Dec" "'

use "$parent/data/AmericanHousingSurveyData/AHSForAnalysis", clear

* drop Metropolitan Sample data to show that results are not due to metro/national differences
* keep if sampleflag == "NationalSample"

levelsof intyr , local(intyr_levels)

* Specify temp values for datasets etc.
tempfile original
tempfile results
tempfile imputed
tempfile pmovm
tempfile gather_all_groups
tempfile tempgroup
tempfile durations
tempfile ForImputations
tempfile mi
tempfile histmonthprior
tempfile histmonthcurrent
tempfile preimputation

tempname postresults


gen school = (schoth == 1 | schpri == 1 | schpub == 1)

label var movm "Month of Current Move"
label var pmovm "Month of Prior Move"
label var school "Kids in school"
label var built "(log) Year built"
label var zinc "(log) Income"
label var per "HH size"
label var zadult "Num. adults"

label var intyr "Survey Year"


* degree days, not collected in metropolitan sample; impute from CMSA
egen mode_degree = mode(degree), by(cmsa) 
gen degree_flag = (degree == . & mode_degree != .)
replace degree = mode_degree if degree == .

replace region = 1 if cmsa == 80 & region == .  // Providence-Pawtucket-Fall River, RI-MA
drop if region == .  // some observations have missing region information, cmsa is 99 (other) 

* missing values for move year and prior move year

* missing values:
mvdecode ran rac value pmovm pmovyr movm move sch* , ///
  mv(-6 = .a \ -7 = .b \ -8 = .c \ -9 = .d)

label define mv_lbl .a "Not reported" .d "Not applicable"

label values movm move pmovm pmovyr ran rac value mv_lbl   

keep control intyr movm move pmovm pmovyr region per zadult zinc weight tenure value built METRO3 degree smsa cmsa rac ran sch* sampleflag


gen movedate = ym(move,movm)
gen pmovedate = ym(pmovyr,pmovm)
gen duration = movedate - pmovedate
gen durationy = move-pmovyr
gen duration2 = durationy

gen summer = ( pmovm > 3 & pmovm < 10 ) if !mi(pmovm)
label var summer "Summer"

gen nsummer = ( movm > 3 & movm < 10 )  if !mi(movm)
label var nsummer "Summer"

* Indicate recent move:
gen recentmove = (intyr-move<=2)

* Cost share 
gen costshare = rac/value
gen lcost = log(costshare) if costshare <= 5000



/*
Referee 3 (J Applied Econometrics) suggests 
 -- to keep observations with missing income (as in Ngai and Tenreyro)
 -- to keep observations where priormove is recorded as subsequent to current move
 -- to not impute cmsa and heating-cooling degree days
*/
 
keep if !mi(zinc)

* eliminate observations where the prior move is recorded as subsequent to the current move
drop if ym(move,movm) < ym(pmovyr,pmovm) & !mi(pmovm) 



*gen school = (schoth == 1 | schpri == 1 | schpub == 1)

label var school "Kids in school"
label var built "(log) Year built"
label var zinc "(log) Income"
label var per "HH size"
label var zadult "Num. adults"

label var intyr "Survey Year"

label define month_lbl $months
label values pmovm month_lbl

* generate fraction of January observations to change in imputation_random
* make number of January and number of February moves equal in imputed data
count if pmovm==2 & recentmove==1
local feb = r(N)
count if pmovm==1 & recentmove==1
local jan = r(N)
local imp_fraction = 1-(12/11)*(1-`feb'/`jan')

********************************************************************************

note : "Original Data, after cleaning"
save `original', replace

note : "AHS data saved prior to analysis"
save "$parent/data/original.dta", replace


* note: since the following file uses a bootstrapping procedure, it advances the seed in Stata, and so affects subsequent analysis that use random numbers
* the following do file (bootstrapcommonsamplesize.do) does not contribute results to the published paper
preserve
*include "$programs/BootstrapCommonSampleSize.do"
restore

rm "$parent/data/original.dta"

summarize

********************************************************************************

********************************************************************************
* GRAPHS
********************************************************************************

tw scatter movm pmovm, jitter(5) msize(vtiny) note("Note: jittering applied") xsc(r(0 13)) xlab(2(3)11) ysc(r(0 13))  ylab(2(3)11)  xlab($months) ylab($months)


graph export "../results/scattercurrentpriormonth.pdf" , as(pdf) replace


hist pmovm, disc xsc(range(1 12)) xlabel($months) ///
  ti("Month of prior move") xti("") yline(`=1/12') saving(`histmonthprior', replace)
graph export "../results/histmonth.pdf", as(pdf) replace

hist movm if !mi(pmovm), disc xsc(range(1 12)) xlabel($months) ///
  ti("Month of current move") xti("") yline(`=1/12') saving(`histmonthcurrent' , replace)

graph export "../results/histmonthcurrentall.pdf", as(pdf) replace

graph combine "`histmonthprior'" "`histmonthcurrent'"
graph export "../results/histogramspriorcurrent.pdf" , as(pdf) replace
 
* Histograms of Move Month

hist pmovm, by(intyr) disc xsc(range(1 12)) xlabel($months) ///
  xti("Month of prior move") yline(`=1/12') 
graph export "../results/histmonthall.pdf", as(pdf) replace

hist movm if !mi(pmovm), by(intyr) disc xsc(range(1 12)) xlabel($months) ///
  xti("Month of current move") yline(`=1/12') 
graph export "../results/histmonthcurrentall.pdf", as(pdf) replace


preserve
collapse (mean) duration durationy , by(pmovm)
keep if !mi(pmovm)
tw scatter duration pmovm , mcolor(blue) ///
  || scatter durationy pmovm, mcolor(red) yaxis(2) ///
  yti("Duration (months)", color(blue)) ///
  yti("Duration (years)", axis(2) color(red)) ///
  legend(off) ysc(axis(1) lcolor(blue)) ysc(axis(2) lcolor(red)) ///
  ylab( , labcolor(blue) tlcolor(blue)) ///
  ylab( , axis(2) labcolor(red) tlcolor(red)) ///
  xlab( $months) xti("Prior Move Month")
graph export pmovmscatter.pdf, as(pdf) replace

restore

*/





********************************************************************************
* REGRESSIONS
********************************************************************************

/* 
  Regression on Original Data 
*/
  
********************************************************************************
*  DURATION OF OCCUPANCY
********************************************************************************

* basic regression

preserve
keep if  inrange(duration,0,.)   
// keep observations where current move is not before prior move

poisson duration summer  , r
poisson duration2 summer , r

local esttaboptions "tex nomti nodepvars se replace compress label nogaps  nostar eqlabels(none) nonotes"

foreach var of varlist duration duration2 {
  *estimates clear
  
eststo one`var':  poisson `var' summer i.region i.intyr  [pweight=weight] ,r
eststo two`var':  poisson `var' summer i.region  i.intyr  zinc [pweight=weight] ,r
eststo three`var': poisson `var'  summer i.region  i.intyr  zinc  per [pweight=weight] ,r
eststo four`var': poisson `var'  summer i.region  i.intyr zinc per zadult  [pweight=weight] ,r
eststo five`var': poisson `var'  summer i.region  i.intyr zinc per  zadult i.METRO3    [pweight=weight] ,r
eststo six`var':  poisson `var'  summer i.region  i.intyr zinc per  zadult i.METRO3  i.degree  [pweight=weight] ,r
eststo seven`var': poisson `var'  summer i.region   i.intyr  zinc per  zadult i.METRO3  i.degree i.cmsa [pweight=weight] ,r

esttab one`var' two`var' three`var' four`var' five`var' six`var' seven`var' using `var'AHSpres.tex, ///
   `esttaboptions' keep(summer zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars( N ) ///
   nonotes

esttab four`var' five`var' six`var' seven`var' using `var'AHSpresRef3.tex, ///
   `esttaboptions' keep(summer zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars( N ) ///
   nonotes   
   
}

* Construct combined table:

local esttaboptions "tex nomti nodepvars se compress label nogaps  nostar eqlabels(none) nonotes"

esttab *duration using combined.tex, `esttaboptions' keep(summer) frag  coeflabel(summer  "Duration (Months)")  noobs replace

esttab *duration2 using combined.tex, `esttaboptions' keep(summer) frag    coeflabel(summer  "Duration (Years)")  noobs append nonum  

esttab *duration2 using combined.tex, `esttaboptions' frag  indicate("(log) Income = zinc" "HH size = per" "Num. adults = zadult" "Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3"  "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  "Year dummies= *.intyr")  drop(*) scalars( N )  append nonum  



********************************************************************************
* Duration regressions
* Year-by-year  
********************************************************************************


* controls to replicate column (5) from Ngai-Tenreyro 
local col5controls "zinc per zadult i.region i.METRO3 "


tempname topost
postfile `topost' intyr summer_b summer_se str12 depvar using "duration_regs.dta", replace

foreach yr in `intyr_levels' {
  eststo month`yr' : poisson duration summer `col5controls' if intyr == `yr' [pw=weight] , r 
  estadd local year `yr'
  post `topost' (`yr') (_b[summer]) (_se[summer]) (e(depvar))
  
  eststo year`yr' : poisson duration2 summer `col5controls' if intyr == `yr' [pw=weight] , r
  estadd local year `yr'
  post `topost' (`yr') (_b[summer]) (_se[summer]) (e(depvar))
}

postclose `topost' 

 
eststo monthall : poisson duration summer `col5controls' i.intyr [pw=weight] , r 
estadd local year all
  
eststo yearall : poisson duration2 summer `col5controls' i.intyr [pw=weight],r
estadd local year all
 
 
local esttaboptions = "`esttaboptions'" + " replace"
 
esttab month* using monthAHS.tex, ///
   `esttaboptions' keep(summer zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Year dummies= *.intyr") scalars("year Survey Year" N ) 
   
esttab year* using yearAHS.tex, /// 
 `esttaboptions' keep(summer zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Year dummies= *.intyr") scalars("year Survey Year" N ) 


restore

if `shorten' == 1 {
	di "**********************************************"
	di "SKIPPING OVER SOME GRAPHS AND REGRESSIONS HERE"
	di "**********************************************"
}
else {
	





********************************************************************************
**  REPAIRS AND ADDITIONS
********************************************************************************

*keep if recentmove == 1

* column 5 controls:
local builtcontrols = "zinc per zadult i.region built "

* estimates clear 

preserve
keep if recentmove == 1

eststo rone:  poisson ran nsummer i.region i.intyr  if tenure==1 [pweight=weight] ,r
eststo rtwo:  poisson ran nsummer built i.region  i.intyr   if tenure==1 [pweight=weight] ,r
eststo rthree:  poisson ran nsummer built i.region  i.intyr  zinc  if tenure==1 [pweight=weight] ,r
eststo rfour: poisson ran  nsummer built i.region  i.intyr  zinc per   if tenure==1 [pweight=weight] ,r
eststo rfive: poisson ran  nsummer built i.region  i.intyr zinc  per zadult  if tenure==1 [pweight=weight] ,r
eststo rsix: poisson ran  nsummer built i.region  i.intyr zinc per  zadult school     if tenure==1 [pweight=weight] ,r
eststo rseven:  poisson ran  nsummer built i.region  i.intyr zinc per  zadult school i.METRO3     if tenure==1 [pweight=weight] ,r
eststo reight: poisson ran  nsummer built i.region   i.intyr  zinc per  zadult school i.METRO3  i.degree   if tenure==1 [pweight=weight] ,r
eststo rnine: poisson ran  nsummer built i.region   i.intyr  zinc per  zadult school i.METRO3  i.degree i.cmsa  if tenure==1 [pweight=weight] ,r

esttab rone rtwo rthree rfour rfive rsix rseven reight rnine using ranAHSspecpres.tex, ///
   `esttaboptions' keep(nsummer built zinc per zadult school) order(nsummer built zinc per zadult school) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars( N ) 

esttab rsix rseven reight rnine using ranAHSspecpresRef3.tex, ///
   `esttaboptions' keep(nsummer built zinc per zadult school) order(nsummer built zinc per zadult school) nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars( N )  
   
   
   
   
tempname topost
postfile `topost' intyr summer_b summer_se str12 depvar using "ran_regs.dta", replace

foreach yr in `intyr_levels' {
  eststo ran`yr' : poisson ran nsummer `builtcontrols' if intyr == `yr' & tenure == 1 [pw=weight] , r 
  estadd local year `yr' 
  post `topost' (`yr') (_b[nsummer]) (_se[nsummer]) (e(depvar))
}

postclose `topost'    

eststo ranall : poisson ran nsummer `builtcontrols' i.intyr   [pw=weight], r
estadd local year "all" 

* Regression Table for Appendix
* (Year-by-year) 

esttab ran* using ranAHS.tex,  ///
   `esttaboptions' keep(nsummer built zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region"  ///
   "Year dummies= *.intyr") scalars("year Survey Year" N )
 
********************************************************************************
**  COST OF REPAIRS AND ADDITIONS
********************************************************************************

eststo cone:  reg lcost nsummer i.region i.intyr  if tenure==1 [pweight=weight] ,r
eststo ctwo:  reg lcost nsummer built i.region    i.intyr    if tenure==1 [pweight=weight] ,r
eststo cthree:  reg lcost nsummer built i.region  i.intyr  zinc  if tenure==1 [pweight=weight] ,r
eststo cfour: reg lcost  nsummer built i.region   i.intyr  zinc per   if tenure==1 [pweight=weight] ,r
eststo cfive: reg lcost  nsummer built i.region   i.intyr  zinc per zadult  if tenure==1 [ pweight=weight] ,r
eststo csix: reg lcost  nsummer built i.region    i.intyr  zinc per zadult school    if tenure==1  [pweight=weight] ,r
eststo cseven:  reg lcost  nsummer built i.region i.intyr  zinc per zadult school i.METRO3    if tenure==1  [pweight=weight] ,r
eststo ceight: reg lcost  nsummer built i.region  i.intyr  zinc per zadult school i.METRO3  i.degree   if tenure==1 [pweight=weight] ,r
eststo cnine: reg lcost  nsummer built i.region   i.intyr  zinc per zadult school i.METRO3  i.degree  i.cmsa  if tenure==1 [pweight=weight] ,r 
      
esttab cone ctwo cthree cfour cfive csix cseven ceight cnine using lcostAHSspecpres.tex, ///
   `esttaboptions' keep(nsummer built zinc per zadult school) order(nsummer built zinc per zadult school)  nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars("year Survey Year" N ) 
   
esttab csix cseven ceight cnine using lcostAHSspecpresRef3.tex, ///
   `esttaboptions' keep(nsummer built zinc per zadult school) order(nsummer built zinc per zadult school)  nomti ///
   indicate("Region fixed effects =  *.region" "Urban status fixed effects = *.METRO3" ///
   "Degree Days = *.degree" "CMSA fixed effects = *.cmsa"  ///
   "Year dummies= *.intyr") scalars( N )   
   
tempname topost
postfile `topost' intyr summer_b summer_se str12 depvar using "lcost_regs.dta", replace

foreach yr in `intyr_levels' {
  eststo lcost`yr' : reg lcost nsummer `builtcontrols' if intyr == `yr' & tenure == 1 [pw=weight] , r 
  estadd local year `yr' 
  post `topost' (`yr') (_b[nsummer]) (_se[nsummer]) (e(depvar))
}
postclose `topost'      
 
eststo lcostall : reg lcost nsummer `builtcontrols' i.intyr if tenure == 1 [pw=weight], r
estadd local year "all"  

* Regression Table for Appendix
* (Year-by-year) 

esttab lcost* using lcostAHS.tex,  ///
   `esttaboptions' keep(nsummer built zinc per zadult ) nomti ///
   indicate("Region fixed effects =  *.region"  ///
   "Year dummies= *.intyr") scalars("year Survey Year" N )

restore 
 
 
********************************************************************************
* Plot confidence intervals for estimates by year                              *
*   ... key figures for paper                                                  *
********************************************************************************


preserve

 
clear
local durationcolor = "blue"
local duration2color  = "black"


* gray-scale figures
local 1999color gs8
local 2001color gs0

foreach outcome in  duration ran lcost {
	use "`outcome'_regs", clear
	cap drop if depvar == "duration"  // removes duration in months outcome
	
	gen upper = summer_b + 1.96*summer_se
	gen lower = summer_b - 1.96*summer_se 


	tw rcap upper lower intyr if intyr <= 1999 , lcolor(`1999color')  xlab(1999(2)2011) ||  ///
	rcap upper lower intyr if intyr > 1999 ,  lcolor(`2001color')  xlab(1999(2)2011) ||  ///
	scatter summer_b intyr if intyr <= 1999 , mcolor(`1999color') mfcolor(`1999color') mstyle(ci) || ///
	scatter summer_b intyr if intyr>1999  , mcolor(`2001color' ) mfcolor(`2001color') mstyle(ci) legend(off) ///
	xti("Survey Year") yline(0)
  
graph export plot`outcome'wave.pdf, as(pdf) replace
  
}
	
* color figures	
local 1999color red
local 2001color black

foreach outcome in  duration ran lcost {
	use "`outcome'_regs", clear
	cap drop if depvar == "duration"  // removes duration in months outcome
	
	gen upper = summer_b + 1.96*summer_se
	gen lower = summer_b - 1.96*summer_se 


	tw rcap upper lower intyr if intyr <= 1999 , lcolor(`1999color')  xlab(1999(2)2011) ||  ///
	rcap upper lower intyr if intyr > 1999 ,  lcolor(`2001color')  xlab(1999(2)2011) ||  ///
	scatter summer_b intyr if intyr <= 1999 , mcolor(`1999color') mfcolor(`1999color') mstyle(ci) || ///
	scatter summer_b intyr if intyr>1999  , mcolor(`2001color' ) mfcolor(`2001color') mstyle(ci) legend(off) ///
	xti("Survey Year") yline(0)
  
graph export plot`outcome'wavecolor.pdf, as(pdf) replace
  
}

//
// replace intyr = intyr + .2*(depvar=="duration") - .1  // for plotting both outcomes on the same graph
//
// tw rcap upper lower intyr if depvar == "duration2" & intyr <= 1999, lcolor(red) , xlab(1999(2)2011) || ///
// 	  rcap upper lower intyr if depvar=="duration2" & intyr > 1999 , lcolor(`duration2color') || ///
// 	  rcap upper lower intyr if depvar == "duration", lcolor(`durationcolor')  ||  ///
// 	  scatter summer_b  intyr if depvar=="duration2" & intyr<= 1999 , mcolor(red) mfcolor(red) mstyle(ci) || ///	  
// 	  scatter summer_b  intyr if depvar=="duration2" & intyr > 1999, mcolor(`duration2color') mfcolor(`duration2color') mstyle(ci) || ///
// 	  scatter summer_b  intyr if depvar=="duration", mcolor(`durationcolor') mfcolor(`durationcolor') mstyle(p2) legend(off) ///
// 	  yline(0, lstyle(solid) lcolor(gray)) xti("Survey Year") 
// graph export plotbothwave.pdf, as(pdf) replace


restore


}  
// end if/else for skipping over some regressions

********************************************

local controls = "`controls' i.intyr"

* Regressions with Original Data
eststo durationm : poisson duration summer `col5controls' i.intyr [pw=weight], r
estadd local method = "None"
eststo durationy : poisson durationy summer `col5controls' i.intyr [pw=weight], r
estadd local method = "None"

gen orig_esample = e(sample)

eststo sumstats_orig : mean duration durationy [pw=weight] 

* Listwise Deletion (January Data):
eststo durationmlist : poisson duration summer  `col5controls' i.intyr if pmovm != 1 [pw=weight] , r
eststo durationylist : poisson durationy summer  `col5controls' i.intyr if pmovm != 1 [pw=weight] , r

* Reweight January Observations:
* needs imp_fraction 

gen reweight = weight - weight * (pmovm ==1) * `imp_fraction'
eststo durationmre : poisson duration summer `col5controls' i.intyr [pw=reweight] , r
eststo durationyre : poisson durationy summer `col5controls' i.intyr [pw=reweight] , r

* Trimming both December and January:
eststo durationmtrim : poisson duration summer `col5controls' i.intyr if inrange(pmovm,2,11) [pw=weight] , r
eststo durationytrim : poisson durationy summer `col5controls' i.intyr if inrange(pmovm,2,11) [pw=weight] , r

esttab durationm durationmlist durationmre durationmtrim using "$parent/results/durationm.tex", se compress  keep(summer) nodepvar mti("Original" "Listwise" "Reweighted" "Trimmed") replace eqlabels("Duration (Months)") label nodepvar  nolines noobs num   nonotes nostar    posthead(\hline) prefoot(\hline) fragment

esttab durationy durationylist durationyre durationytrim using "$parent/results/durationy.tex", se compress  keep(summer) eqlabels("Duration (Years)") nodepvar nomti nonum  label nostar nogaps  replace nolines  nonotes prefoot(\hline) postfoot(\hline\hline) fragment


******************************************************************************
* PREP FOR IMPUTATIONS
******************************************************************************


clear
use `original'
keep if !mi(ym(pmovyr,pmovm)) 
egen newid = group(control intyr smsa)

save `preimputation' , replace

******************************************************************************
* Create file of PMOVM for sampling from: 
use `preimputation', clear
keep pmovm
rename pmovm pmovm_imp
gen id = _n
local Npmovm = _N
save `pmovm', replace

******************************************************************************
* Create file of DURATIONS for sampling from: 
clear
use `preimputation'
drop if mi(duration)
* keep recent moves
*keep if pmovm != 1  * causes problem for one particular observation!
keep duration 
rename duration duration_imp
* duplicate durations many times for later use of bsample
expand $M+$M
save `durations'

******************************************************************************
* IMPUTATIONS

clear
use `preimputation'

drop if mi(duration)

* create $M copies of data set
* generate variable, m, that tracks imputation number; m=0 is original data
expand $M+1
bys newid intyr: gen m = _n-1

* Imputation Step
* generate random number to determine whether observation is imputed
gen imputation_random = runiform()

* calculate target share of January moves in imp_fraction
* this may not exactly match February numbers, but should be close
* See calculation of imp_fraction earlier in do file

gen impflag = (pmovm==1 & m==0)

* Min and Max possible duration for each observation
gen m_d = ym(move,movm) - min(ym(move,movm),ym(pmovyr,12))
gen M_d = ym(move,movm) - ym(pmovyr,1)

egen group_duration = group(m_d M_d)
levelsof group_duration, local(group_levels)

save `ForImputations', replace

foreach imputation in A B C {
	
    include "$parent\programs\Imputation`imputation'.do"
	include "$parent\programs\AnalyzeMultiplyImputed.do"

}

graph combine imputedA.gph imputedB.gph imputedC.gph
graph export "$parent/results/migraph.pdf", as(pdf) replace


esttab sumstats* using "$parent/results/means.tex", label se nostar ///
  mti keep(duration durationy) replace

esttab durationm durationmmi* durationy durationymi* using "$parent/results/miregs.tex", ///
   keep(summer zinc per zadult ) ///
   indicate("Region fixed effects =  *.region"   ///
   "Urban status effects = *.METRO3" ///
   "Year dummies= *.intyr") ///
   replace se scalars("method Imputation Method") nobaselevels  eqlabels(none) ///
   label nostar compress nogaps ///
   mgroups("Duration (months)" "Duration (years)" , pattern( 1 0 0 0 1 0 0 0 ) span prefix(\multicolumn{@span}{c}{) suffix(})) nodepvar nomti


