% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{logistic_linear}
\alias{logistic_linear}
\title{linear logistic specification model}
\usage{
logistic_linear(stateVariable, theta, ...)
}
\arguments{
\item{stateVariable}{state variable}

\item{theta}{parameter}

\item{...}{...}
}
\value{
numeric level
}
\description{
All specification models can be used as parameter in \code{\link{estimate.functional}}.
Specification models are used to denote the quantile or expectile level
(depending on the identification function).
The linear logistic specification model depends linear on the state variable with a logistic link function.
}
\examples{
# plot linear logistic specification model with constant quantile/expectile level
plot(function(x) logistic_linear(x,theta=c(0,0)), xlim=c(-1,1))


# plot linear logistic specification model with state-dependent quantile/expectile level
plot(function(x) logistic_linear(x,theta=c(0,5)), xlim=c(-1,1))
}
\seealso{
Other specification models: 
\code{\link{constant}()},
\code{\link{probit_break}()},
\code{\link{probit_linear}()},
\code{\link{probit_spline2}()},
\code{\link{probit_spline3}()}
}
\concept{specification models}
