
#devtools::install_github("Schmidtpk/PointFore")

library(PointFore)
library(ggplot2)

#data
ggplot(precipitation, aes(x=X,y=Y))+geom_point(alpha=.1)+xlim(c(0,10))+ylim(c(0,10))

#helper function, within identification function.
#stateVariable is absolute forecast error
#theta1 length of modal interval
#theta2 is asymptotic parameter describing length of part that idenFkt is +1 and -1
mode_bw <- function(stateVariable, theta,...)
{
  if (length(theta) != 2) {
    stop("Wrong dimension of parameter theta for mode_bw model")
  }

  return((stateVariable>theta[1])*(stateVariable<theta[1]+theta[2]))
}

#same, but theta2 constant
mode_const <- function(stateVariable, theta,...)
{
  if (length(theta) != 1) {
    stop("Wrong dimension of parameter theta for mode_const model")
  }

  return((stateVariable>theta)*(stateVariable<theta+1))
}

#defines identification function
modal_interval<- function(x,y,stateVariable,theta,model,...)
{
    theta<-abs(theta)

   return(model(stateVariable,theta)*sign(x-y))
}

#uses my package to apply gmm
res <- estimate.functional(iden.fct = modal_interval,
                    theta0 = c(1,2), model = mode_bw,
                    stateVariable = abs(precipitation$X-precipitation$Y),
                    instruments = c("lag(Y)", "X"),
                    Y = precipitation$Y,X=precipitation$X)

summary(res)


bw.global <- .5
res <- estimate.functional(iden.fct = modal_interval,
                           theta0 = c(1), model = mode_const,
                           stateVariable = abs(precipitation$X-precipitation$Y),
                           Y = precipitation$Y,X=precipitation$X)

summary(res)
