

#' kernel specification model with probit link
#'
#' @param stateVariable state variable
#' @param theta parameter
#'
#' @return numeric level
#' @export
probit_kernel <- function(stateVariable, theta, intervals=NULL, bw=NULL, kernel = q.kernel)
{
  if(length(theta)!=length(intervals)){stop("Wrong dimension of parameter theta for probit kernel model")}

  if(is.null(bw))
    bw <- sd(intervals)

  in.model <- colMeans(sapply(stateVariable,function(x) theta*kernel(intervals-x,bw)))

  return(stats::pnorm(in.model))
}

q.kernel <- function(u,bw) sapply(u, function(x) min(1,max(0,(1-(x/bw)^2))))

l.kernel <- function(u,bw) sapply(u, function(x) max(0,(1-abs(x/bw))))


y <- GDP$observation
x <- GDP$forecast

#y <- precipitation$Y
#x <- precipitation$X


k <- 5
allstates <- x
#choose intervals
full.intervals <- quantile(probs = seq(0,1,length.out = k),x = allstates)
intervals <- full.intervals[-c(1,k+1)]
#intervals <- full.intervals
#choose bw
bw <-   (max(allstates)-min(allstates))/k
#bw <-  max(intervals-lag(intervals),na.rm = TRUE)/2
#bw <- intervals-lag(intervals)

q.kernel(full.intervals-(-2),bw)
q.kernel(full.intervals-(2),bw)
q.kernel(full.intervals-(4),bw)






# possible.instruments <- c("X", "X^2", "X^3","lag(X-Y)^2","lag(lag(Y))","lag(lag(X-Y))","lag(lag(X-Y)^2)")
# instruments <- possible.instruments[1:(k+1)]

instruments <- c("X","lag(Y)", paste(full.intervals[-k],"<X & X<",full.intervals[-1]))

kernel.now <- function(...) probit_kernel(...,intervals = intervals, bw = bw,kernel = l.kernel)



#debugonce("kernel.now")
#debugonce("probit_kernel")
res <- estimate.functional(iden.fct = expectiles,
                    Y=y,X=x,stateVariable = x,
                    theta0 = rep(0,k-1),
                    instruments = instruments,
                    model = kernel.now)

summary(res)
plot(res,hline = TRUE)

library(ggplot2)
ggsave(filename = "./dev/kernel.pdf")


res_quadratic <- estimate.functional(model = probit_spline2,
                                     instruments = c( "X", "lag(X-Y)", "lag(X-Y)^2",
                                                      "lag(X)", "lag(lag(X-Y))", "lag(lag(X-Y))^2"),
                                     state = GDP$forecast, Y=GDP$observation,X=GDP$forecast)
summary(res_quadratic)

res_cubic <- estimate.functional(model = probit_spline3,
                                 instruments = c( "X", "lag(X-Y)", "lag(X-Y)^2",
                                                  "lag(X)", "lag(lag(X-Y))", "lag(lag(X-Y))^2"),
                                 state = GDP$forecast, Y=GDP$observation,X=GDP$forecast)
summary(res_cubic)


plot(res_quadratic,hline = TRUE)
ggsave(filename = "./dev/spline2.pdf")
plot(res_cubic,hline = TRUE)
ggsave(filename = "./dev/spline3.pdf")



res <- estimate.functional(Y=GDP$observation,X=GDP$forecast,stateVariable = GDP$forecast,
                    model = probit_linear)

plot(res,hline=TRUE)
ggsave("./dev/GDP.pdf")
