#This Julia file reads in data that has been simulated using the optimized
#   model and constructs a Var/Cov matrix based on simulations
#   This is used to construct the var/cov estimates of the parameter models



# Read in Data
using DelimitedFiles
xb = readdlm("simdat.raw")
(n, k) = size(xb)


#Define Preliminary things that will be used
alt7 = 0.0
pet = 0.0
lstat = 0
lid = -100
liproc = -100
nn = 0
nobs = 0
xdat = Array{Float64,1}(undef, 1600000)
idmatch = Array{Int64,1}(undef, 1600000)
Nobs = Array{Int64,1}(undef, 1600000)
lstat = Array{Int64,2}(undef, 1600000, 15)
mstat = Array{Int64,3}(undef, 1600000, 15, 2)
potexp = Array{Float64,2}(undef, 1600000, 15)
numlt18 = Array{Float64,2}(undef, 1600000, 15)
numgt18 = Array{Float64,2}(undef, 1600000, 15)
numlt7 = Array{Float64,2}(undef, 1600000, 15)
wage = Array{Float64,2}(undef, 1600000, 15)
nk2 = Array{Int64,1}(undef, 1600000)
nk = Array{Int64,1}(undef, 1600000)
akid = Array{Float64,1}(undef, 1600000)
ayoung = Array{Float64,2}(undef, 1600000, 15)
hadbaby = Array{Int64,2}(undef, 1600000, 15)
ipe = Array{Int64,2}(undef, 1600000, 15)
da = Array{Float64,1}(undef, 1600000)
ip2 = Array{Int64,1}(undef, 1600000)
iwagve = Array{Int64,2}(undef, 1600000, 15)
alt7 = Array{Float64,2}(undef, 1600000, 15)
numka = Array{Float64,3}(undef, 1600000, 15, 8)
nsp = 0

# Transform data into the panel form that we need
for i = 1:n
    global liproc, lid, lstat, nsp, nn
    iproc = xb[i, 1]
    id = xb[i, 2]
    #println(i," ",nn," ",lid," ",iproc)
    if (iproc > liproc)
        liproc = iproc
        lid = id
        nn = nn + 1
        nsp = 1
        xdat[nn] = xb[i, 6]
        idmatch[nn] = xb[i, 3]
    elseif (id > lid)
        lid = id
        nn = nn + 1
        nsp = 1
        xdat[nn] = xb[i, 6]
        idmatch[nn] = xb[i, 3]
    else
        nsp = nsp + 1
    end
    Nobs[nn] = nsp
    potexp[nn, nsp] = xb[i, 4]
    lstat[nn, nsp] = xb[i, 5]
    mstat[nn, nsp, :] = xb[i, 7:8]
    numlt18[nn, nsp] = xb[i, 9]
    numlt7[nn, nsp] = xb[i, 10]
    wage[nn, nsp] = xb[i, 11]
    nk2[nn] = xb[i, 12]
    akid[nn] = xb[i, 13]
    ayoung[nn, nsp] = xb[i, 14]
    da[nn] = xb[i, 15]
    hadbaby[nn, nsp] = xb[i, 16]
    ip2[nn] = xb[i, 17]
    nk[nn] = xb[i, 18]
    numka[nn, nsp, :] = xb[i, 20:27]
    ipe[nn, nsp] = trunc(Int, xb[i, 4])
    if (xb[i, 10] > 0)
        alt7[nn, nsp] = 1.0
    end
    numgt18[nn, nsp] = xb[i, 19]
end
println("done reading ", nn)
println("numpeople ", maximum(idmatch))

#Initialize key variables
Vbig = zeros(nn, 700)
ipstat = 0
ipvb = 0

#Wage Fixed Effect Model
x = zeros(38)
xmn = zeros(38)
xx = zeros(38, 38)
xy = zeros(38)
xxt = zeros(38, 38)
nt = 0
for i = 1:nn
    global x, xmn, xx, xy, xxt
    ni = 0
    xmn = zeros(38)
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            if (ipe[i, isp] > 0)
                xmn[ipe[i, isp]] = xmn[ipe[i, isp]] + 1.0
            end
            xmn[36] = xmn[36] + numlt18[i, isp]
            xmn[37] = xmn[37] + numlt7[i, isp]
            xmn[38] = xmn[38] + float(mstat[i, isp, 1])
            ni = ni + 1
        end
    end
    if (ni > 0)
        xmn = xmn / float(ni)
    end
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            x = [
                zeros(35)
                numlt18[i, isp]
                numlt7[i, isp]
                float(mstat[i, isp, 1])
            ]
            if (ipe[i, isp] > 0)
                x[ipe[i, isp]] = 1.0
            end
            xxt = (x - xmn) * (x - xmn)'
            xx = xx + xxt
            xy = xy + (x - xmn) * wage[i, isp]
        end
    end
end
bols1 = inv(xx) * xy

# Var/Cov Matrix for wage fixed effects
V = zeros(38, 38)
nt = 0
for i = 1:nn
    global V
    local xmn
    ni = 0
    xmn = zeros(38)
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            if (ipe[i, isp] > 0)
                xmn[ipe[i, isp]] = xmn[ipe[i, isp]] + 1.0
            end
            xmn[36] = xmn[36] + numlt18[i, isp]
            xmn[37] = xmn[37] + numlt7[i, isp]
            xmn[38] = xmn[38] + float(mstat[i, isp,1])
            ni = ni + 1
        end
    end
    if (ni > 0)
        xmn = xmn / float(ni)
    end
    Vi = zeros(38)
    for isp = 1:Nobs[i]
        local x
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            x = [
                zeros(35)
                numlt18[i, isp]
                numlt7[i, isp]
                float(mstat[i, isp,1])
            ]
            if (ipe[i, isp] > 0)
                x[ipe[i, isp]] = 1.0
            end
            Vi =
                Vi +
                (x - xmn) .* ones(38, 1) * (wage[i, isp] - ((x - xmn)' * bols1))
        end
    end
    V = V + Vi * Vi'
    Vbig[i, 1:38] = -Vi
end
Vbig[:, 1:38] = Vbig[:, 1:38] * inv(xx)
V = inv(xx) * V * inv(xx)
for j=1:38
println(bols1[j]," ",sqrt(V[j,j]))
end

indv = zeros(700)
indv[1:38] = ones(Int64, 38)

ipstat = ipstat + 38
ipvb = ipvb + 38
println("wage fixed effect ", ipstat, " ", sum(indv), " ", ipvb)


#Work Fixed Effect Model
x = zeros(44)
xmn = zeros(44)
xx = zeros(44, 44)
xy = zeros(44)
xxt = zeros(44, 44)
nt = 0
for i = 1:nn
    global x, xmn, xx, xy, xxt
    ni = 0
    xmn = zeros(44)
    for isp = 1:Nobs[i]
        if (ipe[i, isp] > 0)
            xmn[ipe[i, isp]] += 1.0
        end
        xmn[36:43] += numka[i, isp, :]
        xmn[44] += float(mstat[i, isp, 1])
        ni = ni + 1
    end
    if (ni > 0)
        xmn = xmn / float(ni)
    end
    for isp = 1:Nobs[i]
        x = [zeros(35); numka[i, isp, :]; float(mstat[i, isp, 1])]
        if (ipe[i, isp] > 0)
            x[ipe[i, isp]] = 1.0
        end
        xxt = (x - xmn) * (x - xmn)'
        xx = xx + xxt
        xy = xy + (x - xmn) * lstat[i, isp]
    end
end
bols2 = inv(xx) * xy

#var/cov matrix of work fixed effect
V = zeros(44, 44)
nt = 0
for i = 1:nn
    global V
    local xmn,x
    ni = 0
    xmn = zeros(44)
    for isp = 1:Nobs[i]
        if (ipe[i, isp] > 0)
            xmn[ipe[i, isp]] = xmn[ipe[i, isp]] + 1.0
        end
        xmn[36:43] += numka[i, isp, :]
        xmn[44] += float(mstat[i, isp, 1])
        ni = ni + 1
    end
    if (ni > 0)
        xmn = xmn / float(ni)
    end
    Vi = zeros(44)
    for isp = 1:Nobs[i]
        x = [zeros(35); numka[i, isp, :]; float(mstat[i, isp, 1])]
        if (ipe[i, isp] > 0)
            x[ipe[i, isp]] = 1.0
        end
        Vi =
            Vi +
            (x - xmn) .* ones(44, 1) * (lstat[i, isp] - ((x - xmn)' * bols2))
    end
    V = V + Vi * Vi'
    Vbig[i, ipstat+1:ipstat+44] = -Vi
end
Vbig[:, ipstat+1:ipstat+44] = Vbig[:, ipstat+1:ipstat+44] * inv(xx)
V = inv(xx) * V * inv(xx)

for j=1:44
 println(j," ",bols2[j]," ",sqrt(V[j,j]))
end
indv[ipstat+1:ipstat+44] = ones(Int64, 44)

ipstat = ipstat + 44
ipvb = ipvb + 44
println("work fixed effect ", ipstat, " ", sum(indv), " ", ipvb)

# Within and Between Variance and fixed effect on education

thhat = zeros(nn,2)
ithhat = Array{Int64}(undef, nn)
xx = zeros(2, 2)
xy = zeros(2)
ncheck = 0
ntot = 0
thmn = 0.0
itest = 0
xbarwg=zeros(n,38)
xbbarwg=zeros(38)
for i = 1:nn
    global thmn, ntot, ncheck, xx, xy, itest,xbbarwg,xbarwg
    local x
    ni = 0
    thsum = 0.0
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            ni = ni + 1
            x2 = [
                zeros(35)
                numlt18[i, isp]
                numlt7[i, isp]
                float(mstat[i, isp,1])
            ]
            if (ipe[i, isp] > 0)
                x2[ipe[i, isp]] = 1.0
            end
            thsum = thsum + wage[i, isp] - x2' * bols1
            thmn = thmn + wage[i, isp] - x2' * bols1
            xbarwg[i,:]+=x2
            ntot = ntot + 1
        end
    end
    if (ni > 0)
        thhat[i,1] = thsum[1] / float(ni)
        xbarwg[i,:]=xbarwg[i,:]/float(ni)
        xbbarwg+=xbarwg[i,:]
        x = [1.0; xdat[i]]
        xx = xx + x * x'
        xy = xy + x * thhat[i,1]
        ncheck = ncheck + 1
        itest = itest + 1
        ithhat[i] = 0
    else
        ithhat[i] = 1
    end
end
thmn = thmn / float(ntot)
xbbarwg = xbbarwg / float(ntot)

# Var/cov matrix of these variables
vt = 0.0
vw = 0.0
vb = 0.0
for i = 1:nn
    global vt, vw, vb
    local x
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            x2 = [
                zeros(35)
                numlt18[i, isp]
                numlt7[i, isp]
                float(mstat[i, isp,1])
            ]
            if (ipe[i, isp] > 0)
                x2[ipe[i, isp]] = 1.0
            end
            xhat = x2' * bols1
            vw = vw + (wage[i, isp] - xhat[1] - thhat[i])^2
            vt = vt + (wage[i, isp] - xhat[1] - thmn[1])^2
            vb = vb + (thhat[i,1] - thmn[1])^2
        end
    end
end

indv[ipstat+1:ipstat+2] = ones(Int64, 2)



V = zeros(2, 2)
for i = 1:nn
    global V
    vi = zeros(2)
    for isp = 1:Nobs[i]
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
          x2 = [
            zeros(35)
            numlt18[i, isp]
            numlt7[i, isp]
            float(mstat[i, isp,1])
            ]
          if (ipe[i, isp] > 0)
            x2[ipe[i, isp]] = 1.0
          end
          xhat = x2' * bols1
          vi[1] +=  vw / float(ntot) - (wage[i, isp] - xhat[1] - thhat[i,1])^2
            +2.0*(wage[i,isp]-x2'*bols1-thhat[i,1])*(x2-xbarwg[i,:])'*Vbig[i,1:38]
          vi[2]+= vb/float(ntot)-(thhat[i,1]-thmn[1])^2+
               2.0*(thhat[i,1]-thmn)*(xbarwg[i,:]-xbbarwg)'*Vbig[i,1:38]
        end
    end
    Vbig[i, ipvb+1] = -vi[1] / float(ntot)
    Vbig[i, ipvb+2] = -vi[2] / float(ntot)
end

println("vw ",vw/ntot," ",sqrt(Vbig[:,ipvb+1]'*Vbig[:,ipvb+1]))
println("vb ",vb/ntot," ",sqrt(Vbig[:,ipvb+2]'*Vbig[:,ipvb+2]))
ipstat = ipstat + 2
ipvb = ipvb + 2
println("Within and Between variance ", ipstat, " ", sum(indv), " ", ipvb)


#Now fixed effect regression
bols3 = inv(xx) * xy

# and its Variance/cov
V = zeros(2, 2)
for i = 1:nn
    global V, bols2
    local x,xb
    if (ithhat[i] == 0)
        x = [1.0; xdat[i]]
        xb = x' * bols3
        thhat[i,1] = thhat[i,1] - xb[1]
        vi = x * thhat[i,1]+x*(xbarwg[i,:]'*Vbig[i,1:38])
        Vbig[i, ipvb+1:ipvb+2] = -vi
        V = V + vi * vi'
    end
end
V = inv(xx) * V * inv(xx)
Vbig[:, ipvb+1:ipvb+2] = Vbig[:, ipvb+1:ipvb+2] * inv(xx)

dtheta=zeros(n,2)
for i=1:nn
  local x
  if (ithhat[i]==0)
    x = [1.0; xdat[i]]
    dtheta[i,1]=-xbarwg[i,:]'Vbig[i,1:38]-x'*Vbig[i,ipvb+1:ipvb+2]
  end
end

for j=1:2
 println(j," ",bols3[j]," ",sqrt(V[j,j]))
end

ipstat = ipstat + 1
indv[ipvb+2] = 1
ipvb = ipvb + 2
println("wage fixed effect  education ", ipstat, " ", sum(indv), " ", ipvb)



#Fe work variance and regression of FE on ed
xx = zeros(2, 2)
xy = zeros(2)
ncheck = 0
ntot = 0
thmnwk = 0.0
xbarwk=zeros(n,44)
xbbarwk=zeros(44)
for i = 1:nn
    global thmnwk, ntot, ncheck, xx, xy, itest,xbbarwk,xbarwk
    local x
    ni = 0
    thsum = 0.0
    for isp = 1:Nobs[i]
      ni = ni + 1
      x2 = [
        zeros(35)
        numka[i, isp,:]
        float(mstat[i, isp,1])
        ]
      if (ipe[i, isp] > 0)
        x2[ipe[i, isp]] = 1.0
      end
      thsum = thsum + lstat[i, isp] - x2' * bols2
      thmnwk = thmnwk + lstat[i, isp] - x2' * bols2
      xbarwk[i,:]+=x2
      ntot = ntot + 1
    end
    if (ni > 0)
      thhat[i,2] = thsum[1] / float(ni)
      xbarwk[i,:]=xbarwk[i,:]/float(ni)
      xbbarwk+=xbarwk[i,:]
      x = [1.0; xdat[i]]
      xx = xx + x * x'
      xy = xy + x * thhat[i,2]
      ncheck = ncheck + 1
    else
    end
end
thmnwk = thmnwk / float(ntot)
xbbarwk=xbbarwk/float(ntot)

#var/cov for worker between
vb = 0.0
for i = 1:nn
    global vt, vw, vb
    for isp = 1:Nobs[i]
            x2 = [
                zeros(35)
                numka[i, isp,:]
                float(mstat[i, isp,1])
            ]
            if (ipe[i, isp] > 0)
                x2[ipe[i, isp]] = 1.0
            end
            xhat = x2' * bols2
            vb = vb + (thhat[i,2] - thmnwk)^2
    end
end

indv[ipstat+1:ipstat+2] = ones(Int64, 2)



#var/cov for worker between
V = zeros(2, 2)
for i = 1:nn
    global V
    vi = zeros(2)
    for isp = 1:Nobs[i]
      x2 = [
           zeros(35)
           numka[i, isp,:]
           float(mstat[i, isp,1])
            ]
      if (ipe[i, isp] > 0)
        x2[ipe[i, isp]] = 1.0
      end
      xhat = x2' * bols2
      vi[2]+= vb/float(ntot)-(thhat[i,2]-thmnwk)^2+
        2.0*(thhat[i,2]-thmnwk)*(xbarwk[i,:]-xbbarwk)'*Vbig[i,39:82]
    end
    Vbig[i, ipvb+1] = -vi[2] / float(ntot)
end

println("vb ",vb/ntot," ",sqrt(Vbig[:,ipvb+1]'*Vbig[:,ipvb+1]))
ipstat = ipstat + 1
ipvb = ipvb + 1
println("Work Between variance ", ipstat, " ", sum(indv), " ", ipvb)

#estimate work fixed effect on education
bols4 = inv(xx) * xy

# construct var/cov matrix
V = zeros(2, 2)
for i = 1:nn
    global V, bols4
    local x,xb
      x = [1.0; xdat[i]]
      xb = x' * bols4
      thhat[i,2] = thhat[i,2] - xb[1]
      vi = x * thhat[i,2]+x*(xbarwk[i,:]'*Vbig[i,39:82])
      Vbig[i, ipvb+1:ipvb+2] = -vi
      V = V + vi * vi'
end
V = inv(xx) * V * inv(xx)
Vbig[:, ipvb+1:ipvb+2] = Vbig[:, ipvb+1:ipvb+2] * inv(xx)
for i=1:nn
  local x
  x = [1.0; xdat[i]]
  dtheta[i,2]=-xbarwk[i,:]'Vbig[i,39:82]-x'*Vbig[i,ipvb+1:ipvb+2]
end



for j=1:2
 println(j," ",bols4[j]," ",sqrt(V[j,j]))
end
ipstat = ipstat + 1
indv[ipvb+2] = 1
ipvb = ipvb + 2
println("fixed effect of work on education ", ipstat, " ", sum(indv), " ", ipvb)


#Regression of theta hats
xx=zeros(2,2)
xy=zeros(2)

for i=1:nn
 global xx, xy
 local x
 if (ithhat[i]==0)
   x=[1.0;thhat[i,2]]
   xx+=x*x'
   xy+=x*thhat[i,1]
 end
end

bols=inv(xx)*xy

#var/cov construction
for i=1:nn
 global bols,dtheta,thhat
 local x
 if (ithhat[i]==0)
   x=[1.0;thhat[i,2]]
   vi=x*(thhat[i,1]-dtheta[i,1]-bols[2]*dtheta[i,2])
   vi[2]=vi[2]+dtheta[i,1]*thhat[i,1]
   Vbig[i,ipvb+1:ipvb+2]=-vi
 end
end
Vbig[:,ipvb+1:ipvb+2]= Vbig[:,ipvb+1:ipvb+2]*inv(xx)

for j=1:2
 println(j," ",bols[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]))
end
ipstat = ipstat + 1
indv[ipvb+2] = 1
ipvb = ipvb + 2
println("fixed effect on each other ", ipstat, " ", sum(indv), " ", ipvb)




#Fixed effect coded as missing when it should be
for i = 1:nn
    if ((sum(lstat[i, :]) > 0) & (ithhat[i] == 1))
        ithhat[i] = 2
    end
end



# Marriage probability

xx = zeros(36, 36)
xy1 = zeros(36)
xy2 = zeros(36)
for i = 1:nn
  global xx,xy1,xy2
  local x
   x = zeros(36)
   x[ipe[i, 1]+1] = 1.0
   xx += x*x'
   xy1 += x* float(mstat[i,1, 1])
   xy2 += x* float(mstat[i,1, 2])
end

bols1 = inv(xx) * xy1
bols2 = inv(xx) * xy2
indv[ipvb+1:ipvb+72] = ones(Int64, 72)

# var/cov
for i = 1:nn
    local x
    if (ithhat[i] < 2)
        x=zeros(36)
        x[ipe[i, 1]+1] = 1.0
        xb1 = x'*bols1
        xb2 = x'*bols2
        vi = [x*(float(mstat[i,1,1])-xb1[1]);x*(float(mstat[i,1,2])-xb2[1])]
        Vbig[i, ipvb+1:ipvb+72] = -vi
    end
end

Vbig[:,ipvb+1:ipvb+36] = Vbig[:, ipvb+1:ipvb+36] * inv(xx)
Vbig[:,ipvb+37:ipvb+72] = Vbig[:, ipvb+37:ipvb+72] * inv(xx)
for j=1:35
 println(j," ",bols1[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]),
 " ",bols2[j]," ",sqrt(Vbig[:,ipvb+36+j]'*Vbig[:,ipvb+36+j]))
end


ipstat = ipstat +72
ipvb = ipvb + 72
println(" Marriage", ipstat, " ", sum(indv), " ", ipvb)



# Conditional probability of marriage transition
xx0 = zeros(6,6)
xy0 = zeros(6)
xx1 = zeros(6,6)
xy1 = zeros(6)
for isim = 1:nn
  global xx0, xy0, xx1, xy1
  local x
  for isp = 4:Nobs[isim]
    if (lstat[isim,isp-3]==0)
      wtemp=0.0
    else
      wtemp=wage[isim,isp-3]
    end
    x = [1.0;potexp[isim,isp];potexp[isim,isp]^2;
            xdat[isim];wtemp;lstat[isim,isp-3]]
    if (mstat[isim,isp-1,1]==0)
     xx0+=x*x'
     xy0+=x *float(mstat[isim,isp,1])
    else
     xx1+=x*x'
     xy1+=x *float(mstat[isim,isp,2])
    end
  end
end
bols0 = inv(xx0) * xy0
bols1 = inv(xx1) * xy1
indv[ipvb+4:ipvb+6] = ones(Int64, 3)
indv[ipvb+10:ipvb+12] = ones(Int64, 3)

#var/cov
for isim = 1:nn
  local x,xb
  vi = zeros(6,2)
  for isp = 4:Nobs[isim]
    if (lstat[isim,isp-3]==0)
      wtemp=0.0
    else
      wtemp=wage[isim,isp-3]
    end
    x = [1.0;potexp[isim,isp];potexp[isim,isp]^2;
            xdat[isim];wtemp;lstat[isim,isp-3]]
    if (mstat[isim,isp-1,1]==0)
     xb=x'*bols0
     vi[:,1]+=x*(float(mstat[isim,isp,1]) - xb[1])
    else
     xb=x'*bols1
     vi[:,2]+=x*(float(mstat[isim,isp,2]) - xb[1])
    end
  end
  Vbig[isim, ipvb+1:ipvb+6] = -vi[:,1]
  Vbig[isim, ipvb+7:ipvb+12] = -vi[:,2]
end

Vbig[:, ipvb+1:ipvb+6] = Vbig[:, ipvb+1:ipvb+6] * inv(xx0)
Vbig[:, ipvb+7:ipvb+12] = Vbig[:,ipvb+7:ipvb+12] * inv(xx1)

for j=1:6
 println(j," ",bols0[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]),
 " ",bols1[j]," ",sqrt(Vbig[:,ipvb+6+j]'*Vbig[:,ipvb+6+j]))
end

ipstat = ipstat + 6
ipvb = ipvb + 12
println("Get Married/Divorced", ipstat, " ", sum(indv), " ", ipvb)


#Having Children and Married
tnsps = 0.0
tsps = 0.0
for i = 1:nn
    global tnsps, tsps
    for isp = 2:Nobs[i]
        if (hadbaby[i, isp] == 1)
            tsps = tsps + float(mstat[i, isp-1,1])
            tnsps = tnsps + 1.0
        end
    end
end
spsmn = tsps / tnsps

# variance
spsvar = 0.0
for i = 1:nn
    global spsvar
    svi = 0.0
    for isp = 2:Nobs[i]
        if (hadbaby[i, isp] == 1)
            svi = svi + (float(mstat[i, isp-1,1]) - spsmn)
        end
    end
    spsvar = spsvar + (svi)^2
    Vbig[i, ipvb+1] = -svi / tnsps
end
spsvar = spsvar / tnsps^2
println("married when having kid",spsmn," ",sqrt(Vbig[:,ipvb+1]'*Vbig[:,ipvb+1]))
indv[ipvb+1] = 1
ipstat = ipstat + 1
ipvb = ipvb + 1
println("Have Kid Married", ipstat, " ", sum(indv), " ", ipvb)

#Having Children and Wage
xx = zeros(9, 9)
xy = zeros(9)
for i = 1:nn
  global xx, xy,ww
  local x
  ababy=0.0
  insamp=0
  for isp=2:Nobs[i]
    if (potexp[i,isp]>=potexp[i,1]+0.99)
      insamp=1
      if (hadbaby[i,isp]==1)
        ababy=1.0
      end
    end
    if (lstat[i,1]==1)
      ww=wage[i,1]
    else
      ww=0.0
    end
  end
  if (insamp==1)
    x = [
         1.0
         ww
         lstat[i,1]
         xdat[i]
         float(mstat[i, 1,1])
         numlt7[i, 1]
         numlt18[i, 1]
         potexp[i, 1]
         potexp[i, 1] * potexp[i, 1]
     ]
    xx +=x*x'
    xy +=  x*ababy
  end
end

bols = inv(xx) * xy
indv[ipvb+2:ipvb+3] = ones(2)
#var/cov
for i = 1:nn
  global xx, xy,ww
  local x,xb
  ababy=0.0
  insamp=0
  for isp=2:Nobs[i]
    if (potexp[i,isp]>=potexp[i,1]+0.99)
      insamp=1
      if (hadbaby[i,isp]==1)
        ababy=1.0
      end
    end
    if (lstat[i,1]==1)
      ww=wage[i,1]
    else
      ww=0.0
    end
  end
  if (insamp==1)
    x = [
         1.0
         ww
         lstat[i,1]
         xdat[i]
         float(mstat[i, 1,1])
         numlt7[i, 1]
         numlt18[i, 1]
         potexp[i, 1]
         potexp[i, 1] * potexp[i, 1]
     ]
    xb=x'*bols
    Vbig[i,ipvb+1:ipvb+9] = x*(ababy-xb[1])
  end
end

Vbig[:, ipvb+1:ipvb+9] = Vbig[:, ipvb+1:ipvb+9] * inv(xx)

for j=1:9
 println(j," ",bols[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]))
end

ipstat = ipstat + 2
ipvb = ipvb + 9
println("Have Kid Wage ", ipstat, " ", sum(ipstat), " ", ipvb)



#Age Difference
aden = 0.0
adnum = 0.0
for i = 1:nn
    global aden, adnum
    if (da[i, 1] > -1.0)
        aden = aden + 1.0
        adnum = adnum + da[i, 1]
    end
end
amn = adnum / aden
println("age difference", amn)

indv[ipvb+1] = 1

#variance
adnum = 0.0
avar = 0.0
for i = 1:nn
    global adnum, avar
    if (da[i, 1] > 0.0)
        avar = avar + (da[i, 1] - amn)^2
        Vbig[i, ipvb+1] = -(da[i, 1] - amn) / aden
    end
end
avar = avar / aden^2
println(amn," ",sqrt(Vbig[:,ipvb+1]'*Vbig[:,ipvb+1]))
ipstat = ipstat + 1
ipvb = ipvb + 1
println("Age Difference", ipstat, " ", sum(indv), " ", ipvb)

#Having Kids
xx = zeros(37, 37)
xy = zeros(37)
xy2 = zeros(37)
xy3 = zeros(37)
for i = 1:nn
    global xx, xy, xy2, xy3
    local x
    if (nk2[i] >= 0)
        x = [zeros(36); xdat[i]]
        x[ip2[i]+1] = 1.0
        xx = xx + x * x'
        if (nk2[i] > 0)
            xy = xy + x
        end
        if (nk2[i] == 2)
            xy2 = xy2 + x
        end
        xy3 = xy3 + x * float(nk2[i])
    end
end
bols = inv(xx) * xy
bols2 = inv(xx) * xy2
bols3 = inv(xx) * xy3

# var/cov
V = zeros(37, 37)
V2 = zeros(37, 37)
V3 = zeros(37, 37)
for i = 1:nn
    global V, V2, V3
    local x,xb
    vi = zeros(37)
    vi2 = zeros(37)
    vi3 = zeros(37)
    if (nk2[i] >= 0)
        x = [zeros(36); xdat[i]]
        x[ip2[i]+1] = 1.0
        xb = x' * bols
        if (nk2[i] > 0)
            vi = vi + x * (1.0 - xb[1])
        else
            vi = vi + x * (-xb[1])
        end
        xb = x' * bols2
        if (nk2[i] == 2)
            vi2 = vi2 + x * (1.0 - xb[1])
        else
            vi2 = vi2 + x * (-xb[1])
        end
        xb = x' * bols3
        vi3 = vi3 + x * (float(nk2[i]) - xb[1])
        V = V + vi3 * vi3'
        Vbig[i, ipvb+1:ipvb+37] = -vi
        V2 = V2 + vi2 * vi2'
        Vbig[i, ipvb+38:ipvb+74] = -vi2
        V3 = V3 + vi3 * vi3'
        Vbig[i, ipvb+75:ipvb+111] = -vi3
    end
end
V = inv(xx) * V * inv(xx)
V2 = inv(xx) * V2 * inv(xx)
V3 = inv(xx) * V3 * inv(xx)
Vbig[:, ipvb+1:ipvb+37] = Vbig[:, ipvb+1:ipvb+37] * inv(xx)
Vbig[:, ipvb+38:ipvb+74] = Vbig[:, ipvb+38:ipvb+74] * inv(xx)
Vbig[:, ipvb+75:ipvb+111] = Vbig[:, ipvb+75:ipvb+111] * inv(xx)
for j=1:37
 println(j," ",bols[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]),
  " ",bols2[j]," ",sqrt(Vbig[:,ipvb+37+j]'*Vbig[:,ipvb+37+j]),
  " ",bols3[j]," ",sqrt(Vbig[:,ipvb+74+j]'*Vbig[:,ipvb+74+j]))
end

indv[ipvb+1:ipvb+111] = ones(Int64, 111)
ipstat = ipstat + 111
ipvb = ipvb + 111
println("Having Kids", ipstat, " ", sum(indv), " ", ipvb)



# Conditional probability of working transition
xx = zeros(39, 39)
xy = zeros(39)
xx2 = zeros(39, 39)
xy2 = zeros(39)
icheck = 0
for i = 1:nn
    global xx, xy, xx2, xy2
    local x
    for isp = 1:Nobs[i]-1
            x = [
                zeros(35)
                xdat[i]
                float(mstat[i, isp,1])
                numlt7[i, isp]
                thhat[i, 2]
            ]
            x[ipe[i, isp]+1] = 1.0
        if (lstat[i, isp] == 0)
            xx = xx + x * x'
            xy = xy + x * float(lstat[i, isp+1])
        else
            xx2 = xx2 + x * x'
            xy2 = xy2 + x * float(lstat[i, isp+1])
        end
    end
end
bols = inv(xx) * xy
bols2 = inv(xx2) * xy2
indv[ipvb+1:ipvb+78] = ones(Int64, 78)

#var/Covariance
V = zeros(39, 39)
V2 = zeros(39, 39)
for i = 1:nn
    global V, V2
    local x,xb
    vi = zeros(39)
    vi2 = zeros(39)
    for isp = 1:Nobs[i]-1
            x = [
                zeros(35)
                xdat[i]
                float(mstat[i, isp,1])
                numlt7[i, isp]
                thhat[i, 2]
            ]
            x[ipe[i, isp]+1] = 1.0
        if (lstat[i, isp] == 0)
            xb = x' * bols
            vi = vi + x * (float(lstat[i, isp+1]) - xb[1])-
               x*bols[39]*dtheta[i,2]
            vi[39]+=dtheta[i,2]*(float(lstat[i,isp+1])-x'*bols)

        else
            xb2 = x' * bols2
            vi2 = vi2 + x * (float(lstat[i, isp+1]) - xb2[1])-
                x*bols2[39]*dtheta[i,2]
            vi2[39]+=dtheta[i,2]*(float(lstat[i,isp+1])-x'*bols2)
        end
    end
    V = V + vi * vi'
    Vbig[i, ipvb+1:ipvb+39] = -vi
    V2 = V2 + vi2 * vi2'
    Vbig[i, ipvb+40:ipvb+78] = -vi2
end

V = inv(xx) * V * inv(xx)
Vbig[:, ipvb+1:ipvb+39] = Vbig[:, ipvb+1:ipvb+39] * inv(xx)

V2 = inv(xx2) * V2 * inv(xx2)

Vbig[:, ipvb+40:ipvb+78] = Vbig[:, ipvb+40:ipvb+78] * inv(xx2)
for j=1:39
 println(j," ",bols[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]),
  " ",bols2[j]," ",sqrt(Vbig[:,ipvb+39+j]'*Vbig[:,ipvb+39+j]))
end


ipstat = ipstat + 78
ipvb = ipvb + 78
println("Find/Lose Work", ipstat, " ", sum(indv), " ", ipvb)

#Having Children and working
tnw = 0.0
tw = 0.0
for i = 1:nn
    global tnw, tw
    for isp = 2:Nobs[i]
        if (hadbaby[i, isp] == 1)
            if (isp > 2)
                tw = tw + float(lstat[i, isp-2])
                tnw = tnw + 1.0
            end
        end
    end
end
wkmn = tw / tnw

# var
wkvar = 0.0
for i = 1:nn
    global wkvar
    wvi = 0.0
    for isp = 2:Nobs[i]
        if (hadbaby[i, isp] == 1)
            if (isp > 2)
                wvi = wvi + (float(lstat[i, isp-2]) - wkmn)
            end
        end
    end
    wkvar = wkvar + (wvi)^2
    Vbig[i, ipvb+1] = -wvi / tnw
end
wkvar = wkvar / tnw^2
indv[ipvb+1] = 1
ipstat = ipstat + 1
  println(wkmn," ",sqrt(Vbig[:,ipvb+1]'*Vbig[:,ipvb+1]))
ipvb = ipvb + 1
println("Work/Kid ", ipstat, " ", sum(indv), " ", ipvb)



#Wage growth
wagel = 0.0
xx = zeros(41, 41)
xx2 = zeros(1, 1)
xy = zeros(41)
xy2 = zeros(1)
pel = 0
for i = 1:nn
    global xx, xx2, xy, xy2, wagel, pel
    local x
    lisp = 0
    for isp = 1:Nobs[i]
        if ((lisp > 0) & (lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            if (lisp == isp - 1)
                if (nk[i] >= 0)
                    x = [
                        zeros(36)
                        xdat[i,]
                        float(mstat[i, lisp,1])
                        numgt18[i, isp]
                        xdat[i,]*potexp[i,isp]
                        xdat[i,]*numgt18[i, isp]
                    ]
                    x[ipe[i, isp]+1] = 1.0
                    xx = xx + x * x'
                    xy = xy + x * (wage[i, isp] - wagel)
                end
            elseif (lstat[i, isp-1] == 0)
                dpe = potexp[i, isp] - pel
                x2 = dpe
                xx2[1, 1] += x2 * x2'
                xy2[1] += x2 * (wage[i, isp] - wagel)
            end
        end
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            lisp = isp
            wagel = wage[i, isp]
            pel = potexp[i, isp]
        end
    end
end


bols = inv(xx) * xy
bols2 = inv(xx2) * xy2


# var/cov
V = zeros(41,41)
V2 = zeros(1, 1)
xy2 = zeros(1)
for i = 1:nn
    global V, V2, xy2, wagel, pel
    local x,xb
    lisp = 0
    vi = zeros(41)
    vi2 = zeros(1)
    for isp = 1:Nobs[i]
        if ((lisp > 0) & (lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            if (lisp == isp - 1)
                if (nk[i] >= 0)
                    x = [
                        zeros(36)
                        xdat[i,]
                        float(mstat[i, lisp,2])
                        numgt18[i, isp]
                        xdat[i,]*potexp[i,isp]
                        xdat[i,]*numgt18[i, isp]
                    ]
                    x[ipe[i, isp]+1] = 1.0
                    xb = x' * bols
                    vi = vi + x * (wage[i, isp] - wagel - xb[1])
                end
            elseif (lstat[i, isp-1] == 0)
                dpe = potexp[i, isp] - pel
                x2 = dpe
                xb2 = x2' * bols2
                vi2[1] += x2 * (wage[i, isp] - wagel - xb2[1])
            end
        end
        if ((lstat[i, isp] == 1) & (wage[i, isp] > -10.0))
            lisp = isp
            wagel = wage[i, isp]
            pel = potexp[i, isp]
        end
    end
    xy2 = xy2 + vi2
    V = V + vi * vi'
    Vbig[i, ipvb+1:ipvb+41] = -vi
    V2 += vi2 * vi2'
    Vbig[i, ipvb+42] = -vi2[1]
end


V = inv(xx) * V * inv(xx)
Vbig[:, ipvb+1:ipvb+41] = Vbig[:, ipvb+1:ipvb+41] * inv(xx)
for j=1:41
 println(j," ",bols[j]," ",sqrt(Vbig[:,ipvb+j]'*Vbig[:,ipvb+j]))
end
ipstat = ipstat + 41
indv[ipvb+1:ipvb+41].=1.0
ipvb = ipvb + 41
println("wage change cont employeed", ipstat, " ", sum(indv), " ", ipvb)


V2 = inv(xx2) * V2 * inv(xx2)
Vbig[:, ipvb+1] = Vbig[:, ipvb+1] * inv(xx2)
 println(bols2," ",sqrt(Vbig[:,ipvb+42]'*Vbig[:,ipvb+42]))
indv[ipvb+1] = 1
ipvb = ipvb + 1
ipstat = ipstat + 1

naux = ipstat
println("wage change nonemployment spell", ipstat, " ", sum(indv), " ", ipvb)

Vbig2 = zeros(maximum(idmatch), 700)
for i = 1:nn
    Vbig2[idmatch[i], :] = Vbig2[idmatch[i], :] + Vbig[i, :]
end

#Save Vbigsim

writedlm("Vbigsim", Vbig2)
Var = Vbig' * Vbig
Var2 = Vbig2' * Vbig2



ia = 0
for j = 1:ipvb
    global ia
    if (indv[j] == 1)
        ia = ia + 1
        println(j, " ", sqrt(Var[j, j]), " ", sqrt(Var2[j, j]))
    end
end
