#Intialize some things
using DelimitedFiles,LinearAlgebra
Naux=402
npar=81
x1=readdlm("out.raw")  # model and data auxliary parameters

# Construct Weight Matrix (Omega)
Omegat=ones(Naux,1)
Omegat[81]=0
Omegat[87]=0
xsum=0.0
for j=36:38
 Omegat[j]=Omegat[j]+100
end
for j=39:73
 Omegat[j]=Omegat[j]+10
end
for j=74:82
 Omegat[j]=Omegat[j]+100
end
for j=84:88
 Omegat[j]=Omegat[j]+100
end
for j=161:170
 Omegat[j]=Omegat[j]+100
end
Omegat[87]=0
Omegat[207]=Omegat[207]+100
Omegat[244]=Omegat[244]+100
Omegat[281]=Omegat[281]+100
for j=317:320
 Omegat[j]=Omegat[j]+100
end
for j=356:360
 Omegat[j]=Omegat[j]+100
end
for j=361:396
 Omegat[j]=Omegat[j]+10
end
for j=397:402
 Omegat[j]=Omegat[j]+800
end
println("function value ",Omegat'*x1[:,2])

Omega=zeros(Naux,Naux)
for j=1:Naux
 Omega[j,j]=Omegat[j]
end

# Read Vt and indv
#  Vt is variance of beta hat so really includes Finv terms
#  indv indicates which moments we actually use
Vbt=readdlm("Vbig")
(n,k)=size(Vbt)
Vbts=readdlm("Vbigsim")
Vbts=Vbts[:,1:k]
Vt=(Vbt+Vbts)'*(Vbt+Vbts)
Vt2=Vbt'*Vbt
indv=readdlm("indv")

#Construct V from Vt using only moments we use
V=zeros(Naux,Naux)
Vaux=zeros(Naux,Naux)
ind1=0
for j1=1:k
 global ind1
 if indv[j1]==1
  ind1+=1
  ind2=0
  for j2=1:k
   if indv[j2]==1
    ind2=ind2+1
    V[ind1,ind2]=Vt[j1,j2]
    Vaux[ind1,ind2]=Vt2[j1,j2]
   end
  end
 end
end

#Get parameter values (parin) and gradient(DB)
pars=readdlm("parin")
DB=readdlm("DB")
DB=DB[:,1:Naux]



# Calcluate variance
Vpar=inv(DB*Omega*DB')*DB*Omega*V*Omega*DB'*inv(DB*Omega*DB')
se=sqrt.(diag(Vpar))

#For transformed variables, use delta method
pars[29]=exp.(pars[29])
se[29]=pars[29].*se[29]
pars[74]=exp.(pars[74])
se[74]=pars[74].*se[74]
bl=(1.0/(1.0+exp(pars[56])))
pars[75]=-1.0+2.0*bl
se[75]=2.0*bl*(1.0-bl)*se[75]


#Now output all the tables formatting to easily include into latex

fpar=Array{String,1}(undef,npar)
fse=Array{String,1}(undef,npar)
using Formatting
for j=1:npar
 fpar[j]=format(pars[j],precision=3)
 fse[j]=format(se[j],precision=3)
end

println()
println("Table 3a")
println("Education & ",fpar[1]," & ",fpar[4]," & ",fpar[8]," & ",fpar[12]," & ",fpar[16]," \\\\" )
println("  & (",fse[1],") & (",fse[4],") & (",fse[8],") & (",fse[12],") & (",fse[16],")  \\\\" )
println(" \$\\nu_1 \$  & ",fpar[2]," & ",fpar[5]," &  &  & ",fpar[17],"  \\\\" )
println("  & (",fse[2],") & (",fse[5],") &  &  & ",fse[17],")  \\\\" )
println(" \$\\nu_2 \$  & ",fpar[3]," & ",fpar[6]," & ",fpar[9]," & ",fpar[13]," & ",fpar[18],"  \\\\" )
println("  & (",fse[3],") & (",fse[6],") & (",fse[9],") & (",fse[13],") & (",fse[18],")  \\\\" )
println("Married &  & & ",fpar[10]," & ",fpar[14]," & ",fpar[19]," \\\\" )
println(" &  & & (",fse[10],") & (",fse[14],") & (",fse[19],") \\\\" )
println("Number of Kids \$ < \$ 18 &  & ",fpar[7], " &  &  &  \\\\" )
println(" &  & (",fse[7],") &  &  &  \\\\" )
println("Number of Kids \$ < \$ 7 &  &  & ",fpar[11]," & ",fpar[15]," &  \\\\" )
println(" &  &  & (",fse[11],") & (",fse[15],") &  \\\\" )
println("Working &  &  &  &  & ",fpar[20]," \\\\" )
println(" &  &  &  &  & ( ",fse[20],") \\\\" )
println(" Number of Kids=1  &  &  &  &  & ",fpar[21]," \\\\" )
println(" &  &  &  &  & (",fse[21],") \\\\" )
println("Number of Kids=2 &  &  &  &  & ",fpar[22]," \\\\" )
println(" &  &  &  &  & (",fse[22],") \\\\" )
println("Number of Kids>2 &  &  &  &  & ",fpar[23]," \\\\" )
println(" &  &  &  &  & (",fse[23],") \\\\" )
println("Number of Kids\$ \\ \\times\$ Education &  &  &  &  & ",fpar[24]," \\\\" )
println(" &  &  &  &  & (",fse[24],") \\\\" )
println("Age Youngest &  &  &  &  & ",fpar[25]," \\\\" )
println(" &  &  &  &  & (",fse[25],") \\\\" )
println("Potential Experience \$\\leq 5\$ & ",fpar[49]," & ",fpar[56]," & ",fpar[35]," & ",fpar[42]," & ",fpar[63]," \\\\" )
println(" & (",fse[49],") & (",fse[56],") & (",fse[35],") & (",fse[42],") & ( ",fse[63],") \\\\" )
println("\$5 \\leq \$ Potential Experience \$ \\leq 10 \$ & ",fpar[50]," & ",fpar[57]," & ",fpar[36]," & ",fpar[43]," & ",fpar[64]," \\\\" )
println(" & (",fse[50],") & (",fse[57],") & (",fse[36],") & (",fse[43],") & (",fse[64],") \\\\" )
println("\$10 \\leq \$ Potential Experience \$ \\leq 15 \$ & ",fpar[51]," & ",fpar[58]," & ",fpar[37]," & ",fpar[44]," & ",fpar[65]," \\\\" )
println(" & (",fse[51],") & (",fse[58],") & (",fse[37],") & (",fse[44],") & (",fse[65],") \\\\" )
println("\$15 \\leq \$ Potential Experience \$ \\leq 20 \$ & ",fpar[52]," & ",fpar[59]," & ",fpar[38]," & ",fpar[45]," & ",fpar[66]," \\\\" )
println(" & (",fse[52],") & (",fse[59],") & (",fse[38],") & (",fse[45],") & (",fse[66],") \\\\" )
println("\$20 \\leq \$ Potential Experience \$ \\leq 25 \$ & ",fpar[53]," & ",fpar[60]," & ",fpar[39]," & ",fpar[46]," & ",fpar[67]," \\\\" )
println(" & (",fse[53],") & (",fse[60],") & (",fse[39],") & (",fse[46],") & (",fse[67],") \\\\" )
println("\$25 \\leq \$ Potential Experience \$ \\leq 30 \$ & ",fpar[54]," & ",fpar[61]," & ",fpar[40]," & ",fpar[47]," & ",fpar[68]," \\\\" )
println(" & (",fse[54],") & (",fse[61],") & (",fse[40],") & (",fse[47],") & (",fse[68],") \\\\" )
println("Potential Experience \$ > 30\$ & ",fpar[55]," & ",fpar[62]," & ",fpar[41]," & ",fpar[48]," & ",fpar[69]," \\\\" )
println(" & (",fse[55],") & (",fse[62],") & (",fse[41],") & (",fse[48],") & (",fse[69],") \\\\" )


println()
println("Table 3b")
println("Intercept & ",fpar[76]," & ",fpar[79]," \\\\" )
println("  & (",fse[76],") & (",fse[79],")   \\\\" )
println("Education & ",fpar[77]," & ",fpar[80]," \\\\" )
println("  & (",fse[77],") & (",fse[80],")   \\\\" )
println(" \$\\nu_2 \$ &   ",fpar[78]," & ",fpar[81]," \\\\" )
println("  &   (",fse[78],") & (",fse[81],")   \\\\" )


println()
println("Table 3c")
println("Intercept & ",fpar[26]," &  ",fpar[70]," & ",fpar[72]," &   \\\\" )
println(" & (",fse[26],") & (",fse[70],") & (",fse[72],") &    \\\\" )
println("Education & ",fpar[27]," & ",fpar[71]," & ",fpar[73],"  & ",fpar[30],"    \\\\" )
println(" & (",fse[27],") & (",fse[71],") & (",fse[73],") & (",fse[30],")  \\\\" )
println("\$\\nu_1\$ &  & &   & ",fpar[31],"    \\\\" )
println(" &  & & &   (",fse[31],")  \\\\" )
println("Married & ",fpar[28]," & & & ",fpar[32],"    \\\\" )
println(" & (",fse[28],") & & & (",fse[32],")  \\\\" )
println("Number of Kids \$ < 18\$ & & & "," & ",fpar[33],"    \\\\" )
println(" & & & ","  & (",fse[33],")  \\\\" )
println("Number of Kids \$ < 7\$ & ","  & &   & ",fpar[34],"    \\\\" )
println(" & "," & & &   (",fse[34],")  \\\\" )




println()
println("Table 3d")
println("\$\\delta \$ & ",fpar[29]," \\\\")
println(" & (",fse[29],") \\\\")
println("\$\\sigma_\\varepsilon\$ & ",fpar[74]," \\\\")
println(" & (",fse[74],") \\\\")
println("\$ \\rho_{12}\$ & ",fpar[75]," \\\\")
println(" & (",fse[75],") \\\\")

out=readdlm("out.raw")
apard=out[:,4]
aparm=out[:,3]
seapar=sqrt.(diag(Vaux))

apard[397:402]=apard[397:402]*100.0
aparm[397:402]=aparm[397:402]*100.0
seapar[397:402]=seapar[397:402]*100.0
apard[161:166]=apard[161:166]*100.0
aparm[161:166]=aparm[161:166]*100.0
seapar[161:166]=seapar[161:166]*100.0
fapard=Array{String,1}(undef,Naux)
faparm=Array{String,1}(undef,Naux)
faparse=Array{String,1}(undef,Naux)
for j=1:Naux
 fapard[j]=format(apard[j],precision=3)
 faparm[j]=format(aparm[j],precision=3)
 faparse[j]=format(seapar[j],precision=3)
end
println()
println("Table C1")
println("Education &  & & ",faparm[85]," & ",fapard[85],"    \\\\" )
println(" &  &  & & ( ",faparse[85],")     \\\\" )
println("Married &  ",faparm[38]," & ",fapard[38]," & &     \\\\" )
println(" &   & (",faparse[38],") & &     \\\\" )
println("Number of Kids \$ <  18 \$ & ",faparm[36]," & ",fapard[36]," & &     \\\\" )
println(" &  &( ",faparse[36],") & &     \\\\" )
println("Number of Kids \$ < 7 \$ &  ",faparm[37]," & ",fapard[37]," & &     \\\\" )
println("   & & (",faparse[37],") & &     \\\\" )

println()
println("Table C2")
println("Married &  ",faparm[82]," & ",fapard[82],"    \\\\" )
println(" &   & (",faparse[82],")     \\\\" )
println("Number of Kids age 0 & ",faparm[74]," & ",fapard[74],"      \\\\" )
println(" &  &( ",faparse[74],")      \\\\" )
println("Number of Kids age 1 & ",faparm[75]," & ",fapard[75],"     \\\\" )
println(" &  &( ",faparse[75],")      \\\\" )
println("Number of Kids age 2 & ",faparm[76]," & ",fapard[76],"      \\\\" )
println(" &  &( ",faparse[76],")     \\\\" )
println("Number of Kids age 3 & ",faparm[77]," & ",fapard[77],"      \\\\" )
println(" &  &( ",faparse[77],")     \\\\" )
println("Number of Kids age 4 & ",faparm[78]," & ",fapard[78],"     \\\\" )
println(" &  &( ",faparse[78],")    \\\\" )
println("Number of Kids age 5 & ",faparm[79]," & ",fapard[79],"      \\\\" )
println(" &  &( ",faparse[79],")    \\\\" )
println("Number of Kids age 6 & ",faparm[80]," & ",fapard[80],"      \\\\" )
println(" &  &( ",faparse[80],")     \\\\" )


println()
println("Table C3")
println("Within Variance Log Wages & ",faparm[83]," & ",fapard[83],"    \\\\" )
println(" &  &  (",faparse[83],")   \\\\" )
println("Between Variance Log Wages &  ",faparm[84]," & ",fapard[84],"    \\\\" )
println(" &  & (",faparse[84]," )  \\\\" )
println("Variance Log Work Fixed Effect &  ",faparm[86]," & ",fapard[86],"    \\\\" )
println(" &  & (",faparse[86]," )  \\\\" )
println("Reg. Coef. Wage FE on Work FE &  ",faparm[88]," & ",fapard[88],"    \\\\" )
println(" &  & (",faparse[88]," )  \\\\" )


println()
println("Table C4")
println("Education & ",faparm[161]," & ",fapard[161]," & ",faparm[164]," & ",fapard[164]," \\\\" )
println(" &  & (",faparse[161],") & & (",faparse[164],")  \\\\" )
println("Initial Work   &  ",faparm[163]," & ",fapard[163],"  & " ,faparm[166]," & ",fapard[166]," \\\\" )
println(" &  &  (",faparse[163],")  &  & (",faparse[166],") \\\\" )
println("Initial Wage &  ",faparm[162]," & ",fapard[162],"  & " ,faparm[165]," & ",fapard[165]," \\\\" )
println(" &  &   (",faparse[162],")  &  & (",faparse[165],") \\\\" )

println()
println("Table C5")
println("Fraction Married When Giving Birth & ",faparm[167]," & ",fapard[167],"    \\\\" )
println(" &  & (",faparse[167],")    \\\\" )
println("Working Before Giving Birth &  ",faparm[360]," & ",fapard[360],"    \\\\" )
println(" &  & (",faparse[360],")    \\\\" )
println("Age Difference Youngest/ Oldest  & ",faparm[170]," & ",fapard[170],"    \\\\" )
println(" &  & (",faparse[170],")    \\\\" )

println()
println("Table C6")
println("Education & ",faparm[207]," & ",fapard[207]," & ",faparm[244]," & ",fapard[244],"  & " ,faparm[281]," & ",fapard[281],"  & & \\\\" )
println(" &  & (",faparse[207],") & & (",faparse[244],")  &  & (",faparse[281],") & &  \\\\" )
println("Work Last Year & & & & & & &   ",faparm[169]," & ",fapard[169],"    \\\\" )
println(" &  & & &  & & & & (",faparse[169],")    \\\\" )
println("Wage Last Year  & & & & & & &  ",faparm[168]," & ",fapard[168],"    \\\\" )
println(" &  & & & & & & &  (",faparse[168],")    \\\\" )

println()
println("Table C7")
println("Education & ",faparm[317]," & ",fapard[317]," & ",faparm[356]," & ",fapard[356],"  \\\\" )
println(" &  & (",faparse[317],") & & (",faparse[356],")   \\\\" )
println("Married & ",faparm[318]," & ",fapard[318]," & ",faparm[357]," & ",fapard[357],"  \\\\" )
println(" &  & (",faparse[318],") & & (",faparse[357],")   \\\\" )
println("Number of Kids \$ < 7 \$  & ",faparm[319]," & ",fapard[319]," & ",faparm[358]," & ",fapard[358],"  \\\\" )
println(" &  & (",faparse[319],") & & (",faparse[358],")  \\\\" )
println("Work Fixed Effect & ",faparm[320]," & ",fapard[320]," &  " ,faparm[359]," & ",fapard[359], " \\\\" )
println(" &  & (",faparse[320],") & & (",faparse[359],")  \\\\" )


println()
println("Table C8")
println("Education & ",faparm[397]," & ",fapard[397]," & &   \\\\" )
println(" &  & (",faparse[397],") & &   \\\\" )
println("Married & ",faparm[398]," & ",fapard[398]," & &  \\\\" )
println(" &  & (",faparse[398],")  & & \\\\" )
println("Total Kids > 18   & ",faparm[399]," & ",fapard[399],"  & &   \\\\" )
println(" &  & (",faparse[399],") & &   \\\\" )
println("Educ.\$ \\times \$ Pot. Exp.   & ",faparm[400]," & ",fapard[400],"  & &   \\\\" )
println(" &  & (",faparse[400],") & &   \\\\" )
println("Educ.\$ \\times\$ Total Kids > 18   & ",faparm[401]," & ",fapard[401],"  & &   \\\\" )
println(" &  & (",faparse[401],") & &   \\\\" )
println("Change in Potential Experience    &  & &  " ,faparm[402], " & ", fapard[402], " \\\\")
println("   &  &  &   & (", faparse[402], ") \\\\")


