#Main program

#Get data
include("data.jl")
using Main.data

#Auxiliary Models
include("aux_mod.jl")

#Read in code for the estimation methods
include("base.jl")
using Main.base
include("isw.jl")
using Main.isw
include("gif.jl")
using Main.gif


# Preliminary things
Nruns=2
results=Array{Any}(undef,Nruns,6)

(NN,Ktot)=size(X)
b0=zeros(2*Ktot)

#Iteration for Monte Carlo
for irun=1:Nruns
  Nsim=3000  #Number of simulations
  index=rand(1:NN,Nsim,1)
  Xsim=X[index,:][:,1,:]
  esim=-log.(ones(Nsim,3)./rand(Nsim,3)-ones(Nsim,3))
  
  # Base Model
  results[irun,1]=   basesim(Nsim,Xsim,esim,0,b0)
  results[irun,2]=   basesim(Nsim,Xsim,esim,1,b0)
  
  #Importance Sampling weights
  results[irun,3]=  iswsim(Nsim,Xsim,esim,0,b0)
  results[irun,4]=  iswsim(Nsim,Xsim,esim,1,b0)

  #Generalized Indirect Inference
  lam=0.5  # in practice we manually replace this with output from optimal lambda
  results[irun,5]=  gifsim(Nsim,Xsim,esim,0,b0,lam)
  results[irun,6]=  gifsim(Nsim,Xsim,esim,1,b0,lam)
end

btrue=[blogit[:,1];blogit[:,2]]


#Compile output
best=Array{Any}(undef,Nruns,6)
mse=zeros(Nruns,6)
objective=zeros(Nruns,6)
for irun=1:Nruns
  for j=1:6
    bopt=results[irun,j].minimizer
    mse[irun,j]=(bopt-btrue)'*(bopt-btrue)
    objective[irun,j]=results[irun,j].minimum
  end
end

