#Module to estimate using importance sampling weights
module isw

#Input data and other basic things
  using Main.data
  using Main.auxmod
  using Optim
  include("logit.jl")


#Main function to  estimate
  function iswsim(Nsim,Xsim,esim,ind,b0)

#First simulate the model using inputed parameter (b0)
#   This constructs simulated data Dsim, as well as base likelihood l0
    (NN,K)=size(X)
    K=K-1
    xb0=[Xsim*b0[1:K+1] Xsim*b0[K+2:2*K+2]]
    Dsim=zeros(Int64,Nsim,Nper)
    istate=Int64(0)
    l0=ones(Nsim)
    for isim=1:Nsim
      istate=0
      for iper=1:Nper
        yst=xb0[isim,istate+1]+esim[isim,iper]
        if yst>0
          Dsim[isim,iper]=1
          l0[isim]=l0[isim]*flog([xb0[isim,istate+1]][1])
        else
          l0[isim]=l0[isim]*(1.0-flog([xb0[isim,istate+1]][1]))
        end
        istate=Dsim[isim,iper]
      end
    end

# objective function using importance sampling weights
    function fiw(b)
      istate=Int64(0)
      lb=ones(Nsim)
      xb=[Xsim*b[1:K+1] Xsim*b[K+2:2*K+2]]
      for isim=1:Nsim
        istate=0
        for iper=1:Nper
          if Dsim[isim,iper]==1
            lb[isim]=lb[isim]*flog([xb[isim,istate+1]][1])
          else
            lb[isim]=lb[isim]*(1.0-flog([xb[isim,istate+1]][1]))
          end
          istate=Dsim[isim,iper]
        end
      end
      wt=lb./l0  # Key calculation of weights
      bhat=waux(Xsim,Dsim,wt)
      return (bdat-bhat)'*(bdat-bhat)
    end

# gradient of objective function 
    function g!(g,b)

      istate=Int64(0)
      lb=ones(Nsim)
      dlb=ones(Nsim,2*K+2)
      xb=[Xsim*b[1:K+1] Xsim*b[K+2:2*K+2]]
      for isim=1:Nsim
        istate=0
        dlt=zeros(K+1,2)
        for iper=1:Nper
          if Dsim[isim,iper]==1
            lb[isim]=lb[isim]*flog([xb[isim,istate+1]][1])
            dlt[:,istate+1]=dlt[:,istate+1]+
              (1.0-flog([xb[isim,istate+1]][1]))*Xsim[isim,:]
          else
            lb[isim]=lb[isim]*(1.0-flog([xb[isim,istate+1]][1]))
            dlt[:,istate+1]=dlt[:,istate+1]-
              flog([xb[isim,istate+1]][1])*Xsim[isim,:]
          end
          istate=Dsim[isim,iper]
        end
        dlb[isim,:]=lb[isim]*[dlt[:,1];dlt[:,2]]/l0[isim]
      end
      wt=lb./l0
      bhat=waux(Xsim,Dsim,wt)
      dbhdb=dwauxdb(Xsim,Dsim,wt,dlb)
      gtemp=-2*(bdat-bhat)'*dbhdb
      for j=1:2*K+2
       g[j]=gtemp[j]
      end
    end

# Optimize using either simplex of gradient method
    if ind==0
      fopt= optimize(fiw,b0,Optim.Options(iterations=300000))
    else
      G=zeros(2*K+2)
      g!(G,b0)
      fopt= optimize(fiw,g!,b0,LBFGS(),Optim.Options(iterations=300000))
    end
    return fopt
  end
  export iswsim
end
