#Module to calculate using generalized indirect inference
module gif

# Get data
  using Main.data
  using Main.auxmod
  using Optim
  include("logit.jl")


#Program to estimate model
#   lam is the bandwidth
  function gifsim(Nsim,Xsim,esim,ind,b0,lam)
    (NN,Ktot)=size(X)
    K=Ktot-1

#Objective function
    function fgif(b)
      xb=[Xsim*b[1:K+1] Xsim*b[K+2:2*K+2]]
      Dsim=zeros(Float64,Nsim,Nper)
      dstate=Float64(0)
      for isim=1:Nsim
        dstate=0.0
        for iper=1:Nper
          global istate
          yst=(1.0-dstate)*xb[isim,1]+
            dstate*xb[isim,2]+esim[isim,iper]
          Dsim[isim,iper]=flog(yst/lam)
          dstate=Dsim[isim,iper]
        end
      end
      bhat=aux(Xsim,Dsim)
      return (bdat-bhat)'*(bdat-bhat)
    end

#Gradient of Objective function
    function ggif!(g,b)
      xb=[Xsim*b[1:K+1] Xsim*b[K+2:2*K+2]]
      Dsim=zeros(Float64,Nsim,Nper)
      dDsim=zeros(Float64,Nsim,Nper,2*K+2)
      dstate=Float64(0)
      for isim=1:Nsim
        dstate=0.0
        for iper=1:Nper
          yst=(1.0-dstate)*xb[isim,1]+
            dstate*xb[isim,2]+esim[isim,iper]
          Dsim[isim,iper]=flog(yst/lam)
          dDsim[isim,iper,:]=dflog(yst/lam)*[(1.0-dstate)*Xsim[isim,:]; 
                     dstate*Xsim[isim,:]  ]
          if iper>1
            dDsim[isim,iper,:]=dDsim[isim,iper,:]+dflog(yst/lam)*(-xb[isim,1]+xb[isim,2])*dDsim[isim,iper-1,:]
          end
          dstate=Dsim[isim,iper]
        end
      end
      bhat=aux(Xsim,Dsim)
      dbhdb=dauxdD(Xsim,Dsim,dDsim)
      gtemp=-2*(bdat-bhat)'*dbhdb
      for j=1:2*K+2
       g[j]=gtemp[j]
      end 
    end

#Optimize using either simplex or gradient method
    if ind==0
      fopt= optimize(fgif,b0,Optim.Options(iterations=300000))
    else
      fopt= optimize(fgif,ggif!,b0,LBFGS(),Optim.Options(iterations=300000))
    end
    return fopt
  end
  function gifsimo(Nsim,Xsim,esim,b0,bopt)
    Mst=50
    (nn,K)=size(Xsim)
    Xbig=zeros(Nsim,K,Mst)
    ebig=zeros(Nsim,3,Mst)
    auxm=zeros(size(aux(X,D)))
    for m=1:Mst
      index=rand(1:NN,Nsim,1)
      Xbig[:,:,m]=X[index,:][:,1,:]
      ebig[:,:,m]=-log.(ones(Nsim,3)./rand(Nsim,3)-ones(Nsim,3))
      xb=[Xbig[:,:,m]*bopt[1:K] Xbig[:,:,m]*bopt[K+1:2*K]]
      Dsim=zeros(Int64,Nsim,Nper)
      istate=Int64(0)
      for isim=1:Nsim
        istate=0
        for iper=1:Nper
          yst=xb[isim,istate+1]+esim[isim,iper]
          Dsim[isim,iper]=yst>0
          istate=Dsim[isim,iper]
        end 
      end 
      bhat=aux(Xbig[:,:,m],Dsim)
      auxm[:]+=bhat
     end
     auxm=auxm/Mst
     function ff(lamv)
       lam=lamv[1]
       mse=0.0
       for m=1:Mst
         xb=[Xbig[:,:,m]*bopt[1:K] Xbig[:,:,m]*bopt[K+1:2*K]]
         Dsim=zeros(Float64,Nsim,Nper)
         dstate=Float64(0)
         for isim=1:Nsim
           dstate=0.0
           for iper=1:Nper
             global istate
             yst=(1.0-dstate)*xb[isim,1]+
             dstate*xb[isim,2]+esim[isim,iper]
             Dsim[isim,iper]=flog(yst/lam)
             dstate=Dsim[isim,iper]
           end
         end
         bhat=aux(Xbig[:,:,m],Dsim)
         mse+=(bhat-auxm)'*(bhat-auxm)
       end
       return mse
     end
     lamv=ones(1)
     lamv[1]=2.0
     opt=optimize(ff,lamv,LBFGS(),Optim.Options(show_trace=true))
     lamopt=opt.minimizer
     println("optimal lambda",lamopt)
     return lamopt
   end
       

  export gifsim,gifsimo
end
