# produce data that will be used in estimation
module data
  # get parameters from bdata.jld
  using HDF5, JLD
  pars=load("bdata.jld","data")
  K=pars[1]
  nfact=pars[2]
  fact=pars[3]
  mu=pars[4]
  sig=pars[5]
  blogit=pars[6]


  NN=200000  # Number of raw Observations
  Nper=3     # Number of periods

  include("logit.jl")  # Logit functions
  using  LinearAlgebra


  #Construct data
  X=ones(NN,1)*mu'+ randn(NN,nfact)*fact'+randn(NN,K)*Diagonal(sig)
  X=[ones(NN,1) X]
  XB=X*blogit
  prob=flogv(XB)
  D=zeros(Int64,NN,3)
  rr=rand(NN,3)
  istate=Int64(0)
  for i=1:NN
    istate=0
    for it=1:Nper
      D[i,it]=prob[i,istate+1]>rr[i,it]
      istate=D[i,it]
    end
  end
  export X,D,NN,Nper,blogit
end #data
