module base

#Get data
  using Main.data
  using Main.auxmod
  using Optim

#Program to estimate model
  function basesim(Nsim,Xsim,esim,ind,b0)
    (NN,K)=size(X)
    K=K-1

# Objective function
    function fbase(b)
      xb=[Xsim*b[1:K+1] Xsim*b[K+2:2*K+2]]
      Dsim=zeros(Int64,Nsim,Nper)
      istate=Int64(0)
      for isim=1:Nsim
        istate=0
        for iper=1:Nper
          yst=xb[isim,istate+1]+esim[isim,iper]
          Dsim[isim,iper]=yst>0
          istate=Dsim[isim,iper]
        end
      end
      bhat=aux(Xsim,Dsim)
      return (bdat-bhat)'*(bdat-bhat)
    end
#Optimize using either simplex or gradient method
    if ind==0
      fopt= optimize(fbase,b0,Optim.Options(iterations=300000))
    else
      fopt= optimize(fbase,b0,LBFGS(),Optim.Options(iterations=300000))
    end
    return fopt
  end
  export basesim
end
