#Simulations to produce the curvature graph
using DelimitedFiles


#Read in parameters
pars=readdlm("parin")

bhc=pars[26:28]
blam=pars[70:71]
bxh=pars[72:73]

#Get baseline
ed=1.529
mar=1.0
a=exp(bhc[1]+bhc[2]*ed+bhc[3]*mar)
lam=exp(blam[1]+blam[2]*ed)
xhbar=exp(bxh[1]+bxh[2]*ed)


#human capital for continuously employed
function hb(t)
 f=xhbar*(1-exp(a*(exp(-lam*t)-1.0)/lam)) 
 return f
end


#Simulation 1 gets rid of the direct effect of curvature from maximum

#recalibrate the a parameter so human capital is the same at age 10
function fs1(ain)
 f=(xhbar*ain[1]*(1-exp(-lam*10))/lam-hb(10))^2
 return f
end

using Optim
ain=zeros(1)
ain[1]=a
a1o=optimize(fs1,ain,BFGS(),Optim.Options(show_trace=true))
a1=a1o.minimizer[1]

# simulate counterfactual 1
function h1(t)
 f=xhbar*a1*(1-exp(-lam*t))/lam
 return f
end



#Simulation 2 gets rid of the direct effect of curvature from age

#recalibrate the a parameter so human capital is the same at age 10 
function fs2(ain)
 f=(xhbar*(1-exp(-ain[1]*10))-hb(10))^2
 return f
end


ain=zeros(1)
ain[1]=a
a2o=optimize(fs2,ain,BFGS(),Optim.Options(show_trace=true))
a2=a2o.minimizer[1]

# simulate counterfactual 2
function h2(t)
 f=xhbar*(1-exp(-a2*t))
 return f
end



#Simulation 3 does both (but is not in the paper)

#recalibrate the a parameter so human capital is the same at age 10
function fs3(ain)
 f=(xhbar*ain[1]*10-hb(10))^2
 return f
end

ain=zeros(1)
ain[1]=a
a3o=optimize(fs3,ain,BFGS(),Optim.Options(show_trace=true))
a3=a3o.minimizer[1]



# simulate counterfactual 3
function h3(t)
 f=xhbar*a3*t
 return f
end


#put into form that can be outputed (and inputted into stata)
xx=zeros(41,5)
for t=0:40
 xx[t+1,1]=t
 xx[t+1,2]=hb(t)
 xx[t+1,3]=h1(t)
 xx[t+1,4]=h2(t)
 xx[t+1,5]=h3(t)
end

writedlm("avg-sim.raw",xx)
