subroutine simdat(b)
  ! this simulates data-used for straight indirect inference without
  !      importance sampling

use ggg ! global variables

! declare variables
implicit none
double precision :: b(npar)
integer :: id,iempt,mart,nklt18t,nklt7t,nkidt,anykidt,ayt,dat,babyt,iwavet
double precision :: wgt,edt,pet
double precision ::  potexp(nmax,maxsp),ed(nmax)
integer :: nobs(nmax),j,i
double precision :: bm(0:1,4),bw(0:1,4),bk(10),bhc(0:1,3),gam(5)
double precision :: bexpw(0:1,ncell),bexpm(0:1,ncell),bexpk(ncell),dlam,xhbar,sigeps
double precision :: xbw(0:1),xbm(0:1),xbk,tend,z,dstart,drnor,xbtemp
real :: u(nsim),uu(4)
integer :: iwork,imar,nkid,iseed,lid,i_index,isim,k,icell,idiv
integer :: nkidlt7,nkidlt18,ioldlt7,ioldlt18,iobs,ireas,nspell
double precision :: inthazinv,timew,timem,timek(3),bdkid(85),tbeg,timekmin
double precision :: fi,start,ihazw,ihazk,ihazm,hazw,hazk,hazm,bdold,tlen
double precision :: tempprod,f
integer :: isp,nf,uip(1),naux,iv(60),liv=60,lv=4000
external :: drnor
integer :: njj,istop,itag,jj,ierr,nfe,iage,ikid
double precision :: parvec(npar),auxmom(numaux),bfe(38),bbase(2),vv(4000)
double precision :: fp,fm,ddd,th_sim(nsim,2),ssig12
double precision :: xbhc(0:1), hcstat(nsim,maxsp),xhct,ahc,delta,xhc
double precision :: blam(2),blsi(3),bxh(2),pw0,pwb,blb(3)

 bm(0,1:3)=b(1:3) ! marriage
 bm(1,:)=b(4:7)
 bw(0,:)=b(8:11) !work
 bk=b(16:25)  !kids
 bhc(0,:)=b(26:28)  !humn capital
 bhc(1,:)=b(29)
 gam=b(30:34)  ! wage parameters
 bexpw(0,:)=b(35:41) ! work hazard
 bexpw(1,:)=b(42:48)
 bexpm(0,:)=b(49:55) ! marriage hazard
 bexpm(1,:)=b(56:62)
 bexpk=b(63:69) ! children hazard
 blam=b(70:71) ! human capital lambda
 bxh=b(72:73) ! human capital xhbar
 sigeps=dexp(b(74)) !standard deviation measurement error
 ssig12=-1.0d0+2.0d0*(1.0d0/(1.0d0+dexp(b(75)))) ! correlation between random effects
 blsi=b(76:78) !initial work
 blb=b(79:81) !work after baby


numka=0  !set initail number of kids to zero

!prepare parameters for simulation
iseed=109328423+23232*myid
call uniran(nsim,iseed,U)
ilink=1+int(dble(NN)*dble(U))
iseed=320948234+23232*myid
z=dstart(iseed)
do isim=1,nsim
 inseed(isim,1)=int(abs(33122399.3d0*drnor()))
 inseed(isim,2)=int(abs(3298473.22d0*drnor()))
enddo

 !construct theta
 do isim=1,nsim
  th_sim(isim,1)=z_sim(isim,1)
  th_sim(isim,2)=ssig12*z_sim(isim,1)+dsqrt(1.0d0-ssig12**2.0d0)*z_sim(isim,2)
 enddo

 !Initialze state variables
 hvbaby_sim=0
 nk_sim=0
 icell=0
 nsp_sim=0
 nk2_sim=-9
 do isim=1,nsim
  iwork=0
  imar=0
  idiv=0
  nkid=0
  nkidlt7=0
  nkidlt18=0
  tend=0.0d0
  bdkid=0.0d0
  iobs=1
  nspell=0
  z=dstart(inseed(isim,1))
  iseed=inseed(isim,2)
  ! get constant things ready
  call uniran(4,iseed,uu)
  pw0=dexp(blsi(1)+blsi(2)*ed_simn(isim)+blsi(3)*th_sim(isim,2))
  pw0=pw0/(1.0d0+pw0)
  if (pw0>uu(1)) then
   iwork=1
  else
   iwork=0
  endif
  pwb=dexp(blb(1)+blb(2)*ed_simn(isim)+blb(3)*th_sim(isim,2))
  pwb=pwb/(1.0d0+pwb)
  iwk0_sim(isim)=iwork
  ispind_sim(isim)=icell+1
  do j=0,1
   xbw(j)=bw(j,1)*ed_simn(isim)+bw(j,2)*th_sim(isim,2)
   xbm(j)=bm(j,1)*ed_simn(isim)+bm(j,2)*th_sim(isim,1)+bm(j,3)*th_sim(isim,2)
  enddo
  xbk=bk(1)*ed_simn(isim)+bk(2)*th_sim(isim,1)+bk(3)*th_sim(isim,2)

  ! go across spells
  do while(tend<potexp_sim(isim,nobs_sim(isim)))
    ! spell ends with marriage, work, or child transition
   call uniran(4,iseed,uu)
   !hazard work
   xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
   timew=inthazinv(tend,-dlog(dble(uu(1))),xbtemp,bexpw(iwork,:))
   !hazard marriage
   if (imar==1) then
    xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
   else
    xbtemp=xbm(0)
   endif
   timem=inthazinv(tend,-dlog(dble(uu(2))),xbtemp,bexpm(imar,:))
   !hazard have kid
   xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
   if (nkid==1) then
    xbtemp=xbtemp+bk(6)
   elseif (nkid==2) then
    xbtemp=xbtemp+bk(7)
   elseif (nkid>2) then
    xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
   endif
   if (nkid>=1) then
    xbtemp=xbtemp+bk(10)*(tend-bdkid(1))
   endif
   timek(1)=inthazinv(tend,-dlog(dble(uu(3))),xbtemp,bexpk)
   if (nkid>9) then
     timek(1)=1.0d10
   endif
    ! Time until kid turns 7 or 18
  if (nkidlt18.eq.0) then
   timek(2:3)=1.0d10
  elseif (nkidlt7==nkidlt18) then
   timek(2)=1.0d10
   timek(3)=bdkid(ioldlt7)+7.0d0-tend
  elseif(nkidlt7>0) then
   timek(2)=bdkid(ioldlt18)+18.0d0-tend
   timek(3)=bdkid(ioldlt7)+7.0d0-tend
  else
   timek(2)=bdkid(ioldlt18)+18.0d0-tend
   timek(3)=1.0d10
  endif
  timekmin=minval(timek)
  tbeg=tend
  tend=tend+min(timew,timem,timekmin)
 !simulate data for whichever of these three is minimum
  do while ((tend>potexp_sim(isim,min(iobs,maxsp))).and.(iobs<=nobs_sim(isim)))
   lstat_sim(isim,iobs)=iwork
   mstat_sim(isim,iobs,1)=imar
   mstat_sim(isim,iobs,2)=idiv
   nklt7_sim(isim,iobs)=nkidlt7
   nklt18_sim(isim,iobs)=nkidlt18
   nkgt18_sim(isim,iobs)=nkid-nkidlt18
   nk_sim(isim,iobs)=nkid
   if (nkid>0) then
    ay_sim(isim,iobs)=potexp_sim(isim,iobs)-bdkid(nkid)
    akid_sim(isim)=1.0d0
   else
    akid_sim(isim)=0.0d0
   endif
   do ikid=1,nkid
    iage=floor(potexp_sim(isim,iobs)-bdkid(ikid))
    if (iage<7) then
     numka(isim,iobs,iage)=numka(isim,iobs,iage)+1
    else
     numka(isim,iobs,7)=numka(isim,iobs,7)+1
    endif
   enddo
   if (iobs==1) then
    if (nkid>2) then
     da_sim(isim)=bdkid(nkid)-bdkid(1)
    else
     da_sim(isim)=-9.0d0
    endif
   endif
   if (iwave(ilink(isim),iobs)==2) then
    ip2_sim(isim)=int(potexp_sim(isim,iobs))
    nk2_sim(isim)=nkid
   endif
   if (iobs>1) then
    if (nkid>nk_sim(isim,iobs-1)) then
     hvbaby_sim(isim,iobs)=1
    endif
   endif
   if (nkidlt7>0) then
    alt7_sim(isim,iobs)=1.0d0
   else
    alt7_sim(isim,iobs)=0.0d0
   endif
   if (iwork==1) then
    eps_sim(isim,iobs)=drnor()
   endif
   iobs=iobs+1
  enddo
  if ((timew<timem).and.(timew<timekmin)) then !work status changes
   iwork=1-iwork
   ireas=1
  elseif (timem<timekmin) then ! marriage status changes
   if (imar==1) then
    imar=0
    idiv=1
   else
    idiv=0
    imar=1
   endif
   ireas=2
  elseif ((timek(1)<timek(2)).and.(timek(1)<timek(3))) then !birth
   nkid=nkid+1
   bdkid(nkid)=tend
   ireas=3
   if (nkidlt7==0) then
    ioldlt7=nkid
   endif
   if (nkidlt18==0) then
    ioldlt18=nkid
   endif
   nkidlt7=nkidlt7+1
   nkidlt18=nkidlt18+1
    if (iwork==1) then
    call uniran(1,iseed,uu)
    if (pwb<uu(1)) then
     iwork=0
    endif
    iwkb_sim(isim,nkid)=iwork
   endif
  elseif (timek(2)<timek(3)) then !Kid reaches 18
   ireas=4
   nkidlt18=nkidlt18-1
   if (nkidlt18>0) then
    ioldlt18=ioldlt18+1
   endif
  else  !Kid reaches 7
   ireas=5
   nkidlt7=nkidlt7-1
   if (nkidlt7>0) then
    ioldlt7=ioldlt7+1
   endif
  endif
  nspell=nspell+1
  if (tend<potexp_sim(isim,Nobs_sim(isim))) then
   if (icell==nspsim-10) then
     tend=10000.0d0
   endif
   icell=icell+1
   tdate_sim(icell)=tend
   iend_sim(icell)=ireas
  endif
  enddo
  nsp_sim(isim)=nspell
 enddo


! given spell keep track of data to get auxiliary parameters
hcstat=0.0d0
fdens=1.0d0
do isim=1,nsim ! go over individuals

 ! keep track of parameters that are constant across spells
 pw0=dexp(blsi(1)+blsi(2)*ed_simn(isim)+blsi(3)*th_sim(isim,2))
 pw0=pw0/(1.0d0+pw0)
 pwb=dexp(blb(1)+blb(2)*ed_simn(isim)+blb(3)*th_sim(isim,2))
 pwb=pwb/(1.0d0+pwb)
 dlam=dexp(blam(1)+blam(2)*ed_simn(isim))
 xhbar=dexp(bxh(1)+bxh(2)*ed_simn(isim))
 xhc=1.0d-10
 iobs=1
 iwork=iwk0_sim(isim)
 fdens(isim)=dble(iwork)*pw0+dble((1-iwork))*(1.0d0-pw0)
 imar=0
 nkidlt18=0
 nkidlt7=0
 nkid=0
 start=0.0d0
 bdold=0.0d0
 do j=0,1
  xbw(j)=bw(j,1)*ed_simn(isim)+bw(j,2)*th_sim(isim,2)
  xbm(j)=bm(j,1)*ed_simn(isim)+bm(j,2)*th_sim(isim,1)+bm(j,3)*th_sim(isim,2)
  xbhc(j)=bhc(j,1)
 enddo
 xbk=bk(1)*ed_simn(isim)+bk(2)*th_sim(isim,1)+bk(3)*th_sim(isim,2)
 do isp=1,Nsp_sim(isim)-1 ! go over spell
   ireas=iend_sim(ispind_sim(isim)-1+isp)
   tlen=tdate_sim(ispind_sim(isim)-1+isp)-start
   !hazard work
   xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
   call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
   !hazard marital status
   if (imar==1) then
    xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
   else
    xbtemp=xbm(0)
   endif
   call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
   !hazard have kid
   xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
   if (nkid==1) then
    xbtemp=xbtemp+bk(6)
   elseif (nkid==2) then
    xbtemp=xbtemp+bk(7)
   elseif (nkid>2) then
    xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
   endif
   if (nkid>=1) then
    xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+isp)-bdold)
   endif
   call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)
   ! human capital components
   if (iwork==1) then
    xbtemp=xbhc(0)+bhc(0,2)*ed_simn(isim)+bhc(0,3)*dble(imar)
    ahc=dexp(xbtemp)
   else
     xbtemp=xbhc(1)
     delta=dexp(xbtemp)
   endif
   do while ((start+tlen>potexp_sim(isim,min(iobs,maxsp))).and.(iobs<=nobs_sim(isim)))
    if (iwork==0) then
     xhct=xhc*dexp(-delta*(potexp_sim(isim,iobs)-start))
    else
     xhct=xhbar+dexp(ahc*(dexp(-dlam*potexp_sim(isim,iobs))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
    endif
    hcstat(isim,iobs)=xhct
    iobs=iobs+1
  enddo
  if (iwork==0) then
   xhc=xhc*dexp(-delta*tlen)
  else
   xhc=xhbar+dexp(ahc*(dexp(-dlam*(start+tlen))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
  endif
   tempprod=dexp(-ihazw-ihazk-ihazm)
   ireas=iend_sim(ispind_sim(isim)-1+isp)
   if (ireas==1) then
    fdens(isim)=fdens(isim)*tempprod*hazw
    iwork=1-iwork
   elseif (ireas==2) then
    fdens(isim)=fdens(isim)*tempprod*hazm
    imar=1-imar
   elseif (ireas==3) then
    fdens(isim)=fdens(isim)*tempprod*hazk
    nkid=nkid+1
    nkidlt7=nkidlt7+1
    nkidlt18=nkidlt18+1
    if (iwork==1) then
     iwork=iwkb_sim(isim,nkid)
     fdens(isim)=fdens(isim)*(dble(iwork)*pwb+dble(1-iwork)*(1.0d0-pwb))
    endif
    if (nkid==1) then
     bdold=start+tlen
    endif
   elseif (ireas==4) then
    fdens(isim)=fdens(isim)*tempprod
    nkidlt18=nkidlt18-1
   else
    fdens(isim)=fdens(isim)*tempprod
    nkidlt7=nkidlt7-1
   endif
   start=start+tlen
 enddo
 tlen=potexp_sim(isim,Nobs_sim(isim))-start
 xbtemp=xbw(iwork)+bw(iwork,3)*dble(imar)+bw(iwork,4)*dble(nkidlt7)
 call inthaz(start,tlen,xbtemp,bexpw(iwork,:),ihazw,hazw)
 if (imar==1) then
  xbtemp=xbm(1)+bm(1,4)*dble(nkidlt18)
 else
  xbtemp=xbm(0)
 endif
 call inthaz(start,tlen,xbtemp,bexpm(imar,:),ihazm,hazm)
 xbtemp=xbk+bk(4)*dble(imar)+bk(5)*dble(iwork)
 if (nkid==1) then
  xbtemp=xbtemp+bk(6)
 elseif (nkid==2) then
  xbtemp=xbtemp+bk(7)
 elseif (nkid>2) then
  xbtemp=xbtemp+bk(8)+bk(9)*ed_simn(isim)
 endif
 if (nkid>=1) then
  xbtemp=xbtemp+bk(10)*(tdate_sim(ispind_sim(isim)-2+nsp_sim(isim))-bdold)
 endif
 call inthaz(start,tlen,xbtemp,bexpk,ihazk,hazk)
 fdens(isim)=fdens(isim)*dexp(-ihazw-ihazm-ihazk)
 do while (iobs<=nobs_sim(isim))
  if (iwork==0) then
   xhct=xhc*dexp(-delta*(potexp_sim(isim,iobs)-start))
  else
   xhct=xhbar+dexp(ahc*(dexp(-dlam*potexp_sim(isim,iobs))-dexp(-dlam*start))/dlam)*(xhc-xhbar)
  endif
  hcstat(isim,iobs)=xhct
  iobs=iobs+1
 enddo
enddo

f0=fdens

! simulate wages
w_sim=0.0d0
do isim=1,nsim
 do isp=1,Nobs_sim(isim)
  w_sim(isim,isp)=gam(1)*ed_sim(isim)+gam(2)*th_sim(isim,1)+gam(3)*dble(mstat_sim(isim,isp,1))+ &
  gam(4)*dble(nklt18_sim(isim,isp))+gam(5)*dble(nklt7_sim(isim,isp))+ hcstat(isim,isp)+sigeps*eps_sim(isim,isp)
  enddo
enddo

return
end
