subroutine fsii(kk,b,nf,f,uip,psim,ufp)
! main objective function

use ggg ! global variables
use mpi
! define variables
implicit none
integer :: nf, kk,uip(1),ierror
double precision :: b(npar),f,xxin(numaux),xsum(numaux),psim(nauxp)
double precision, dimension(:), allocatable :: xy,bols
double precision, dimension(:,:), allocatable :: xx,xxi
double precision :: ufp(1),thmn,omega(nauxp),WW(numaux),ft
integer :: indaux,ipstat,j,ierr,jj,status(mpi_status_size),i,njj
double precision :: bfe(82)


! initialize things
nf=2
f=0.0d0
head=0

psim=0.0d0
xsum=0.0d0
! tell processors to continue
do i=1,numprocs-1
 jj=1
 njj=2
 call MPI_SEND(jj, njj, MPI_integer, &
        i, 1, MPI_COMM_WORLD, ierr)
enddo

! broadcast current parameter to workers
 call MPI_BCAST(b, npar, MPI_DOUBLE_PRECISION, head, &
       MPI_COMM_WORLD, ierr)

! collect fixed effect output from workers
do i=1,numprocs-1
  !use this part instead of bcast to get to processors sequentially
! call MPI_SEND(b, npar, MPI_DOUBLE_PRECISION, &
!        i, 1, MPI_COMM_WORLD, ierr)
 call MPI_RECV(xxin,numaux, MPI_DOUBLE_PRECISION, &
   i, MPI_ANY_TAG, &
   MPI_COMM_WORLD, status, ierr)
  xsum=xsum+xxin
enddo


indaux=0
ipstat=0

!Wage Fixed Effects
  ! combine results from workers to construct fixed effect parameters

allocate(xx(38,38),xxi(38,38),xy(38))
call outlxx(38,xsum(indaux+1:indaux+741),xx)
call Findinv(xx,xxi,38,ierror)
xy=xsum(indaux+742:indaux+779)
bfe(1:38)=matmul(xxi,xy)
psim(ipstat+1:ipstat+38)=bfe(1:38)
indaux=indaux+779
ipstat=ipstat+38
deallocate(xx,xxi,xy)

!work Fixed Effects

allocate(xx(44,44),xxi(44,44),xy(44))
call outlxx(44,xsum(indaux+1:indaux+990),xx)
call Findinv(xx,xxi,44,ierror)
xy=xsum(indaux+991:indaux+1034)
bfe(39:82)=matmul(xxi,xy)
psim(ipstat+1:ipstat+44)=bfe(39:82)
indaux=indaux+991
ipstat=ipstat+44

!Broadcast fixed effect to workers
call MPI_BCAST(bfe, 82, MPI_DOUBLE_PRECISION, head, &
MPI_COMM_WORLD, ierr)


!Get new set of moments
xsum=0.0d0
do i=1,numprocs-1
 call MPI_RECV(xxin,numaux, MPI_DOUBLE_PRECISION, &
 i, MPI_ANY_TAG, &
 MPI_COMM_WORLD, status, ierr)
 xsum=xsum+xxin
enddo

indaux=0
!Wage fixed effect Within and Between
thmn=xsum(indaux+2)/xsum(indaux+1)
psim(ipstat+1)=xsum(indaux+3)/xsum(indaux+1)
psim(ipstat+2)=xsum(indaux+4)/xsum(indaux+1)-thmn*thmn


ipstat=ipstat+2
indaux=indaux+4



!Wage Fixed Effect on Education
deallocate(xx,xxi,xy)
allocate(xx(2,2),xxi(2,2),xy(2),bols(4))
call outlxx(2,xsum(indaux+1:indaux+3),xx)
call Findinv(xx,xxi,2,ierror)
xy=xsum(indaux+4:indaux+5)
bols(1:2)=matmul(xxi,xy)
psim(ipstat+1)=bols(2)
indaux=indaux+5
ipstat=ipstat+1


!Work fixed effect Within and Between
thmn=xsum(indaux+2)/xsum(indaux+1)
psim(ipstat+1)=xsum(indaux+3)/xsum(indaux+1)-thmn*thmn


ipstat=ipstat+1
indaux=indaux+3



!Work Fixed Effect on Education
deallocate(xx,xxi,xy)
allocate(xx(2,2),xxi(2,2),xy(2))
call outlxx(2,xsum(indaux+1:indaux+3),xx)
call Findinv(xx,xxi,2,ierror)
xy=xsum(indaux+4:indaux+5)
bols(3:4)=matmul(xxi,xy)
psim(ipstat+1)=bols(2)
indaux=indaux+5
ipstat=ipstat+1


!Broadcast fixed effect to workers
call MPI_BCAST(bols, 4, MPI_DOUBLE_PRECISION, head, &
MPI_COMM_WORLD, ierr)
deallocate(xx,xxi,xy,bols)


!Get new set of moments
xsum=0.0d0
do i=1,numprocs-1
 call MPI_RECV(xxin,numaux, MPI_DOUBLE_PRECISION, &
 i, MPI_ANY_TAG, &
 MPI_COMM_WORLD, status, ierr)
 xsum=xsum+xxin
enddo

!Now combine everything for auxiliary parameters
indaux=0
!Fixed effects on each other
allocate(xx(2,2),xy(2),xxi(2,2),bols(2))
call outlxx(2,xsum(indaux+1:indaux+3),xx)
xy=xsum(indaux+4:indaux+5)
call Findinv(xx,xxi,2,ierror)
bols=matmul(xxi,xy)
psim(ipstat+1)=bols(2)
indaux=indaux+5
ipstat=ipstat+1
deallocate(xx,xy,xxi,bols)

!Marriage/Divorce
allocate(xx(36,36),xxi(36,36))
call outlxx(36,xsum(indaux+1:indaux+666),xx)
call Findinv(xx,xxi,36,ierror)
psim(ipstat+1:ipstat+36)=matmul(xxi,xsum(indaux+667:indaux+702))
psim(ipstat+37:ipstat+72)=matmul(xxi,xsum(indaux+703:indaux+738))
indaux=indaux+738
ipstat=ipstat+72
deallocate(xx,xxi)





!Marital transition
allocate(xx(6,6),xxi(6,6),xy(6),bols(6))
call outlxx(6,xsum(indaux+1:indaux+21),xx)
xy=xsum(indaux+22:indaux+27)
call Findinv(xx,xxi,6,ierror)
bols=matmul(xxi,xy)
psim(ipstat+1:ipstat+3)=bols(4:6)
call outlxx(6,xsum(indaux+28:indaux+48),xx)
xy=xsum(indaux+49:indaux+54)
call Findinv(xx,xxi,6,ierror)
bols=matmul(xxi,xy)
psim(ipstat+4:ipstat+6)=bols(4:6)

ipstat=ipstat+6
indaux=indaux+54




!Have Baby while Married
psim(ipstat+1)=xsum(indaux+2)/xsum(indaux+1)
indaux=indaux+2
ipstat=ipstat+1


!Have Baby and Wage
deallocate(xx,xxi,xy,bols)
allocate(xx(9,9),xxi(9,9),xy(9),bols(9))
call outlxx(9,xsum(indaux+1:indaux+45),xx)
xy=xsum(indaux+46:indaux+54)
call Findinv(xx,xxi,9,ierror)
bols=matmul(xxi,xy)
psim(ipstat+1:ipstat+2)=bols(2:3)
indaux=indaux+54
ipstat=ipstat+2




!Age Difference
psim(ipstat+1)=xsum(indaux+2)/xsum(indaux+1)
indaux=indaux+2
ipstat=ipstat+1



!Having Kids
deallocate(xx,xxi)
allocate(xx(37,37),xxi(37,37))
call outlxx(37,xsum(indaux+1:indaux+703),xx)
call Findinv(xx,xxi,37,ierror)
psim(ipstat+1:ipstat+37)=matmul(xxi,xsum(indaux+704:indaux+740))
ipstat=ipstat+37
psim(ipstat+1:ipstat+37)=matmul(xxi,xsum(indaux+741:indaux+777))
ipstat=ipstat+37
psim(ipstat+1:ipstat+37)=matmul(xxi,xsum(indaux+778:indaux+814))
ipstat=ipstat+37
indaux=indaux+814


!Work Transision
deallocate(xx,xxi)
allocate(xx(39,39),xxi(39,39))
call outlxx(39,xsum(indaux+1:indaux+780),xx)
call Findinv(xx,xxi,39,ierror)
psim(ipstat+1:ipstat+39)=matmul(xxi,xsum(indaux+781:indaux+819))
call outlxx(39,xsum(indaux+820:indaux+1599),xx)
call Findinv(xx,xxi,39,ierror)
psim(ipstat+40:ipstat+78)=matmul(xxi,xsum(indaux+1600:indaux+1638))
indaux=indaux+1638
ipstat=ipstat+78


!Work and Have Baby
psim(ipstat+1)=xsum(indaux+2)/xsum(indaux+1)
indaux=indaux+2
ipstat=ipstat+1





!Wage Growth Working
deallocate(xx,xxi)
allocate(xx(41,41),xxi(41,41))
call outlxx(41,xsum(indaux+1:indaux+861),xx)
call Findinv(xx,xxi,41,ierror)
psim(ipstat+1:ipstat+41)=matmul(xxi,xsum(indaux+862:indaux+902))
ipstat=ipstat+41
indaux=indaux+902

!Wage Growth Not Working
psim(ipstat+1)=xsum(indaux+2)/xsum(indaux+1)
ipstat=ipstat+1

! we don't use these two auxiliary parameters
psim(87)=pstat(87)
psim(81)=pstat(81)

! base objective function
f=0.0d0
do j=1,ipstat
 f=f+((psim(j)-pstat(j))/sepstat(j))**2
write(6,*) j,((psim(j)-pstat(j))/sepstat(j))**2,psim(j),pstat(j),sepstat(j)
enddo

!now put more weight on relevant parameters
do j=36,38
 f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=39,73
 f=f+10.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=74,82
 f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=84,88
 f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=161,166
  f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
f=f+100.0d0*((psim(167)-pstat(167))/sepstat(167))**2
f=f+100.0d0*((psim(168)-pstat(168))/sepstat(168))**2
f=f+100.0d0*((psim(169)-pstat(169))/sepstat(169))**2
f=f+100.0d0*((psim(170)-pstat(170))/sepstat(170))**2
f=f+100.0d0*((psim(207)-pstat(207))/sepstat(207))**2
f=f+100.0d0*((psim(244)-pstat(244))/sepstat(244))**2
f=f+100.0d0*((psim(281)-pstat(281))/sepstat(281))**2
do j=317,320
 f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=356,360
 f=f+100.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=361,396
 f=f+10.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo
do j=397,402
 f=f+800.0d0*((psim(j)-pstat(j))/sepstat(j))**2
enddo



return
end
