
use /Users/Chris1/Dropbox/SIPP/Newdat/1996/elast_wv_96
drop start_job1
append using /Users/Chris1/Dropbox/SIPP/Newdat/2001/elast_wv_101
append using /Users/Chris1/Dropbox/SIPP/Newdat/2004/elast_wv_104
drop epppnum
append using /Users/Chris1/Dropbox/SIPP/Newdat/2008/elast_wv_108
keep id sex sipp wave brthmn brthyr age race ed rwage calyr calmn hrs emp_b emp_c emp_d ms wgt numkids spsinc spspres kid_yr* kid_mn* tmomchl efbrthmo tfbrthyr elbirtmo tlbirtyr
replace age=trunc(age)
drop if age<18
drop if age>65

gen date=12*(calyr-80)+calmn
gen bdate=12*(brthyr-1980)+brthmn
gen agemn=date-bdate
gen gradyr=.
replace gradyr=brthyr+16 if ed<12
replace gradyr=brthyr+18 if ed==12 
replace gradyr=brthyr+20 if ed>12 & ed < 16 
replace gradyr=brthyr+22 if ed>=16  
gen gradmn=12*(gradyr-1980)+6
gen potexp=(date-gradmn)/12
keep if race==1

drop if potexp<=0
drop if potexp>35
gen pe=floor(potexp)

replace rwage=. if rwage<1
replace rwage=. if rwage>300
gen lwage=log(rwage)
keep if emp_c==1
xi: xtreg lwage i.pe  if sex==1, fe i(id) cluster(id)
predict wmale
xi: xtreg lwage i.pe  if sex==2, fe i(id) cluster(id)
predict wfem

sort pe
collapse wmale wfem, by(pe)
gen wm1=wmale[1]
gen wf1=wfem[1]
replace wmale=wmale-wm1
replace wfem=wfem-wf1

label variable pe "Potential Experience"
label variable wmale "Male Wage Profile"
label variable wfem "Female Wage Profile"
scatter wmale wfem pe, c(l l) s(i +)
graph export "rawprof.pdf",replace
save rawprof
