!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! Program to estimate hazard model of work and marriage for women
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
program mod

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!! Declare Paramters
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
use ggg
implicit double precision(a-h,o-z)
real ::u(nsim),uu(4)
double precision :: xbw(0:1),xbm(0:1),xbk,xbhc(0:1)
integer :: lstat(nmax,maxsp),mstat(nmax,maxsp,2),numkid(nmax)
double precision :: wage(nmax,maxsp)
integer :: idkp(nmax),ipe(nmax,maxsp)
integer :: idsv(nmax)
double precision :: akid(nmax),ayoung(nmax,maxsp),da(nmax,maxsp)
double precision ::  thhat(nmax,2),parvec(npar),nkat(0:7)
integer :: ithhat(nmax)
double precision :: xt(1),timek(3)
double precision, dimension(:), allocatable :: x,xy,xy2,xmn,bols,x2,xy3,Vi,Vi2,vi3,bols2,bols3
double precision, dimension(:,:), allocatable ::  xx,xxi,xx2,xxt,xxt2,V,V2,xxi2,V3
double precision :: scale(1), work(1000)
double precision :: Vbig(nmax,700),Var(700,700),ababy,ww
integer :: indV(700),insamp
double precision :: xbarwg(nmax,38),xbarwk(nmax,44)
double precision :: xbbarwg(38),xbbarwk(44),dtheta(nmax,2)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!! Initialize things
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Vbig=0.0d0 !Var/Cov matrix
indV=0     ! vector of dummies for whether variable is included in objective function


!Set up cutoffs for hazard spline
cut(1)=10.0d0
cut(2)=20.0d0
cut(3)=1.0d40


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!! Read in Data
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
alt7=0.0d0
pet=0.0d0
lstat=0
open (23,file='fordatw.raw')
lid=-100
nn=0
nobs=0
mstat=0
do i=1,1500000
 read(23,*,end=100) id,pet,lst,xt,mst,n18,n7,wgt,nkid,ng18,akidt,ayt,dat,ibabyt,iwvt,nkat
 if (id>lid) then
  lid=id
  nn=nn+1
  idkp(nn)=lid
  nsp=1
  xdat(nn,:)=xt
 else
  nsp=nsp+1
 endif
 Nobs(nn)=nsp
 lstat(nn,nsp)=lst
 if (mst==1) then
  mstat(nn,nsp,1)=1
 elseif (mst==2) then
  mstat(nn,nsp,2)=1
 endif
 potexp(nn,nsp)=pet
 numlt18(nn,nsp)=dble(n18)
 numlt7(nn,nsp)=dble(n7)
 numgt18(nn,nsp)=dble(ng18)
 numka(nn,nsp,:)=dble(nkat)
 wage(nn,nsp)=wgt
 numkid(nn)=nkid
 akid(nn)=akidt
 ayoung(nn,nsp)=ayt
 hadbaby(nn,nsp)=ibabyt
 ipe(nn,nsp)=int(pet)
 da(nn,nsp)=dat
 idsv(nn)=id
 iwave(nn,nsp)=iwvt
 if (n7>0) then
  alt7(nn,nsp)=1.0d0
 endif
enddo
100 continue



!Main part of the code-go through all of the different auxiliary models


ipstat=0
pstat=0.0d0
ipvb=0

!Fixed Effect Model-wages


! Parameters
allocate(x(38),xx(38,38),xy(38),xmn(38),xxt(38,38),xxi(38,38),bols(38))
xx=0.0d0
xy=0.0d0
nt=0
do i=1,nn
 ni=0
 xmn=0.0d0
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   if (ipe(i,isp)>0) then
    xmn(ipe(i,isp))=xmn(ipe(i,isp))+1.0d0
   endif
   xmn(36)=xmn(36)+numlt18(i,isp)
   xmn(37)=xmn(37)+numlt7(i,isp)
   xmn(38)=xmn(38)+dble(mstat(i,isp,1))
   ni=ni+1
  endif
 enddo
 if (ni>0) then
  xmn=xmn/dble(ni)
 endif
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   x=(/zerosd,numlt18(i,isp),numlt7(i,isp),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x(ipe(i,isp))=1.0d0
   endif
   call outer(38,x-xmn,xxt)
   xx=xx+xxt
   xy=xy+(x-xmn)*wage(i,isp)
  endif
 enddo
enddo

call Findinv(xx,xxi,38,ierror)
bols=matmul(xxi,xy)

! Now Var/Cov
allocate(V(38,38),Vi(38))

V=0.0d0
xy=0.0d0
do i=1,nn
 ni=0
 xmn=0.0d0
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   if (ipe(i,isp)>0) then
    xmn(ipe(i,isp))=xmn(ipe(i,isp))+1.0d0
   endif
   xmn(36)=xmn(36)+numlt18(i,isp)
   xmn(37)=xmn(37)+numlt7(i,isp)
   xmn(38)=xmn(38)+dble(mstat(i,isp,1))
   ni=ni+1
  endif
 enddo
 if (ni>0) then
  xmn=xmn/dble(ni)
 endif
 vi=0.0d0
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   x=(/zerosd,numlt18(i,isp),numlt7(i,isp),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x(ipe(i,isp))=1.0d0
   endif
   vi=vi+(x-xmn)*(wage(i,isp)-dot_product(x-xmn,bols))
  endif
 enddo
 call outer(38,vi,xxt)
 V=V+xxt
 Vbig(i,1:38)=-vi
enddo
VBIG(:,1:38)=matmul(Vbig(:,1:38),xxi)

pstat(ipstat+1:ipstat+38)=bols
V=matmul(xxi,matmul(V,xxi))
do j=1,38
 sepstat(ipstat+j)=sqrt(V(j,j))
enddo

indv(1:38)=1

ipstat=ipstat+38
ipvb=ipvb+38
write(6,*) 'wage fixed effect',ipstat,sum(indv),ipvb



deallocate(x,xx,xxi,xy,xxt,vi,V,xmn)



!Fixed Effect Model-working


!Estimate
allocate(x(44),xx(44,44),xy(44),xmn(44),xxt(44,44),xxi(44,44),bols2(44))
xx=0.0d0
xy=0.0d0
nt=0
do i=1,nn
 ni=0
 xmn=0.0d0
 do isp=1,nobs(i)
   if (ipe(i,isp)>0) then
    xmn(ipe(i,isp))=xmn(ipe(i,isp))+1.0d0
   endif
   xmn(36:43)=xmn(36:43)+numka(i,isp,:)
   xmn(44)=xmn(44)+dble(mstat(i,isp,1))
   ni=ni+1
 enddo
 if (ni>0) then
  xmn=xmn/dble(ni)
 endif
 do isp=1,nobs(i)
   x=(/zerosd,numka(i,isp,:),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x(ipe(i,isp))=1.0d0
   endif
   call outer(44,x-xmn,xxt)
   xx=xx+xxt
   xy=xy+(x-xmn)*dble(lstat(i,isp))
 enddo
enddo

call Findinv(xx,xxi,44,ierror)
bols2=matmul(xxi,xy)



! Var/Cov
allocate(V(44,44),Vi(44))

V=0.0d0
xy=0.0d0
do i=1,nn
 ni=0
 xmn=0.0d0
 do isp=1,nobs(i)
   if (ipe(i,isp)>0) then
    xmn(ipe(i,isp))=xmn(ipe(i,isp))+1.0d0
   endif
   xmn(36:43)=xmn(36:43)+numka(i,isp,:)
   xmn(44)=xmn(44)+dble(mstat(i,isp,1))
   ni=ni+1
 enddo
 if (ni>0) then
  xmn=xmn/dble(ni)
 endif
 vi=0.0d0
 do isp=1,nobs(i)
   x=(/zerosd,numka(i,isp,:),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x(ipe(i,isp))=1.0d0
   endif
   vi=vi+(x-xmn)*(lstat(i,isp)-dot_product(x-xmn,bols2))
 enddo
 call outer(44,vi,xxt)
 V=V+xxt
 Vbig(i,ipstat+1:ipstat+44)=-vi
enddo
VBIG(:,ipstat+1:ipstat+44)=matmul(Vbig(:,ipstat+1:ipstat+44),xxi)


pstat(ipstat+1:ipstat+44)=bols2
V=matmul(xxi,matmul(V,xxi))
do j=1,44
 sepstat(ipstat+j)=sqrt(V(j,j))
enddo

indv(ipstat+1:ipstat+44)=1

ipstat=ipstat+44
ipvb=ipvb+44
write(6,*) 'work fixed effect',ipstat,sum(indv),ipvb
deallocate(x,xx,xxi,xy,xxt,vi,V)

! Within and Between Variance  and regression of FE on ed

!estimates
allocate(x(2),xx(2,2),xxi(2,2),xy(2),xxt(2,2),x2(38),vi(2),V(2,2),bols3(2))
thhat=0.0d0
ithhat=0
xx=0.0d0
xy=0.0d0
ntot=0
thmn=0.0d0
itest=0
xbarwg=0.0d0
xbbarwg=0.0d0
do i=1,nn
 ni=0
 thsum=0.0d0
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   ni=ni+1
   x2=(/zerosd,numlt18(i,isp),numlt7(i,isp),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x2(ipe(i,isp))=1.0d0
   endif
   thsum=thsum+wage(i,isp)-dot_product(x2,bols)
   thmn=thmn+wage(i,isp)-dot_product(x2,bols)
   xbarwg(i,:)=xbarwg(i,:)+x2
   ntot=ntot+1
  endif
 enddo
 if (ni>0) then
  thhat(i,1)=thsum/dble(ni)
  xbarwg(i,:)=xbarwg(i,:)/dble(ni)
  xbbarwg=xbbarwg+xbarwg(i,:)
  x=(/1.0d0,xdat(i,:)/)
  call outer(2,x,xxt)
  xx=xx+xxt
  xy=xy+x*thhat(i,1)
  itest=itest+1
 else
  ithhat(i)=1
 endif
enddo
thmn=thmn/dble(ntot)
xbbarwg=xbbarwg/dble(ntot)

vt=0.0d0
vw=0.0d0
vb=0.0d0
do i=1,nn
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   x2=(/zerosd,numlt18(i,isp),numlt7(i,isp),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x2(ipe(i,isp))=1.0d0
   endif
   vw=vw+(wage(i,isp)-dot_product(x2,bols)-thhat(i,1))**2
   vt=vt+(wage(i,isp)-dot_product(x2,bols)-thmn)**2
   vb=vb+(thhat(i,1)-thmn)**2
  endif
 enddo
enddo

pstat(ipstat+1)=vw/dble(ntot)
pstat(ipstat+2)=vb/dble(ntot)
indv(ipstat+1:ipstat+2)=1



!Var/Cov
V=0.0d0
do i=1,nn
 vi=0.0d0
 do isp=1,nobs(i)
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   x2=(/zerosd,numlt18(i,isp),numlt7(i,isp),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x2(ipe(i,isp))=1.0d0
   endif
   vi(1)=vi(1)+vw/dble(ntot)-(wage(i,isp)-dot_product(x2,bols)-thhat(i,1))**2
   vi(1)=vi(1)+2.0*(wage(i,isp)-dot_product(x2,bols)-thhat(i,1))*dot_product(x2-xbarwg(i,:),Vbig(i,1:38))
   vi(2)=vi(2)+vb/dble(ntot)-(thhat(i,1)-thmn)**2
   vi(2)=vi(2)+2.0*(thhat(i,1)-thmn)*dot_product(xbarwg(i,:)-xbbarwg,Vbig(i,1:38))
  endif
 enddo
 Vbig(i,ipvb+1)=-vi(1)/dble(ntot)
 Vbig(i,ipvb+2)=-vi(2)/dble(ntot)
 V(1,1)=V(1,1)+vi(1)*vi(1)
 V(2,2)=V(2,2)+vi(2)*vi(2)
enddo

sepstat(ipstat+1)=dsqrt(V(1,1))/dble(ntot)
sepstat(ipstat+2)=dsqrt(V(2,2))/dble(ntot)
ipstat=ipstat+2
ipvb=ipvb+2
write(6,*) 'Within and Between variance',ipstat,sum(indv),ipvb


!Fixed Effect on Education
call Findinv(xx,xxi,2,ierror)
bols3=matmul(xxi,xy)
pstat(ipstat+1)=bols3(2)


!Var/Cov
V=0.0d0
do i=1,nn
 if (ithhat(i)==0) then
  x=(/1.0d0,xdat(i,:)/)
  thhat(i,1)=thhat(i,1)-dot_product(x,bols3)
  vi=x*thhat(i,1)+x*dot_product(xbarwg(i,:),Vbig(i,1:38))
  Vbig(i,ipvb+1:ipvb+2)=-vi
  call outer(2,vi,xxt)
  V=V+xxt
 endif
enddo
V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+2)=matmul(Vbig(:,ipvb+1:ipvb+2),xxi)
sepstat(ipstat+1)=sqrt(V(2,2))
do i=1,nn
 if (ithhat(i)==0) then
  x=(/1.0d0,xdat(i,:)/)
  dtheta(i,1)=-dot_product(xbarwg(i,:),Vbig(i,1:38))-dot_product(x,Vbig(i,ipvb+1:ipvb+2))
 endif
enddo

ipstat=ipstat+1
indv(ipvb+2)=1
ipvb=ipvb+2
write(6,*) 'Wage Fixed Effect on Education',ipstat,sum(indv),ipvb

deallocate(x2)

! FE work Variance  and regression of FE on ed
!  estimates
allocate(x2(44))
xx=0.0d0
xy=0.0d0
ntot=0
thmn=0.0d0
xbarwk=0.0d0
xbbarwk=0.0d0
do i=1,nn
 ni=0
 thsum=0.0d0
 do isp=1,nobs(i)
   ni=ni+1
   x2=(/zerosd,numka(i,isp,:),dble(mstat(i,isp,1))/)
   if (ipe(i,isp)>0) then
    x2(ipe(i,isp))=1.0d0
   endif
   thsum=thsum+lstat(i,isp)-dot_product(x2,bols2)
   thmn=thmn+lstat(i,isp)-dot_product(x2,bols2)
   xbarwk(i,:)=xbarwk(i,:)+x2
   ntot=ntot+1
 enddo
 thhat(i,2)=thsum/dble(ni)
 xbarwk(i,:)=xbarwk(i,:)/dble(ni)
 xbbarwk=xbbarwk+xbarwk(i,:)
 x=(/1.0d0,xdat(i,:)/)
 call outer(2,x,xxt)
 xx=xx+xxt
 xy=xy+x*thhat(i,2)
enddo
thmn=thmn/dble(ntot)
xbbarwk=xbbarwk/dble(ntot)

vb=0.0d0
do i=1,nn
 do isp=1,nobs(i)
  vb=vb+(thhat(i,2)-thmn)**2
 enddo
enddo

pstat(ipstat+1)=vb/dble(ntot)
indv(ipvb+1)=1



!Var/Cov for worker between
V=0.0d0
do i=1,nn
 vi=0.0d0
 do isp=1,nobs(i)
  vi(2)=vi(2)+vb/dble(ntot)-(thhat(i,2)-thmn)**2
  vi(2)=vi(2)+2.0*(thhat(i,2)-thmn)*dot_product(xbarwk(i,:)-xbbarwk,Vbig(i,39:82))
 enddo
 Vbig(i,ipvb+1)=-vi(2)/dble(ntot)
 V(2,2)=V(2,2)+vi(2)*vi(2)
enddo

sepstat(ipstat+1)=dsqrt(V(2,2))/dble(ntot)
ipstat=ipstat+1
ipvb=ipvb+1
write(6,*) 'Work Between variance',ipstat,sum(indv),ipvb


!estimate fixed effect on education
call Findinv(xx,xxi,2,ierror)
bols3=matmul(xxi,xy)
pstat(ipstat+1)=bols3(2)

!Var/Cov
V=0.0d0
do i=1,nn
 x=(/1.0d0,xdat(i,:)/)
 thhat(i,2)=thhat(i,2)-dot_product(x,bols3)
 vi=x*thhat(i,2)+x*dot_product(xbarwk(i,:),Vbig(i,39:82))
 Vbig(i,ipvb+1:ipvb+2)=-vi
 call outer(2,vi,xxt)
 V=V+xxt
enddo
V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+2)=matmul(Vbig(:,ipvb+1:ipvb+2),xxi)
sepstat(ipstat+1)=sqrt(V(2,2))
do i=1,nn
 x=(/1.0d0,xdat(i,:)/)
 dtheta(i,2)=-dot_product(xbarwk(i,:),Vbig(i,39:82))-dot_product(x,Vbig(i,ipvb+1:ipvb+2))
enddo

ipstat=ipstat+1
indv(ipvb+2)=1
ipvb=ipvb+2
write(6,*) 'work fixed effect on education',ipstat,sum(indv),ipvb

! Regression of theta hats

!estimates
xx=0.0d0
xy=0.0d0
do i=1,nn
 if (ithhat(i)==0) then
  x=(/1.0d0,thhat(i,2)/)
  call outer(2,x,xxt)
  xx=xx+xxt
  xy=xy+x*thhat(i,1)
 endif
enddo
call Findinv(xx,xxi,2,ierror)
bols3=matmul(xxi,xy)
pstat(ipstat+1)=bols3(2)


!Var/cov
V=0.0d0
do i=1,nn
 if (ithhat(i)==0) then
  x=(/1.0d0,thhat(i,2)/)
  thhat(i,1)=thhat(i,1)-dot_product(x,bols3)
  vi=x*(thhat(i,1)-dtheta(i,1)-bols(2)*dtheta(i,2))
  vi(2)=vi(2)+dtheta(i,1)*thhat(i,1)
  Vbig(i,ipvb+1:ipvb+2)=-vi
  call outer(2,vi,xxt)
  V=V+xxt
 endif
enddo
V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+2)=matmul(Vbig(:,ipvb+1:ipvb+2),xxi)
sepstat(ipstat+1)=sqrt(V(2,2))

ipstat=ipstat+1
indv(ipvb+2)=1
ipvb=ipvb+2
write(6,*) 'Fixed Effect on Fixed Effect',ipstat,sum(indv),ipvb



!Fixed effect coded as missing when it should be
do i=1,nn
 if ((sum(lstat(i,:))>0).and.(ithhat(i)==1)) then
  ithhat(i)=2
 endif
enddo



! Marriage probability

!estimate
deallocate(x,xx,xxi,xy,xxt,bols,vi,v,bols2)
allocate(x(36),xx(36,36),xxi(36,36),xy(36),xxt(36,36),bols(36),vi(36),V(36,36), &
   xy2(36),bols2(36),vi2(36),V2(36,36))
xx=0.0d0
xy=0.0d0
xy2=0.0d0
do i=1,nn
  x=0.0d0
  x(ipe(i,1)+1)=1.0d0
  call outer(36,x,xxt)
  xx=xx+xxt
  xy=xy+x*dble(mstat(i,1,1))
  xy2=xy2+x*dble(mstat(i,1,2))
enddo

call Findinv(xx,xxi,36,ierror)
bols=matmul(xxi,xy)
bols2=matmul(xxi,xy2)

pstat(ipstat+1:ipstat+36)=bols
pstat(ipstat+37:ipstat+72)=bols2
indv(ipvb+1:ipvb+72)=1

!Var/Cov
V=0.0d0
x=0.0d0
do i=1,nn
 x=0.0d0
 x(ipe(i,1)+1)=1.0d0
 vi=x*dble(mstat(i,1,1)-dot_product(x,bols))
 Vbig(i,ipvb+1:ipvb+36)=-vi
 vi2=x*dble(mstat(i,1,2)-dot_product(x,bols2))
 Vbig(i,ipvb+37:ipvb+72)=-vi2
 call outer(36,vi,xxt)
 V=V+xxt
 call outer(36,vi2,xxt)
 V2=V2+xxt
enddo

V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+36)=matmul(Vbig(:,ipvb+1:ipvb+36),xxi)
V2=matmul(xxi,matmul(V2,xxi))
Vbig(:,ipvb+37:ipvb+72)=matmul(Vbig(:,ipvb+37:ipvb+72),xxi)
do j=1,36
 sepstat(ipstat+j)=sqrt(V(j,j))
 sepstat(ipstat+36+j)=sqrt(V2(j,j))
enddo


ipstat=ipstat+72
ipvb=ipvb+72
write(6,*) 'Marriage/Divorce',ipstat,sum(indv),ipvb


! Conditional probability of marriage transition
deallocate(x,xx,xxi,xy,xxt,bols,vi,V,x2,bols2,xy2,V2,vi2)
allocate(x(6),xx(6,6),xxi(6,6),xy(6),xxt(6,6),bols(6),V(6,6),Vi(6))
allocate(x2(6),xx2(6,6),xxi2(6,6),xy2(6),xxt2(6,6),bols2(6),V2(6,6),Vi2(6))
xx=0.0d0
xy=0.0d0
xx2=0.0d0
xy2=0.0d0
do i=1,NN
 do isp=4,nobs(i)
  if ((wage(i,isp-3)>-20.0d0).or.(lstat(i,isp-3)==0)) then
   if (lstat(i,isp-3)==0) then
    wtemp=0.0d0
   else
    wtemp=wage(i,isp-3)
   endif
   x=(/1.0d0,potexp(i,isp),potexp(i,isp)*potexp(i,isp),xdat(i,1),wtemp,dble(lstat(i,isp-3))/)
   call outer(6,x,xxt)
   if (mstat(i,isp-1,1)==0) then
    xx=xx+xxt
    xy=xy+x*dble(mstat(i,isp,1))
   else
    xx2=xx2+xxt
    xy2=xy2+x*dble(mstat(i,isp,2))
   endif
  endif
 enddo
enddo


call Findinv(xx,xxi,6,ierror)
bols=matmul(xxi,xy)
call Findinv(xx2,xxi2,6,ierror)
bols2=matmul(xxi2,xy2)
pstat(ipstat+1:ipstat+3)=bols(4:6)
indv(ipvb+4:ipvb+6)=1

pstat(ipstat+4:ipstat+6)=bols2(4:6)
indv(ipvb+10:ipvb+12)=1

!Var/cov
V=0.0d0
V2=0.0d0
do i=1,NN
 Vi=0.0d0
 Vi2=0.0d0
 do isp=4,nobs(i)
  if ((wage(i,isp-3)>-20.0d0).or.(lstat(i,isp-3)==0)) then
   if (lstat(i,isp-3)==0) then
    wtemp=0.0d0
   else
    wtemp=wage(i,isp-3)
   endif
   x=(/1.0d0,potexp(i,isp),potexp(i,isp)*potexp(i,isp),xdat(i,1),wtemp,dble(lstat(i,isp-3))/)
   if (mstat(i,isp-1,1)==0) then
    vi=vi+x*(dble(mstat(i,isp,1))-dot_product(x,bols))
   else
    vi2=vi2+x*(dble(mstat(i,isp,2))-dot_product(x,bols2))
   endif
  endif
 enddo
 call outer(6,vi,xxt)
 V=V+xxt
 call outer(6,vi2,xxt2)
 V2=V2+xxt2
 Vbig(i,ipvb+1:ipvb+6)=-vi
 Vbig(i,ipvb+7:ipvb+12)=-vi2
enddo

V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+6)=matmul(Vbig(:,ipvb+1:ipvb+6),xxi)
do j=1,3
sepstat(ipstat+j)=sqrt(V(j+3,j+3))
enddo

V2=matmul(xxi2,matmul(V2,xxi2))
Vbig(:,ipvb+7:ipvb+12)=matmul(Vbig(:,ipvb+7:ipvb+12),xxi2)
do j=1,3
sepstat(ipstat+3+j)=sqrt(V2(j+3,j+3))
enddo


ipstat=ipstat+6
ipvb=ipvb+12
write(6,*) 'Get Married/Divorced',ipstat,sum(indv),ipvb

!Having Children and Married
tnsps=0.0d0
tsps=0.0d0
do i=1,nn
 do isp=2,nobs(i)
  if (hadbaby(i,isp)==1) then
   tsps=tsps+dble(mstat(i,isp-1,1))
   tnsps=tnsps+1.0d0
  endif
 enddo
enddo

!variance
spsmn=tsps/tnsps
spsvar=0.0d0
do i=1,nn
 svi=0.0d0
 do isp=2,nobs(i)
  if (hadbaby(i,isp)==1) then
   svi=svi+(dble(mstat(i,isp-1,1))-spsmn)
  endif
 enddo
 spsvar=spsvar+(svi)**2
 Vbig(i,ipvb+1)=-svi/tnsps
enddo
spsvar=spsvar/tnsps**2
pstat(ipstat+1)=spsmn
indv(ipvb+1)=1
sepstat(ipstat+1)=sqrt(spsvar)
ipstat=ipstat+1
ipvb=ipvb+1
write(6,*) 'Have Kid Married',ipstat,sum(indv),ipvb

!Having Children and Wage


deallocate(x,xx,xxt,xxi,xy,V,vi,bols2)
allocate(x(9),xx(9,9),xxt(9,9),xxi(9,9),xy(9),V(9,9),vi(9),bols2(9))

xx=0.0d0
xy=0.0d0
do i=1,nn
 ababy=0.0d0
 insamp=0
 do isp=2,nobs(i)
  if (potexp(i,isp)>=potexp(i,1)+0.99) then
   insamp=1
   if (hadbaby(i,isp)==1) then
    ababy=1.0d0
   endif
  endif
 enddo
 if (lstat(i,1)==1) then
  ww=wage(i,1)
 else
  ww=0.0d0
 endif
 if ((ww>-10.0d0).and.(insamp==1)) then
  x=(/1.0d0,ww,dble(lstat(i,1)),xdat(i,1),dble(mstat(i,1,1)),numlt7(i,1), numlt18(i,1),potexp(i,1), &
     potexp(i,1)*potexp(i,1) /)
  call outer(9,x,xxt)
  xx=xx+xxt
  xy=xy+x*ababy
  ic=ic+1
 endif
enddo

call Findinv(xx,xxi,9,ierror)
bols2=matmul(xxi,xy)
pstat(ipstat+1:ipstat+2)=bols2(2:3)
indv(ipvb+2:ipvb+3)=1

!Variance
V=0.0d0
do i=1,nn
 ababy=0.0d0
 insamp=0
 do isp=2,nobs(i)
  if (potexp(i,isp)>=potexp(i,1)+0.99) then
   insamp=1
   if (hadbaby(i,isp)==1) then
    ababy=1.0d0
   endif
  endif
 enddo
 if (lstat(i,1)==1) then
  ww=wage(i,1)
 else
  ww=0.0d0
 endif
 if ((ww>-10.0d0).and.(insamp==1)) then
  x=(/1.0d0,ww,dble(lstat(i,1)),xdat(i,1),dble(mstat(i,1,1)),numlt7(i,1), numlt18(i,1),potexp(i,1), &
     potexp(i,1)*potexp(i,1) /)
  vi=x*(ababy-dot_product(x,bols2))
  call outer(9,vi,xxt)
  V=V+xxt
  Vbig(i,ipvb+1:ipvb+9)=-vi
 endif
enddo

V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+9)=matmul(Vbig(:,ipvb+1:ipvb+9),xxi)
sepstat(ipstat+1)=dsqrt(V(2,2))
sepstat(ipstat+2)=dsqrt(V(3,3))

ipstat=ipstat+2
ipvb=ipvb+9
write(6,*) 'Have Kid Wage',ipstat,sum(indv),ipvb



!Age Difference
aden=0.0d0
adnum=0.0d0
do i=1,nn
 if (da(i,1)>0.0d0) then
  aden=aden+1.0d0
  adnum=adnum+da(i,1)
 endif
enddo
amn=adnum/aden
pstat(ipstat+1)=amn
indv(ipvb+1)=1

!Variance
adnum=0.0d0
avar=0.0d0
do i=1,nn
 if (da(i,1)>0.0d0) then
  avar=avar+(da(i,1)-amn)**2
  Vbig(i,ipvb+1)=-(da(i,1)-amn)/aden
 endif
enddo
avar=avar/aden**2
sepstat(ipstat+1)=sqrt(avar)
ipstat=ipstat+1
ipvb=ipvb+1
write(6,*) 'Age Difference',ipstat,sum(indv),ipvb

!Having Kids
deallocate(x,xx,xxi,xy,xxt,xy2,bols,bols2,bols3)
allocate(x(37),xx(37,37),xxi(37,37),xy(37),xy2(37),xy3(37),xxt(37,37))
allocate(bols(37),bols2(37),bols3(37))
xx=0.0d0
xy=0.0d0
xy2=0.0d0
xy3=0.0d0
do i=1,nn
 if (numkid(i)>=0) then
  do isp=1,nobs(i)
   if (iwave(i,isp)==2) then
    x=(/zeros,xdat(i,:)/)
    x(ipe(i,isp)+1)=1.0d0
    call outer(37,x,xxt)
    xx=xx+xxt
    if (numkid(i)>0) then
     xy=xy+x
    endif
    if (numkid(i)==2) then
     xy2=xy2+x
    endif
    xy3=xy3+x*dble(numkid(i))
   endif
  enddo
 endif
enddo
call Findinv(xx,xxi,37,ierror)
bols=matmul(xxi,xy)
bols2=matmul(xxi,xy2)
bols3=matmul(xxi,xy3)

!Var/Cov
deallocate(V,V2,vi,vi2)
allocate(V(37,37),V2(37,37),V3(37,37),vi(37),vi2(37),vi3(37))

V=0.0d0
V2=0.0d0
V3=0.0d0
do i=1,nn
 vi=0.0d0
 vi2=0.0d0
 vi3=0.0d0
 if (numkid(i)>=0) then
  do isp=1,nobs(i)
   if (iwave(i,isp)==2) then
    x=(/zeros,xdat(i,:)/)
    x(ipe(i,isp)+1)=1.0d0
    call outer(37,x,xxt)
    xx=xx+xxt
    if (numkid(i)>0) then
     vi=vi+x*(1.0d0-dot_product(x,bols))
    else
     vi=vi+x*(-dot_product(x,bols))
    endif
    if (numkid(i)==2) then
     vi2=vi2+x*(1.0d0-dot_product(x,bols2) )
    else
     vi2=vi2+x*(-dot_product(x,bols2))
    endif
    vi3=vi3+x*(dble(numkid(i))-dot_product(x,bols3))
   endif
  enddo
  call outer(37,vi,xxt)
  V=V+xxt
  Vbig(i,ipvb+1:ipvb+37)=-vi
  call outer(37,vi2,xxt)
  V2=V2+xxt
  Vbig(i,ipvb+38:ipvb+74)=-vi2
  call outer(37,vi3,xxt)
  V3=V3+xxt
  Vbig(i,ipvb+75:ipvb+111)=-vi3
 endif
enddo
V=matmul(xxi,matmul(V,xxi))
V2=matmul(xxi,matmul(V2,xxi))
V3=matmul(xxi,matmul(V3,xxi))
Vbig(:,ipvb+1:ipvb+37)=matmul(Vbig(:,ipvb+1:ipvb+37),xxi)
Vbig(:,ipvb+38:ipvb+74)=matmul(Vbig(:,ipvb+38:ipvb+74),xxi)
Vbig(:,ipvb+75:ipvb+111)=matmul(Vbig(:,ipvb+75:ipvb+111),xxi)

do j=1,37
 pstat(ipstat+j)=bols(j)
 sepstat(ipstat+j)=sqrt(V(j,j))
 pstat(ipstat+37+j)=bols2(j)
 sepstat(ipstat+37+j)=sqrt(V2(j,j))
 pstat(ipstat+74+j)=bols3(j)
 sepstat(ipstat+74+j)=sqrt(V3(j,j))
enddo
indv(ipvb+1:ipvb+111)=1
ipstat=ipstat+111
ipvb=ipvb+111
write(6,*) 'Having Kids',ipstat,sum(indv),ipvb


! Conditional probability of working transition
deallocate(xx,xxi,xy,xxt,x,bols,xxt2,bols2,xxi2)
allocate(x(39),xx(39,39),xxi(39,39),xy(39),xxt(39,39),bols(39))
deallocate(xx2,xy2,x2)
allocate(x2(39),xx2(39,39),xy2(39),xxt2(39,39),bols2(39),xxi2(39,39))
xx=0.0d0
xy=0.0d0
xx2=0.0d0
xy2=0.0d0
do i=1,NN
 do isp=1,nobs(i)-1
  x=(/zerosd,xdat(i,:),dble(mstat(i,isp,1)),numlt7(i,isp),thhat(i,2) /)
  x(ipe(i,isp)+1)=1.0d0
  call outer(39,x,xxt)
  if (lstat(i,isp)==0) then
   xx=xx+xxt
   xy=xy+x*dble(lstat(i,isp+1))
  else
   xx2=xx2+xxt
   xy2=xy2+x*dble(lstat(i,isp+1))
  endif
 enddo
enddo
call Findinv(xx,xxi,39,ierror)
bols=matmul(xxi,xy)
pstat(ipstat+1:ipstat+39)=bols

!Variance/Covariance
call Findinv(xx2,xxi2,39,ierror)
bols2=matmul(xxi2,xy2)
pstat(ipstat+40:ipstat+78)=bols2
indv(ipvb+1:ipvb+78)=1
deallocate(V,V2,vi,vi2)
allocate(V(39,39),vi(39),V2(39,39),vi2(39))
V=0.0d0
V2=0.0d0
do i=1,NN
 vi=0.0d0
 vi2=0.0d0
 do isp=1,nobs(i)-1
  x=(/zerosd,xdat(i,:),dble(mstat(i,isp,1)),numlt7(i,isp),thhat(i,2) /)
  x(ipe(i,isp)+1)=1.0d0
  call outer(39,x,xxt)
  if (lstat(i,isp)==0) then
   vi=vi+x*(dble(lstat(i,isp+1))-dot_product(x,bols))
   vi=vi-x*bols(39)*dtheta(i,2)
   vi(39)=vi(39)+dtheta(i,2)*(dble(lstat(i,isp+1))-dot_product(x,bols))
  else
   vi2=vi2+x*(dble(lstat(i,isp+1))-dot_product(x,bols2))
   vi2=vi2-x*bols2(39)*dtheta(i,2)
   vi2(39)=vi2(39)+dtheta(i,2)*(dble(lstat(i,isp+1))-dot_product(x,bols2))
  endif
 enddo
 call outer(39,vi,xxt)
 V=V+xxt
 Vbig(i,ipvb+1:ipvb+39)=-vi
 call outer(39,vi2,xxt2)
 V2=V2+xxt2
 Vbig(i,ipvb+40:ipvb+78)=-vi2
enddo

V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+39)=matmul(Vbig(:,ipvb+1:ipvb+39),xxi)
do j=1,39
 sepstat(ipstat+j)=dsqrt(V(j,j))
enddo

V2=matmul(xxi2,matmul(V2,xxi2))
Vbig(:,ipvb+40:ipvb+78)=matmul(Vbig(:,ipvb+40:ipvb+78),xxi2)
do j=1,39
 sepstat(ipstat+39+j)=dsqrt(V2(j,j))
enddo


ipstat=ipstat+78
ipvb=ipvb+78
write(6,*) 'Find/Lose Work',ipstat,sum(indv),ipvb

!Having Children and working
tnw=0.0d0
tw=0.0d0
do i=1,nn
 do isp=2,nobs(i)
  if (hadbaby(i,isp)==1) then
   if (isp>2) then
    tw=tw+dble(lstat(i,isp-2))
    tnw=tnw+1.0d0
   endif
  endif
 enddo
enddo
wkmn=tw/tnw


!Var/Cov
wkvar=0.0d0
do i=1,nn
 wvi=0.0d0
 do isp=2,nobs(i)
  if (hadbaby(i,isp)==1) then
   if (isp>2) then
    wvi=wvi+(dble(lstat(i,isp-2))-wkmn)
   endif
  endif
 enddo
 wkvar=wkvar+(wvi)**2
 Vbig(i,ipvb+1)=-wvi/tnw
enddo
wkvar=wkvar/tnw**2
pstat(ipstat+1)=wkmn
indv(ipvb+1)=1
sepstat(ipstat+1)=sqrt(wkvar)
ipstat=ipstat+1
ipvb=ipvb+1
write(6,*) 'Work/Kid',ipstat,sum(indv),ipvb




!Wage growth

deallocate(x,x2,xx,xxt,xy,bols,v,vi,bols2,xx2,xxt2,xy2,v2,vi2)
allocate(x(41),xx(41,41),xxt(41,41),xy(41),x2(1),xx2(1,1),xxt2(1,1),xy2(1),bols(41),bols2(1))
allocate(v(41,41),vi(41),v2(1,1),vi2(1))

wagel=0.0d0
xx=0.0d0
xx2=0.0d0
xy=0.0d0
xy2=0.0d0
do i=1,NN
 lisp=0
 do isp=1,nobs(i)
  if ((lisp>0).and.(lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   if (lisp==isp-1) then
    if (numgt18(i,isp)>=0) then
     x=(/zeros,xdat(i,:),dble(mstat(i,lisp,1)),numgt18(i,isp),xdat(i,1)*potexp(i,isp), &
              xdat(i,1)*numgt18(i,isp)/)
     x(ipe(i,isp)+1)=1.0d0
     call outer(41,x,xxt)
     xx=xx+xxt
     xy=xy+x*(wage(i,isp)-wagel)
    endif
   elseif (lstat(i,isp-1)==0) then
    dpe=potexp(i,isp)-pel
    x2=dpe
    call outer(1,x2,xxt2)
    xx2=xx2+xxt2
    xy2=xy2+x2*(wage(i,isp)-wagel)
   endif
  endif
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   lisp=isp
   wagel=wage(i,isp)
   pel=potexp(i,isp)
  endif
 enddo
enddo


deallocate(xxi)
allocate(xxi(41,41))
call Findinv(xx,xxi,41,ierror)
bols=matmul(xxi,xy)


deallocate(xxi2)
allocate(xxi2(1,1))
call Findinv(xx2,xxi2,1,ierror)
bols2=matmul(xxi2,xy2)


!Var/Cov for contuously employed
V=0.0d0
V2=0.0d0
xy2=0.0d0
aatest=0.0d0
do i=1,NN
 lisp=0
 vi=0.0d0
 vi2=0.0d0
 do isp=1,nobs(i)
  if ((lisp>0).and.(lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   if (lisp==isp-1) then
    if (numgt18(i,isp)>=0) then
     x=(/zeros,xdat(i,:),dble(mstat(i,lisp,1)),numgt18(i,isp),xdat(i,1)*potexp(i,isp), &
              xdat(i,1)*numgt18(i,isp)/)
     x(ipe(i,isp)+1)=1.0d0
     vi=vi+x*(wage(i,isp)-wagel-dot_product(x,bols))
    endif
   elseif (lstat(i,isp-1)==0) then
    dpe=potexp(i,isp)-pel
    x2=dpe
    vi2=vi2+x2*(wage(i,isp)-wagel-x2*bols2)
   endif
  endif
  if ((lstat(i,isp)==1).and.(wage(i,isp)>-10.0d0)) then
   lisp=isp
   wagel=wage(i,isp)
   pel=potexp(i,isp)
  endif
 enddo
 xy2=xy2+vi2
 call outer(41,vi,xxt)
 V=V+xxt
 Vbig(i,ipvb+1:ipvb+41)=-vi
 call outer(1,vi2,xxt2)
 V2=V2+xxt2
 Vbig(i,ipvb+42)=-vi2(1)
enddo

!Variance/Cov for continously aemployed
V=matmul(xxi,matmul(V,xxi))
Vbig(:,ipvb+1:ipvb+41)=matmul(Vbig(:,ipvb+1:ipvb+41),xxi)
do j=1,41
 pstat(ipstat+j)=bols(j)
 sepstat(ipstat+j)=sqrt(V(j,j))
enddo
ipstat=ipstat+41
indv(ipvb+1:ipvb+41)=1
ipvb=ipvb+41
write(6,*) 'Wage Change for Continuously Employed',ipstat,sum(indv),ipvb

!Variance/Cov for nonemployment spells
V2=xxi2*V2*xxi2
Vbig(:,ipvb+1)=Vbig(:,ipvb+1)*xxi2(1,1)
do j=1,1
 pstat(ipstat+j)=bols2(j)
 sepstat(ipstat+j)=sqrt(V2(j,j))
enddo
indv(ipvb+1)=1
ipvb=ipvb+1
ipstat=ipstat+1

naux=ipstat
write(6,*) 'Wage Change with Nonemployment Spell',ipstat,naux,sum(indv),ipvb

open(112,file='Vbig')
do i=1,nn
 write(112,*) Vbig(i,1:ipvb)
enddo
do j1=1,700
 do j2=1,700
  Var(j1,j2)=dot_product(Vbig(:,j1),Vbig(:,j2))
 enddo
enddo


ia=0
open(114,file='V')
open(113,file='indv')
do j=1,ipvb
 write(114,*) (Var(j,l),l=1,ipvb)
 write(113,*) indv(j)
enddo

open(115,file='data_moments')
do j=1,ipstat
 write(115,*) pstat(j),sepstat(j)
enddo





end
