clear all
set more off
set scheme s1mono

global codes C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Simulation_Codes
global IN C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Model_Estimates
global Results C:/Users/Fernando/Dropbox/Training_RR/JAE_Replication/Results


use $IN/simdata.dta, clear


rename salaryx salary_X1
rename mosal_usd_wage1 salary_X2 
rename mosal_usd_wage4 salary_X3
rename ptje_nem nem


cap drop sd* var* share*

matrix vardec_test = J(5,4,.)
matrix vardec_wage0 = J(5,4,.)
matrix vardec_wage1 = J(5,4,.)

local j = 1
foreach x in mate verbal nem salary_X1 salary_X2  {

	egen sd`x'_xb = sd(cov_`x')
	egen sd`x'_theta_prod = sd(`x'_fac_prod)
	egen sd`x'_theta_test = sd(`x'_fac_test)
	egen sd`x'_epsilon = sd(eps_`x')
	gen var`x' = sd`x'_xb ^ 2 + sd`x'_theta_prod^2  + sd`x'_theta_test^2 +  sd`x'_epsilon^2
	
	egen var`x'_true = sd(`x')
	
	gen share_obs_`x' = sd`x'_xb^2 / var`x'_true 
	gen share_factor_prod_`x' = sd`x'_theta_prod^2 / var`x'_true 
	gen share_factor_test_`x' = sd`x'_theta_test^2 / var`x'_true 
	gen share_error_`x' = 1 - share_obs_`x' - share_factor_prod_`x'  - share_factor_test_`x' 

qui sum share_obs_`x'
matrix vardec_test [`j',1] = r(mean)
qui sum share_factor_prod_`x'
matrix vardec_test [`j',2] = r(mean)
qui sum share_factor_test_`x'
matrix vardec_test [`j',3] = r(mean)
qui sum share_error_`x'
matrix vardec_test [`j',4] = r(mean)	
	
local ++j
}

*************************************

svmat vardec_test, names(type)

rename type1 Observables
rename type2 Productivity_Factor
rename type3 Cognitive_Factor
rename type4 Error

*gen test = "General Science"
gen test = "Math Test"
replace test = "Language Test" if _n == 2
replace test = "High School GPA" if _n == 3
replace test = " Initial Wage (I)" if _n == 4
replace test = " Initial Wage (II)" if _n == 5

graph hbar Observables Productivity_Factor Cognitive_Factor Error, over(test) stack legend(label(1 "Observables") /*
*/label(2 "Productivity Factor")  label(3 "Cognitive Factor") label(4 "Error")) /*
*/ ylabel(, nogrid) /*
*/ graphregion(fcolor(white) ifcolor(white) lcolor(white) ilcolor(white))/*
*/ plotregion(fcolor(white) lcolor(white)  ifcolor(white) ilcolor(white)) 

graph export "$Results/vardec_2w.pdf", replace 
