clear all
set more off

set seed 2893428
set obs 5000

generate u1=runiform()
generate f1 = rnormal()*sqrt(1)+1 if u1<0.3
replace f1 = rnormal()*0.622269-0.42857143  if u1>=0.3
drop u?

generate X=rnormal()
generate Q=rnormal()
generate Z=rnormal()
generate uv=rnormal()
generate u1=rnormal()
generate u0=rnormal()
forvalues i=1/3{
	generate e`i'=rnormal()
}

generate t1 =0.1 +0.1 *Q  +1.1*f1+e1
generate t2 =0.5 +0.1 *Q  +1.4*f1+e2
generate t3 =0.4 +0.3 *Q  +    f1+e3

*Training Decision*
generate D=(0.5*Z + 0.5*f1 + uv>0)
generate Y1 = 2   +2*X + 2*f1 + u1
generate Y0 = 1.5 +X +  f1 + u0
generate Y = D*Y1   + (1-D)*Y0

gen Y1_obs = Y1 if D==1
replace Y1_obs = -999 if D==0
gen Y1_obs_m = (Y1_obs ~= -999)

gen Y0_obs = Y0 if D==0
replace Y0_obs = -999 if D==1
gen Y0_obs_m = (Y0_obs ~= -999)

gen constant = 1 
gen ones = 1

save data.dta, replace 

outfile using data.raw, replace noquote nolabel wide
