***************************************************************************************
* Empirical Application for "Estimation of Average Treatment Effects Using Panel Data * 
* when Treatment Effect Heterogeneity Depends on Unobserved Fixed Effects"            * 
***************************************************************************************

*****************************************************
*   This file generates results in Tables 2 and 3   *
*****************************************************

clear
clear mata

set mem 300m
set type double
set more off

** Open the dataset **
*cd "C:\Users\Shosei Sakaguchi\OneDrive\Project panel_ate\Empirical Application"
import delimited birpanel2006.csv

qui bys id (child): egen maxchild=max(child)

** Manage Data **
drop if maxchild==2
gen firstchild = 0
gen secondchild = 0
gen thirdchild = 0
replace firstchild = 1 if child==1
replace secondchild = 1 if child==2
replace thirdchild = 1 if child==3

* Note: hschool somecol colgrad married black do not vary over children *

* Generate new variables *
gen nosmoke = 1 - smoke

foreach vv of varlist birthwght smoke male age agesq kessner2 kessner3 novisit visit2 visit3 educ somecol married black hschool colgrad firstchild secondchild thirdchild{ 
gen `vv'1= smoke*`vv'
gen `vv'0= (1 - smoke)*`vv'
}

foreach vv of varlist birthwght smoke male age agesq kessner2 kessner3 novisit visit2 visit3 educ somecol married black hschool colgrad firstchild secondchild thirdchild{ 
bys id (child) : gen `vv'_first= `vv'[1]
bys id (child) : gen `vv'_second= `vv'[2]
bys id (child) : gen `vv'_third= `vv'[3]
bys id (child) : gen `vv'0_first= `vv'0[1]
bys id (child) : gen `vv'0_second= `vv'0[2]
bys id (child) : gen `vv'0_third= `vv'0[3]
bys id (child) : gen `vv'1_first= `vv'1[1]
bys id (child) : gen `vv'1_second= `vv'1[2]
bys id (child) : gen `vv'1_third= `vv'1[3]
}

sort child
foreach vv of varlist male age agesq kessner2 kessner3 novisit visit2 visit3 educ somecol married black hschool colgrad firstchild secondchild thirdchild{
by child: egen `vv'_mean= mean(`vv')
by child: gen `vv'_dif = `vv'-`vv'_mean
gen smoke_`vv'_dif = smoke*`vv'_dif
}
sort id child

gen mover = 0
replace mover = 1 if smoke_first + smoke_second + smoke_third==1 | smoke_first + smoke_second + smoke_third==2
gen stayer0 = 0
replace stayer0 = 1 if smoke_first + smoke_second + smoke_third==0 
gen stayer1 = 0
replace stayer1 = 1 if smoke_first + smoke_second + smoke_third==3
gen long_smoker = 0

foreach vv of varlist birthwght smoke male age agesq kessner2 kessner3 novisit visit2 visit3 educ somecol married black hschool colgrad firstchild secondchild thirdchild{ 
gen bar`vv'1 = 0
replace bar`vv'1= (`vv'1_first + `vv'1_second + `vv'1_third)/(smoke_first + smoke_second + smoke_third) if stayer0==0
gen bar`vv'0 = 0
replace bar`vv'0= (`vv'0_first + `vv'0_second + `vv'0_third)/(3 - smoke_first - smoke_second - smoke_third) if stayer1==0
gen dif`vv'1 = 0
replace dif`vv'1= `vv'1 - bar`vv'1 if stayer0==0
gen dif`vv'0 = 0
replace dif`vv'0= `vv'0 - bar`vv'0 if stayer1==0
}

***FE results***
xtset id child
**Time-varying ATE**
set more off
xtreg birthwght smoke_first smoke_second smoke_third smoke_age_dif smoke_agesq_dif smoke_male_dif smoke_kessner2_dif ///
smoke_kessner3_dif smoke_novisit_dif smoke_visit2_dif smoke_visit3_dif age_dif agesq_dif male_dif kessner2_dif kessner3_dif novisit_dif visit2_dif ///
visit3_dif firstchild_dif secondchild_dif thirdchild_dif smoke_firstchild_dif smoke_secondchild_dif smoke_thirdchild_dif, vce(robust)
**Time-invariant ATE**
set more off
xtreg birthwght smoke age agesq male kessner2 kessner3 novisit visit2 visit3 firstchild secondchild thirdchild, vce(robust)

***The results of proposed approach***

**Time-varying ATE**

**IV is age**

local IV1="difsecondchild0 difthirdchild0 difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difsecondchild1 difthirdchild1 difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="age"
local IV4 ="age"

set more off
gmm (1: (1-stayer1)*(difbirthwght0 - {b1}*difsecondchild0 -{b2}*difthirdchild0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {c1}*difsecondchild1 - {c2}*difthirdchild1 - {c3}*difage1 - {c4}*difagesq1 - {c5}*difmale1 ///
- {c6}*difkessner21 - {c7}*difkessner31 - {c8}*difnovisit1 - {c9}*difvisit21 - {c10}*difvisit31)) ///
(3: smoke*mover*(birthwght1 - {a1} - {c1}*secondchild1 - {c2}*thirdchild1 - {c3}*age1 - {c4}*agesq1 - {c5}*male1 ///
- {c6}*kessner21 - {c7}*kessner31 - {c8}*novisit1 - {c9}*visit21 - {c10}*visit31 ///
- {gamma1=2}*(barbirthwght0 - {b1}*barsecondchild0 - {b2}*barthirdchild0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: nosmoke*mover*(birthwght0 - {a0} - {b1}*secondchild0 - {b2}*thirdchild0 - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=2}))*(barbirthwght1 - {c1}*barsecondchild1 - {c2}*barthirdchild1 - {c3}*barage1 - {c4}*baragesq1 - {c5}*barmale1 ///
- {c6}*barkessner21 - {c7}*barkessner31 - {c8}*barnovisit1 - {c9}*barvisit21 - {c10}*barvisit31))) ///
(5: firstchild*(smoke*(birthwght1 - ({a0}  + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght  - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate1})) ///
(6: secondchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate2})) ///
(7: thirdchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght- {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate3})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)

*Difference estimates*
lincom [b1]_cons - [c1]_cons
lincom [b2]_cons - [c2]_cons
lincom [b3]_cons - [c3]_cons
lincom [b4]_cons - [c4]_cons
lincom [b5]_cons - [c5]_cons
lincom [b6]_cons - [c6]_cons
lincom [b7]_cons - [c7]_cons
lincom [b8]_cons - [c8]_cons
lincom [b9]_cons - [c9]_cons
lincom [b10]_cons - [c10]_cons

**IV is education**

local IV1="difsecondchild0 difthirdchild0 difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difsecondchild1 difthirdchild1 difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="educ"
local IV4 ="educ"

set more off
gmm (1: (1-stayer1)*(difbirthwght0 - {b1}*difsecondchild0 -{b2}*difthirdchild0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {c1}*difsecondchild1 - {c2}*difthirdchild1 - {c3}*difage1 - {c4}*difagesq1 - {c5}*difmale1 ///
- {c6}*difkessner21 - {c7}*difkessner31 - {c8}*difnovisit1 - {c9}*difvisit21 - {c10}*difvisit31)) ///
(3: smoke*mover*(birthwght1 - {a1} - {c1}*secondchild1 - {c2}*thirdchild1 - {c3}*age1 - {c4}*agesq1 - {c5}*male1 ///
- {c6}*kessner21 - {c7}*kessner31 - {c8}*novisit1 - {c9}*visit21 - {c10}*visit31 ///
- {gamma1=2}*(barbirthwght0 - {b1}*barsecondchild0 - {b2}*barthirdchild0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: nosmoke*mover*(birthwght0 - {a0} - {b1}*secondchild0 - {b2}*thirdchild0 - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=2}))*(barbirthwght1 - {c1}*barsecondchild1 - {c2}*barthirdchild1 - {c3}*barage1 - {c4}*baragesq1 - {c5}*barmale1 ///
- {c6}*barkessner21 - {c7}*barkessner31 - {c8}*barnovisit1 - {c9}*barvisit21 - {c10}*barvisit31))) ///
(5: firstchild*(smoke*(birthwght1 - ({a0}  + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght  - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate1})) ///
(6: secondchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate2})) ///
(7: thirdchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght- {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate3})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)

*Difference estimates*
lincom [b1]_cons - [c1]_cons
lincom [b2]_cons - [c2]_cons
lincom [b3]_cons - [c3]_cons
lincom [b4]_cons - [c4]_cons
lincom [b5]_cons - [c5]_cons
lincom [b6]_cons - [c6]_cons
lincom [b7]_cons - [c7]_cons
lincom [b8]_cons - [c8]_cons
lincom [b9]_cons - [c9]_cons
lincom [b10]_cons - [c10]_cons


**IVs are age and education**

local IV1="difsecondchild0 difthirdchild0 difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difsecondchild1 difthirdchild1 difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="age educ"
local IV4 ="age educ"

set more off
gmm (1: (1-stayer1)*(difbirthwght0 - {b1}*difsecondchild0 -{b2}*difthirdchild0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {c1}*difsecondchild1 - {c2}*difthirdchild1 - {c3}*difage1 - {c4}*difagesq1 - {c5}*difmale1 ///
- {c6}*difkessner21 - {c7}*difkessner31 - {c8}*difnovisit1 - {c9}*difvisit21 - {c10}*difvisit31)) ///
(3: smoke*mover*(birthwght1 - {a1} - {c1}*secondchild1 - {c2}*thirdchild1 - {c3}*age1 - {c4}*agesq1 - {c5}*male1 ///
- {c6}*kessner21 - {c7}*kessner31 - {c8}*novisit1 - {c9}*visit21 - {c10}*visit31 ///
- {gamma1=2}*(barbirthwght0 - {b1}*barsecondchild0 - {b2}*barthirdchild0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: nosmoke*mover*(birthwght0 - {a0} - {b1}*secondchild0 - {b2}*thirdchild0 - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=2}))*(barbirthwght1 - {c1}*barsecondchild1 - {c2}*barthirdchild1 - {c3}*barage1 - {c4}*baragesq1 - {c5}*barmale1 ///
- {c6}*barkessner21 - {c7}*barkessner31 - {c8}*barnovisit1 - {c9}*barvisit21 - {c10}*barvisit31))) ///
(5: firstchild*(smoke*(birthwght1 - ({a0}  + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght  - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate1})) ///
(6: secondchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght - {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate2})) ///
(7: thirdchild*(smoke*(birthwght1 - ({a0} + {b1}*secondchild + {b2}*thirdchild + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1=2})*(birthwght - {c1}*secondchild - {c2}*thirdchild - {c3}*age - {c4}*agesq - {c5}*male ///
- {c6}*kessner2 - {c7}*kessner3 - {c8}*novisit - {c9}*visit2 - {c10}*visit3))) ///
+ nosmoke*(({a1} + {c1}*secondchild + {c2}*thirdchild + {c3}*age + {c4}*agesq + {c5}*male ///
+ {c6}*kessner2 + {c7}*kessner3 + {c8}*novisit + {c9}*visit2 + {c10}*visit3 ///
+ {gamma1=2}*(birthwght- {b1}*secondchild - {b2}*thirdchild - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate3})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)

*Difference estimates*
lincom [b1]_cons - [c1]_cons
lincom [b2]_cons - [c2]_cons
lincom [b3]_cons - [c3]_cons
lincom [b4]_cons - [c4]_cons
lincom [b5]_cons - [c5]_cons
lincom [b6]_cons - [c6]_cons
lincom [b7]_cons - [c7]_cons
lincom [b8]_cons - [c8]_cons
lincom [b9]_cons - [c9]_cons
lincom [b10]_cons - [c10]_cons


**Time-invariant ATE**

*IV is age*

local IV1="difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="age1"
local IV4 ="age0"

gmm (1: (1-stayer1)*(difbirthwght0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {b3}*difage1 - {b4}*difagesq1 - {b5}*difmale1 ///
- {b6}*difkessner21 - {b7}*difkessner31 - {b8}*difnovisit1 - {b9}*difvisit21 - {b10}*difvisit31)) ///
(3: mover*(birthwght1 - {a1} - {b3}*age1 - {b4}*agesq1 - {b5}*male1 ///
- {b6}*kessner21 - {b7}*kessner31 - {b8}*novisit1 - {b9}*visit21 - {b10}*visit31 ///
- {gamma1=1}*(barbirthwght0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: mover*(birthwght0 - {a0} - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=1}))*(barbirthwght1 - {b3}*barage1 - {b4}*baragesq1 - {b5}*barmale1 ///
- {b6}*barkessner21 - {b7}*barkessner31 - {b8}*barnovisit1 - {b9}*barvisit21 - {b10}*barvisit31))) ///
(5: (smoke*(birthwght1 - ({a0} + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1})*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))) ///
+ nosmoke*(({a1} + {b3}*age + {b4}*agesq + {b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ {gamma1}*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)

*IV is educ*

local IV1="difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="educ1"
local IV4 ="educ0"

gmm (1: (1-stayer1)*(difbirthwght0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {b3}*difage1 - {b4}*difagesq1 - {b5}*difmale1 ///
- {b6}*difkessner21 - {b7}*difkessner31 - {b8}*difnovisit1 - {b9}*difvisit21 - {b10}*difvisit31)) ///
(3: mover*(birthwght1 - {a1} - {b3}*age1 - {b4}*agesq1 - {b5}*male1 ///
- {b6}*kessner21 - {b7}*kessner31 - {b8}*novisit1 - {b9}*visit21 - {b10}*visit31 ///
- {gamma1=1}*(barbirthwght0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: mover*(birthwght0 - {a0} - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=1}))*(barbirthwght1 - {b3}*barage1 - {b4}*baragesq1 - {b5}*barmale1 ///
- {b6}*barkessner21 - {b7}*barkessner31 - {b8}*barnovisit1 - {b9}*barvisit21 - {b10}*barvisit31))) ///
(5: (smoke*(birthwght1 - ({a0} + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1})*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))) ///
+ nosmoke*(({a1} + {b3}*age + {b4}*agesq + {b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ {gamma1}*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)

*IVs are age and educ*

local IV1="difage0 difagesq0 difmale0 difkessner20 difkessner30 difnovisit0 difvisit20 difvisit30"
local IV2="difage1 difagesq1 difmale1 difkessner21 difkessner31 difnovisit1 difvisit21 difvisit31"
local IV3 ="age1 educ1"
local IV4 ="age0 educ0"

gmm (1: (1-stayer1)*(difbirthwght0 - {b3}*difage0 - {b4}*difagesq0 - {b5}*difmale0 ///
- {b6}*difkessner20 - {b7}*difkessner30 - {b8}*difnovisit0 - {b9}*difvisit20 - {b10}*difvisit30)) ///
(2: (1-stayer0)*(difbirthwght1 - {b3}*difage1 - {b4}*difagesq1 - {b5}*difmale1 ///
- {b6}*difkessner21 - {b7}*difkessner31 - {b8}*difnovisit1 - {b9}*difvisit21 - {b10}*difvisit31)) ///
(3: mover*(birthwght1 - {a1} - {b3}*age1 - {b4}*agesq1 - {b5}*male1 ///
- {b6}*kessner21 - {b7}*kessner31 - {b8}*novisit1 - {b9}*visit21 - {b10}*visit31 ///
- {gamma1=1}*(barbirthwght0 - {b3}*barage0 - {b4}*baragesq0 - {b5}*barmale0 ///
- {b6}*barkessner20 - {b7}*barkessner30 - {b8}*barnovisit0 - {b9}*barvisit20 - {b10}*barvisit30))) ///
(4: mover*(birthwght0 - {a0} - {b3}*age0 - {b4}*agesq0 - {b5}*male0 ///
- {b6}*kessner20 - {b7}*kessner30 - {b8}*novisit0 - {b9}*visit20 - {b10}*visit30 ///
- (1/({gamma1=1}))*(barbirthwght1 - {b3}*barage1 - {b4}*baragesq1 - {b5}*barmale1 ///
- {b6}*barkessner21 - {b7}*barkessner31 - {b8}*barnovisit1 - {b9}*barvisit21 - {b10}*barvisit31))) ///
(5: (smoke*(birthwght1 - ({a0} + {b3}*age +{b4}*agesq +{b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ (1/{gamma1})*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))) ///
+ nosmoke*(({a1} + {b3}*age + {b4}*agesq + {b5}*male ///
+ {b6}*kessner2 + {b7}*kessner3 + {b8}*novisit + {b9}*visit2 + {b10}*visit3 ///
+ {gamma1}*(birthwght - {b3}*age - {b4}*agesq - {b5}*male ///
- {b6}*kessner2 - {b7}*kessner3 - {b8}*novisit - {b9}*visit2 - {b10}*visit3))- birthwght) ///
- {ate})), ///
instruments(1:`IV1', noconstant) ///
instruments(2:`IV2', noconstant) ///
instruments(3:`IV3') ///
instruments(4:`IV4') winitial(identity)



