function results = CriticalValuesGeneral(S, rho, mu, k, l, T, G, F, B, mc)
% Calculates the critical values under general condition
% in Theorem 5. Estimation window is rolling, m is rolling.
% results(:,1) - general critical values under Theorem 5
% results(:,2) - critical values under West and McCracken as in Prop 7
% results(:,2) is similar to that in CriticalValuesTable
% additional file is created to make calculations faster if West and
% McCracken holds
R = round(rho*T); m = round(mu*T);
[U D V] = svd(S);

parfor i = 1:mc
    stream = RandStream('mrg32k3a','seed',4829575);
    stream.Substream = i;
    eps = randn(stream, k+l, T+1);

    Bappxtau = []; Bappxtaumu = []; 
    BappxtauWM = []; BappxtaumuWM = []; 

    Bappxwm = [];
    Bappxalt = [];
    
    vt1 = []; vt2 = [];
    vtalt = [];
    
    Waldcrit = zeros(T-(R+m)+1,1);
    WaldcritgenWM = zeros(T-(R+m)+1,1);
    
    for j = R+m:T+1
        pidagger = mu/rho;
        if mu >= rho
            lambda = 2/(3*pidagger);
        else
            lambda = (1 - 1/3*pidagger^2);
        end
        
        [Omegatau Omegataumu] = RollWeights(j,R,m,T,l,k);
        
        Br = 0;
        var1 = 0;
        BrWM = 0;
        for t = 1:j-1
            %sqrt(1/T) is there since the integral is defined from 0 to 1
            %while the sum is from 1 to T with a step-size of 1, so the number
            %of discrete points is 1/T
            littleomegatilda = mu^(-1/2)*inv(G)*[eye(l) F*B]*Omegatau(:,:,t);
            littleomegatildawm = mu^(-1)*(Omegatau(1,1,t)-Omegatau(end,end,t))^2;
            var1 = var1 + littleomegatilda*S*littleomegatilda'.*1/T;
            littleomegatilda = littleomegatilda*U;
            littleomegatildawm = sqrt(littleomegatildawm)*eye(l);
            Br = Br + littleomegatilda*[sqrt(U(:,1:rank(S))'*S*U(:,1:rank(S)))*eps(1:rank(S),t); zeros(size(littleomegatilda,2)-rank(S),1)]*sqrt(1/T);
            BrWM = BrWM + littleomegatildawm*[eps(1:l,t)]*sqrt(1/T);
        end
        Bappxtau = [Bappxtau; Br'];
        BappxtauWM = [BappxtauWM; BrWM'];
        vt1 = [vt1; var1];

        Brm = 0;
        var2 = 0;
        BrmWM = 0;
        for t = 1:j-m-1
            %sqrt(1/T) is there since the integral is defined from 0 to 1
            %while the sum is from 1 to T with a step-size of 1, so the number
            %of discrete points is 1/T
            littleomegamtilda = mu^(-1/2)*inv(G)*[eye(l) F*B]*Omegataumu(:,:,t);
            littleomegamtildawm = mu^(-1)*(Omegataumu(1,1,t)-Omegataumu(end,end,t))^2;
            var2 = var2 + littleomegamtilda*S*littleomegamtilda'.*1/T;
            littleomegamtilda = littleomegamtilda*U;
            littleomegamtildawm = sqrt(littleomegamtildawm)*eye(l);
            Brm = Brm + littleomegamtilda*[sqrt(U(:,1:rank(S))'*S*U(:,1:rank(S)))*eps(1:rank(S),t); zeros(size(littleomegamtilda,2)-rank(S),1)]*sqrt(1/T);
            BrmWM = BrmWM + littleomegamtildawm*[eps(1:l,t)]*sqrt(1/T);
        end
        Bappxtaumu = [Bappxtaumu; Brm'];
        BappxtaumuWM = [BappxtaumuWM; BrmWM'];
        vt2 = [vt2; var2];
        
        Bappx = Bappxtau - Bappxtaumu;
        BappxgenWM = BappxtauWM - BappxtaumuWM;

        vtwm = lambda;
                
        Balt = 0;
        varalt = 0;
        for t = 1:j-1
            %sqrt(1/T) is there since the integral is defined from 0 to 1
            %while the sum is from 1 to T with a step-size of 1, so the number
            %of discrete points is 1/T
            if t < j-m
                littleomega = mu^(-1/2)*inv(G)*[eye(l) F*B]*(Omegatau(:,:,t) - Omegataumu(:,:,t));
            else
                littleomega = mu^(-1/2)*inv(G)*[eye(l) F*B]*Omegatau(:,:,t);
            end
            varalt = varalt + littleomega*S*littleomega'/T; 
            littleomega = littleomega*U;
            Balt = Balt + littleomega*[sqrt(U(:,1:rank(S))'*S*U(:,1:rank(S)))*eps(1:rank(S),t); zeros(size(littleomega,2)-rank(S),1)]*sqrt(1/T);
        end
        vtalt = [vtalt; varalt];
        Bappxalt = [Bappxalt; Balt'];
  
        Waldcrit(j-R-m+1,1) =  Bappx(end,:)*inv(varalt)*Bappx(end,:)';
        WaldcritgenWM(j-R-m+1,1) = BappxgenWM(end,:)*inv(vtwm)*BappxgenWM(end,:)';    
    end
    
    supWaldcrit(:,i) =  max(Waldcrit,[],1);
    supWaldcritgenWM(:,i) =  max(WaldcritgenWM,[],1);
    
    if (i == 100 || i == 200 || i == 400 || i == 600 || i == 800)
        disp(num2str(i))
    end
end
results(:,1) = prctile(supWaldcrit,95,2);
results(:,2) = prctile(supWaldcritgenWM,95,2);