function result = olsttest(y,x)
%Calculates ols t-tests for H0:beta=0 in the model y=x*beta+eps where eps is iid

[n k] = size(x);
phi = zeros(k,1); res=zeros(n,1);
coeff = ((inv(x'*x))*(x'*y))';
res = y-x*coeff';


varbetahat = ((((res'*res)/(size(res,1)-k))*((inv(x'*x)))));
sebetahat = sqrt(diag(varbetahat))';

result = coeff./sebetahat;