% Runs the size exercises for Table 2, Rolling Estimation, Efficiency
% Regression
%myCluster = parcluster('local');
%delete(myCluster.Jobs);
matlabpool close force local
clear all
randn('seed',837656503); 

Rvec = [25; 50; 100; 200; 300; 400]
Pvec = [100; 200];
sizev = [1; 5; 10];

tableMPE = nan(size(Rvec,1),size(Pvec,1));     
tableMPEWM = nan(size(Rvec,1),size(Pvec,1)); 
tableMPEWMfull = nan(size(Rvec,1),size(Pvec,1)); 


% select the variance estimator
varestflag = 1; % West&McCracken - 1
                % General Variance - 0
efficflag = 1;  % efficiency if =1, MPE if =0

mc = 1000;
mccv = 1000;

m = 50;
for indexP=1:1:size(Pvec,1) 
    P = Pvec(indexP,1);
    
    for indexR=1:1:size(Rvec,1); 
        R = Rvec(indexR,1); 

        T = R+P; 
        rho = R/T; mu = m/T;

        pidagger = mu/rho;
        if mu>=rho
            lambda = 2/(3*pidagger);
        else
            lambda = (1 - 1/3*pidagger^2);
        end

        reject = zeros(1,2);
        rejectfull = 0;
        alpha1 = 0;
        alpha2 = 0.5;

            for i = 1:mc
                clear eps yy x
                eps = randn(T+1,1);
                
                % regression with the AR
                yy(1,1) = alpha1/(1-alpha2) + sqrt(inv(1-alpha2^2))*randn(1,1);
                for j = 2:T+2
                    yy(j,1) = alpha1 + yy(j-1,1)*alpha2 + eps(j-1,1);
                end
                y = yy(2:end,1);
                % estimates a model with a constant, even though the
                % generated data does not have a constant. This is done to
                % make Proposition 7 hold
                x = [ones(size(yy,1)-1,1) yy(1:end-1,1)];
 
                gammahat=[]; v=[];
                fhhat = []; fcst = [];
                htot = [];

                for t = R:T
                    gammahat = [gammahat; regress(y(t-R+1:t,1), x(t-R+1:t,:))'];

                    forecast = x(t+1,:)*gammahat(end,:)';
                    v = [v; y(t+1,1)- forecast];
                    fcst = [fcst; forecast];
                    htot = [htot; x(t,:).*(y(t,1)- x(t,:)*gammahat(end,:)')'];
                end

                if efficflag == 1
                    g = fcst; 
                elseif efficflag==0
                    g = ones(P+1,1); 
                end
                fhhat = [mmult(v,g) htot]; 

                k = size(x,2); l = size(g,2);
                v = [nan*ones(R,1);v]; 
                g = [nan*ones(R,l);g];
                fhhat = [nan*ones(R,size(fhhat,2));fhhat];

                thetahat=[]; Waldstats = [];
                for j = R+m:T+1
                    B = (x(j-m+1:j,:)'*x(j-m+1:j,:)./size(x(j-m+1:j,:),1))^(-1);
                    G = g(j-m+1:j,:)'*g(j-m+1:j,:)./m; 
                    F = -g(j-m+1:j,:)'*x(j-m+1:j,:)./m;
                    S = cov(fhhat(j-m+1:j,:));

                    thetahat = [thetahat; regress(v(j-m+1:j,:),g(j-m+1:j,:))'*sqrt(m)];
                    e = (v(j-m+1:j,:) - g(j-m+1:j,:)*(thetahat(end,:)./sqrt(m))');

                    [Omegatau Omegataumu] = RollWeights(j,R,m,T,l,k);

                    vartheta = 0; littleomegav = [];
                    for t = 1:j-1
                        if t < j-m
                            littleomega = mu^(-1/2)*inv(G)*[eye(l) F*B]*(Omegatau(:,:,t) - Omegataumu(:,:,t));
                        else
                            littleomega = mu^(-1/2)*inv(G)*[eye(l) F*B]*Omegatau(:,:,t);
                        end
                        littleomegav = [littleomegav; littleomega];
                        vartheta = vartheta + littleomega*S*littleomega'/T;                 
                    end

                    if varestflag == 1
                        varest = lambda*inv(G)*S(1:l,1:l)*inv(G');
                    else
                        varest = vartheta;
                    end
                        
                    Waldstats = [Waldstats; thetahat(end,:)*inv(varest)*thetahat(end,:)'];
                end
                supWaldMC(:,i) = max(Waldstats);

                if (i == 1)
                    results = CriticalValuesTable(rho, mu, 1000, mccv, sizev, l);
                end

                reject = reject + (supWaldMC(:,i) >= results(1,2))./mc;
                
                paifull = P/R; 
                if paifull > 1
                    lambdafull = 2/(3*paifull); 
                else
                    lambdafull = 1-(paifull^2)/3; 
                end
                Waldfull = (olsttestt(v(R+1:T),g(R+1:T,:))*1/sqrt(lambdafull))^2; 
                rejectfull = rejectfull + (Waldfull>icdf('chi2',0.95,1))./mc; 
            end
        tableMPE(indexR,indexP)  = reject(1,1)
        tableMPEWM(indexR,indexP)  = reject(1,2)
        tableMPEWMfull(indexR,indexP)  =  rejectfull
    end
end

if efficflag == 0    % efficiency if =1, MPE if =0
    delete MCRollingSizeMPE.out; 
    diary MCRollingSizeMPE.out;
else
    delete MCRollingSizeEfficiency.out; 
    diary MCRollingSizeEfficiency.out;
end
disp('T, R, m')
[T R m]
disp('rejection rates')
disp('General Estimator')
disp(tableMPE)
disp('West and McCracken Estimator')
disp(tableMPEWM)
disp('West and McCracken Traditional')
disp(tableMPEWMfull)
diary off