% Runs the size exercises for Table 2, Recursive Estimation,
%DGP: y(t)=a*y(t-1)+e(t), a=0.5
matlabpool close force local
clear all
randn('seed',1000);

Rvec = [25; 50; 100; 200; 300; 400]; 
Pvec = [100; 200];
m=50; 

tablefullMPE = nan(size(Rvec,1),size(Pvec,1));   tablefluctMPE = nan(size(Rvec,1),size(Pvec,1));
tablefullEff = nan(size(Rvec,1),size(Pvec,1));   tablefluctEff = nan(size(Rvec,1),size(Pvec,1));

mc = 1000;
mccv = 1000;
sizev = [1; 5; 10];
for indexP = 1:1:size(Pvec,1)
    P = Pvec(indexP,1);
    for indexR = 1:1:size(Rvec,1); 
        R = Rvec(indexR,1); 
        T = R + P;
    
        rho = R/T; mu=m/T;
    
        cvall = CriticalValuesAlternative(rho, mu, 1000, mccv, sizev, 1);
        cv = cvall(1,2); % 5 percent critical values
    
        rejMPE = [];  rejfluctMPE = [];
        rejEff = [];  rejfluctEff = [];
    
        for rep = 1:mc
            eps = randn(T+1,1); a = 0.5; y0 = sqrt(inv(1-a^2))*randn(1,1); 
            y1 = recserar(eps,y0,a); y = y1(2:end,1); x = y1(1:end-1,:);
            forecasts = []; actual = []; forecasterror = [];
            for j = R:T-1;
                forecasts=[forecasts; regress(y(1:j),x(1:j))*x(j+1,:)];
                forecasterror=[forecasterror; y(j+1,:)-forecasts(end,1)];
                actual=[actual; y(j+1,:)]; 
            end
        
            %MEAN PREDICTION ERROR
            %Traditional test
            MZfullsampleMPE = (olsttestt(forecasterror,ones(P,1)))^2; 
            rejMPE = [rejMPE; MZfullsampleMPE > icdf('chi2',0.95,1)]; 
        
            %Fluctuation test
            resultMPE = FluctuationRationalityRec(m,forecasterror,ones(P,1),[]);
            if resultMPE.maxw > cv; rejF=1; else; rejF=0; end 
            rejfluctMPE = [rejfluctMPE; rejF];

            %EFFICIENCY
            %Traditional test
            MZfullsampleEff = olsWaldtest(forecasterror,forecasts,ones(P,1));
            rejEff = [rejEff; MZfullsampleEff > icdf('chi2',0.95,1)]; 

            %Fluctuation test
            resultEff = FluctuationRationalityRec(m,forecasterror,forecasts,ones(P,1));
            if resultEff.maxw > cv; rejE=1; else; rejE=0; end; 
            rejfluctEff = [rejfluctEff; rejE];     
        end 
    
        tablefullMPE(indexR,indexP)  = mean(rejMPE);
        tablefluctMPE(indexR,indexP) = mean(rejfluctMPE);
    
        tablefullEff(indexR,indexP)  = mean(rejEff);
        tablefluctEff(indexR,indexP) = mean(rejfluctEff);
    end 
end
delete MCRecursive.out; diary MCRecursive.out; 
disp('Empirical Rejection Frequencies for Mean Prediction Error');
disp('Full sample     Fluctuation'); 
disp('R in rows, P in columns');
disp([nan, Pvec'; [Rvec, tablefullMPE]]); disp([nan, Pvec'; [Rvec, tablefluctMPE]]);

disp('Empirical Rejection Frequencies for Efficiency Tests');
disp('Full sample     Fluctuation'); 
disp('R in rows, P in columns');
disp([nan, Pvec'; [Rvec, tablefullEff]]); disp([nan, Pvec'; [Rvec, tablefluctEff]]);
diary off; 