function result = FluctuationRationalityRec(m,forecasterror,x1,x2)
%   INPUT: m=size of rolling window
%	forecasterror = actual - forecast
%	x1 is the variable you want to test coefficients equal to zero, x2 is the other regressors
%   if want to test all coefficients, specify x2 = []
P = size(forecasterror,1); 
resultcum=[];
for t = m:P  
    if (isempty(x2) == 1)
        out = olsWaldtest(forecasterror(t-m+1:t,:),x1(t-m+1:t,:)); 
    else
        out = olsWaldtest(forecasterror(t-m+1:t,:),x1(t-m+1:t,:),x2(t-m+1:t,:));
    end        
    resultcum = [resultcum; out];
end
result.maxw = max(resultcum);
result.wseries = resultcum;