function results = CriticalValuesAlternative(rho, mu, T, mc, sizev, l)
% executable file to get the critical values corresponding to Table 1,
% Panel A. This is an alternative to CriticalValuesTable.m file and
% simulates the Brownians as being neuisance parameter free. This code runs
% faster than the CriticalValuesTable.m
R = round(rho*T);
m = round(mu*T);

MCvSUPwald = zeros(mc,1); 
parfor i = 1:mc
    stream = RandStream('mrg32k3a','seed',4829575);
    stream.Substream = i;
    eps = randn(stream,l,T);
    Wv=[];
    for tau = R+m:T
          Asum = []; 
          for s = 1:l
              Asum = [Asum; (sum(eps(s,tau-m+1:tau),2)/sqrt(m))]; 
          end
          Wv = [Wv;Asum'*Asum];
    end
    MCvSUPwald(i,1) = max(Wv);
end

results(1,1) = prctile(MCvSUPwald, 100-sizev(1,1), 1);
results(1,2) = prctile(MCvSUPwald, 100-sizev(2,1), 1);
results(1,3) = prctile(MCvSUPwald, 100-sizev(3,1), 1);