function result = olsWaldtest(y,x1,x2)
%Calculates ols Wald-tests for H0:beta=0 in the model y=x1*beta+x2*gamma+eps where eps is iid
%If want to test all coefficients, simply use (y,x1) and do not include x2
q = 0;
p = size(x1,2);  
if nargin>2; 
    q = size(x2,2);
    x = [x1,x2]; R = [eye(p), zeros(p,q)];  
else
    x = x1; R = [eye(p)]; 
end

coeff = ((inv(x'*x))*(x'*y));
res = y - x*coeff;
varbetahat = ((((res'*res)/(size(res,1)-p-q))*((inv(x'*x)))));

result = (R*coeff)'*inv(R*varbetahat*R')*R*coeff;