%Monte Carlo codes for the power exercises reported in Table 3 of the paper
%Estimation scheme is recursive, m is rolling
%DGP: y(t)=a*y(t-1)+e(t), a=0.5
%myCluster = parcluster('local');
%delete(myCluster.Jobs);
matlabpool close force local
clear all
randn('seed',1000);

DGP = 3;        % 1-DGP A in Table 3; 2-DGP B in Table 3; 3-DGP C in Table 3
efficflag = 1;  % efficiency if =1, MPE if =0

if (efficflag == 0)
    bvec = [0:0.1:1]; % breaks for mpe
elseif (efficflag == 1)
    bvec = [0:0.5:5]; % breaks for efficiency
end

sizev = [1; 5; 10];

R = 300;    P = 100;    m = 60;
T = R + P;
mu = m/T;
rho = R/T;

mc = 1000;
mccv = 1000;

%cvall = CriticalValuesTable(rho, mu, 1000, mccv, sizev, 1) % the power exercise is with one regression only
cvall = CriticalValuesAlternative(rho, mu, 1000, mccv, sizev, 1);
cv = cvall(1,2); % 5 percent critical values

tablefull = nan(size(bvec,1),1);   tablefluct = nan(size(bvec,1),1);    
for indexb=1:size(bvec,2) 
    bb=bvec(1,indexb); 
    rej=[];  rejfluct=[];

    for rep = 1:mc
        eps = randn(T+1,1); a=0.5; y0 = sqrt(inv(1-a^2))*randn(1,1); 
        P1 = 345; P2= T+1-P1; 
        if (DGP == 1)
            y1=recserar(eps,y0,a)+[bb*ones(P1,1);-bb*ones(P2,1)];
        elseif (DGP == 2)
            y1 = recserar(eps,y0,a) + [0*bb*ones(P1,1);2*bb*ones(P2,1)];
        elseif (DGP == 3)
            y1=recserar(eps,y0,a)+bb*ones(T+1,1);
        end
        y = y1(2:end,1); x = y1(1:end-1,:);
        forecasts = []; forecasterror = [];
        for t = R:T-1
            forecasts = [forecasts; regress(y(1:t),x(1:t))*x(t+1,:)];
            forecasterror = [forecasterror; y(t+1,:) - forecasts(end,1)];
        end
            
        %Traditional test
        if efficflag == 0
            % MPE
            MZfullsample = olsttestt(forecasterror,ones(P,1))^2; 
        else
            % Efficiency
            MZfullsample = olsWaldtest(forecasterror,forecasts,ones(P,1));
        end
        rej = [rej; MZfullsample>icdf('chi2',0.95,1)]; 

        %Fluctuation test
        if efficflag == 0
            %MPE
            out = FluctuationRationalityRec(m,forecasterror,ones(P,1),[]);
        else
            %Efficiency
            out = FluctuationRationalityRec(m,forecasterror,forecasts,ones(P,1));
        end
        MZfluct = out.maxw;
        
        if MZfluct > cv; rejF=1; else; rejF=0; end; 
        rejfluct = [rejfluct; rejF];
    end 
    tablefull(indexb,1)  = mean(rej);
    tablefluct(indexb,1) = mean(rejfluct);
end

if efficflag == 0    % efficiency if =1, MPE if =0
    filename = strcat('MCRecursivePowerMPEDGP', num2str(DGP),'.out')
else
    filename = strcat('MCRecursivePowerEfficiencyDGP', num2str(DGP),'.out')
end

delete(filename); diary(filename); 
disp('Empirical Rejection Frequencies: Recursive');
disp('Full sample     Fluctuation'); 
disp('b in rows, P in columns');
disp([[nan, P; [bvec', tablefull]] [nan, P; [bvec', tablefluct]]]);
diary off; 